/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.event.matching;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.linuxtools.internal.tmf.core.Activator;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.matching.EventMatchingBuildRequest;
import org.eclipse.linuxtools.tmf.core.event.matching.IMatchProcessingUnit;
import org.eclipse.linuxtools.tmf.core.event.matching.ITmfEventMatching;
import org.eclipse.linuxtools.tmf.core.event.matching.ITmfMatchEventDefinition;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;

public abstract class TmfEventMatching
implements ITmfEventMatching {
    private final Collection<ITmfTrace> fTraces;
    private final IMatchProcessingUnit fMatches;
    private static final Map<MatchingType, List<ITmfMatchEventDefinition>> fMatchDefinitions = new HashMap<MatchingType, List<ITmfMatchEventDefinition>>();
    private final Map<ITmfTrace, ITmfMatchEventDefinition> fMatchMap = new HashMap<ITmfTrace, ITmfMatchEventDefinition>();

    public TmfEventMatching(Collection<ITmfTrace> traces, IMatchProcessingUnit tmfEventMatches) {
        if (tmfEventMatches == null) {
            throw new IllegalArgumentException();
        }
        this.fTraces = traces;
        this.fMatches = tmfEventMatches;
    }

    protected Collection<? extends ITmfTrace> getTraces() {
        return this.fTraces;
    }

    protected IMatchProcessingUnit getProcessingUnit() {
        return this.fMatches;
    }

    protected ITmfMatchEventDefinition getEventDefinition(ITmfTrace trace) {
        return this.fMatchMap.get(trace);
    }

    protected void initMatching() {
        this.fMatches.init(this.fTraces);
        List<ITmfMatchEventDefinition> deflist = fMatchDefinitions.get((Object)this.getMatchingType());
        if (deflist == null) {
            return;
        }
        block0: for (ITmfTrace trace : this.fTraces) {
            for (ITmfMatchEventDefinition def : deflist) {
                if (!def.canMatchTrace(trace)) continue;
                this.fMatchMap.put(trace, def);
                continue block0;
            }
        }
    }

    protected void finalizeMatching() {
        this.fMatches.matchingEnded();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [ " + this.fMatches + " ]";
    }

    protected abstract void matchEvent(ITmfEvent var1, ITmfTrace var2);

    protected abstract MatchingType getMatchingType();

    @Override
    public boolean matchEvents() {
        if (this.fTraces.size() <= 0) {
            return false;
        }
        this.initMatching();
        for (ITmfTrace trace : this.fTraces) {
            EventMatchingBuildRequest request = new EventMatchingBuildRequest(this, trace);
            trace.sendRequest(request);
            try {
                request.waitForCompletion();
            }
            catch (InterruptedException e) {
                Activator.logInfo(e.getMessage());
            }
        }
        this.finalizeMatching();
        return true;
    }

    public static void registerMatchObject(ITmfMatchEventDefinition match) {
        MatchingType[] matchingTypeArray = match.getApplicableMatchingTypes();
        int n = matchingTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MatchingType type = matchingTypeArray[n2];
            if (!fMatchDefinitions.containsKey((Object)type)) {
                fMatchDefinitions.put(type, new ArrayList());
            }
            fMatchDefinitions.get((Object)type).add(match);
            ++n2;
        }
    }

    public static enum MatchingType {
        NETWORK;

    }
}

