/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.filter.model;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.filter.model.ITmfFilterTreeNode;
import org.eclipse.linuxtools.tmf.core.filter.model.TmfFilterTreeNode;
import org.eclipse.linuxtools.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfNanoTimestamp;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimestampFormat;

public class TmfFilterCompareNode
extends TmfFilterTreeNode {
    public static final String NODE_NAME = "COMPARE";
    public static final String NOT_ATTR = "not";
    public static final String FIELD_ATTR = "field";
    public static final String RESULT_ATTR = "result";
    public static final String TYPE_ATTR = "type";
    public static final String VALUE_ATTR = "value";
    private boolean fNot = false;
    private String fField;
    private int fResult;
    private Type fType = Type.NUM;
    private String fValue;
    private transient Number fValueNumber;
    private transient ITmfTimestamp fValueTimestamp;
    private transient TmfTimestampFormat fTimestampFormat = new TmfTimestampFormat("T.SSSSSSSSS");

    public TmfFilterCompareNode(ITmfFilterTreeNode parent) {
        super(parent);
    }

    public boolean isNot() {
        return this.fNot;
    }

    public void setNot(boolean not) {
        this.fNot = not;
    }

    public String getField() {
        return this.fField;
    }

    public void setField(String field) {
        this.fField = field;
    }

    public int getResult() {
        return this.fResult;
    }

    public void setResult(int result) {
        this.fResult = (int)Math.signum(result);
    }

    public Type getType() {
        return this.fType;
    }

    public void setType(Type type) {
        this.fType = type;
        this.setValue(this.fValue);
    }

    public String getValue() {
        return this.fValue;
    }

    public void setValue(String value) {
        this.fValue = value;
        this.fValueNumber = null;
        this.fValueTimestamp = null;
        if (value == null) {
            return;
        }
        if (this.fType == Type.NUM) {
            try {
                this.fValueNumber = NumberFormat.getInstance().parse(value).doubleValue();
            }
            catch (ParseException parseException) {}
        } else if (this.fType == Type.TIMESTAMP) {
            try {
                this.fValueTimestamp = new TmfNanoTimestamp(this.fTimestampFormat.parseValue(value.toString()));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getNodeName() {
        return NODE_NAME;
    }

    @Override
    public boolean matches(ITmfEvent event) {
        Object value = this.getFieldValue(event, this.fField);
        if (value == null) {
            return false;
        }
        if (this.fType == Type.NUM) {
            if (this.fValueNumber != null) {
                if (value instanceof Number) {
                    double valueDouble = ((Number)value).doubleValue();
                    return Double.compare(valueDouble, this.fValueNumber.doubleValue()) == this.fResult ^ this.fNot;
                }
                try {
                    double valueDouble = NumberFormat.getInstance().parse(value.toString()).doubleValue();
                    return Double.compare(valueDouble, this.fValueNumber.doubleValue()) == this.fResult ^ this.fNot;
                }
                catch (ParseException valueDouble) {}
            }
        } else {
            if (this.fType == Type.ALPHA) {
                String valueString = value.toString();
                int comp = (int)Math.signum(valueString.compareTo(this.fValue.toString()));
                return comp == this.fResult ^ this.fNot;
            }
            if (this.fType == Type.TIMESTAMP && this.fValueTimestamp != null) {
                if (value instanceof ITmfTimestamp) {
                    ITmfTimestamp valueTimestamp = (ITmfTimestamp)value;
                    int comp = (int)Math.signum(valueTimestamp.compareTo(this.fValueTimestamp, false));
                    return comp == this.fResult ^ this.fNot;
                }
                try {
                    TmfNanoTimestamp valueTimestamp = new TmfNanoTimestamp(this.fTimestampFormat.parseValue(value.toString()));
                    int comp = (int)Math.signum(valueTimestamp.compareTo(this.fValueTimestamp, false));
                    return comp == this.fResult ^ this.fNot;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    @Override
    public List<String> getValidChildren() {
        return new ArrayList<String>(0);
    }

    public String toString() {
        String open;
        String result;
        String string = this.fResult == 0 ? "= " : (result = this.fResult < 0 ? "< " : "> ");
        String string2 = this.fType == Type.NUM ? "" : (open = this.fType == Type.ALPHA ? "\"" : "[");
        String close = this.fType == Type.NUM ? "" : (this.fType == Type.ALPHA ? "\"" : "]");
        return String.valueOf(this.fField) + (this.fNot ? " not " : " ") + result + open + this.fValue + close;
    }

    @Override
    public ITmfFilterTreeNode clone() {
        TmfFilterCompareNode clone = (TmfFilterCompareNode)super.clone();
        clone.fField = this.fField;
        clone.setValue(this.fValue);
        return clone;
    }

    public static enum Type {
        NUM,
        ALPHA,
        TIMESTAMP;

    }
}

