/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.statesystem;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.eclipse.linuxtools.statesystem.core.ITmfStateSystem;
import org.eclipse.linuxtools.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.TmfEvent;
import org.eclipse.linuxtools.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;

public abstract class AbstractTmfStateProvider
implements ITmfStateProvider {
    private static final int DEFAULT_EVENTS_QUEUE_SIZE = 10000;
    private final ITmfTrace trace;
    private final Class<? extends ITmfEvent> eventType;
    private final BlockingQueue<ITmfEvent> eventsQueue;
    private final Thread eventHandlerThread;
    private boolean ssAssigned;
    protected ITmfStateSystemBuilder ss = null;
    private static final EndEvent END_EVENT = new EndEvent();
    private static final EmptyQueueEvent EMPTY_QUEUE_EVENT = new EmptyQueueEvent();

    public AbstractTmfStateProvider(ITmfTrace trace, Class<? extends ITmfEvent> eventType, String id) {
        this.trace = trace;
        this.eventType = eventType;
        this.eventsQueue = new ArrayBlockingQueue<ITmfEvent>(10000);
        this.ssAssigned = false;
        String id2 = id == null ? "Unamed" : id;
        this.eventHandlerThread = new Thread((Runnable)new EventProcessor(), String.valueOf(id2) + " Event Handler");
    }

    @Override
    public ITmfTrace getTrace() {
        return this.trace;
    }

    @Override
    public long getStartTime() {
        return this.trace.getStartTime().normalize(0L, -9).getValue();
    }

    @Override
    public void assignTargetStateSystem(ITmfStateSystemBuilder ssb) {
        this.ss = ssb;
        this.ssAssigned = true;
        this.eventHandlerThread.start();
    }

    @Override
    public ITmfStateSystem getAssignedStateSystem() {
        return this.ss;
    }

    @Override
    public void dispose() {
        try {
            this.eventsQueue.put(END_EVENT);
            this.eventHandlerThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.ssAssigned = false;
        this.ss = null;
    }

    @Override
    public final Class<? extends ITmfEvent> getExpectedEventType() {
        return this.eventType;
    }

    @Override
    public final void processEvent(ITmfEvent event) {
        if (!this.ssAssigned) {
            System.err.println("Cannot process event without a target state system");
            return;
        }
        ITmfEvent curEvent = event;
        try {
            this.eventsQueue.put(curEvent);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void waitForEmptyQueue() {
        try {
            this.eventsQueue.put(EMPTY_QUEUE_EVENT);
            while (!this.eventsQueue.isEmpty()) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected abstract void eventHandle(ITmfEvent var1);

    private static class EmptyQueueEvent
    extends TmfEvent {
        private EmptyQueueEvent() {
        }
    }

    private static class EndEvent
    extends TmfEvent {
        private EndEvent() {
        }
    }

    private class EventProcessor
    implements Runnable {
        private ITmfEvent currentEvent;

        private EventProcessor() {
        }

        @Override
        public void run() {
            if (AbstractTmfStateProvider.this.ss == null) {
                System.err.println("Cannot run event manager without assigning a target state system first!");
                return;
            }
            try {
                ITmfEvent event = (ITmfEvent)AbstractTmfStateProvider.this.eventsQueue.take();
                while (event != END_EVENT) {
                    if (event == EMPTY_QUEUE_EVENT) {
                        event = (ITmfEvent)AbstractTmfStateProvider.this.eventsQueue.take();
                        continue;
                    }
                    this.currentEvent = event;
                    if (AbstractTmfStateProvider.this.eventType.isInstance(event) && event.getType() != null) {
                        AbstractTmfStateProvider.this.eventHandle(event);
                    }
                    event = (ITmfEvent)AbstractTmfStateProvider.this.eventsQueue.take();
                }
                this.closeStateSystem();
            }
            catch (InterruptedException e) {
                System.out.println("Event handler interrupted!");
                e.printStackTrace();
            }
        }

        private void closeStateSystem() {
            long endTime = this.currentEvent == null ? 0L : this.currentEvent.getTimestamp().normalize(0L, -9).getValue();
            AbstractTmfStateProvider.this.ss.closeHistory(endTime);
        }
    }
}

