/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.statesystem;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.linuxtools.internal.statesystem.core.StateSystem;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.backends.partial.PartialHistoryBackend;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.backends.partial.PartialStateSystem;
import org.eclipse.linuxtools.statesystem.core.ITmfStateSystem;
import org.eclipse.linuxtools.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.linuxtools.statesystem.core.StateSystemFactory;
import org.eclipse.linuxtools.statesystem.core.backend.IStateHistoryBackend;
import org.eclipse.linuxtools.statesystem.core.backend.InMemoryBackend;
import org.eclipse.linuxtools.statesystem.core.backend.NullBackend;
import org.eclipse.linuxtools.statesystem.core.backend.historytree.HistoryTreeBackend;
import org.eclipse.linuxtools.statesystem.core.backend.historytree.ThreadedHistoryTreeBackend;
import org.eclipse.linuxtools.tmf.core.analysis.TmfAbstractAnalysisModule;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.exceptions.TmfTraceException;
import org.eclipse.linuxtools.tmf.core.request.ITmfEventRequest;
import org.eclipse.linuxtools.tmf.core.request.TmfEventRequest;
import org.eclipse.linuxtools.tmf.core.statesystem.ITmfAnalysisModuleWithStateSystems;
import org.eclipse.linuxtools.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfExperiment;
import org.eclipse.linuxtools.tmf.core.trace.TmfTraceManager;

@NonNullByDefault
public abstract class TmfStateSystemAnalysisModule
extends TmfAbstractAnalysisModule
implements ITmfAnalysisModuleWithStateSystems {
    private static final String EXTENSION = ".ht";
    private final CountDownLatch fInitialized = new CountDownLatch(1);
    @Nullable
    private ITmfStateSystemBuilder fStateSystem;
    @Nullable
    private ITmfStateProvider fStateProvider;
    @Nullable
    private IStateHistoryBackend fHtBackend;
    @Nullable
    private ITmfEventRequest fRequest;

    @Nullable
    public static ITmfStateSystem getStateSystem(ITmfTrace trace, String moduleId) {
        IStatus status;
        TmfStateSystemAnalysisModule module = trace.getAnalysisModuleOfClass(TmfStateSystemAnalysisModule.class, moduleId);
        if (module != null && (status = module.schedule()).isOK()) {
            module.waitForInitialization();
            return module.getStateSystem();
        }
        return null;
    }

    protected abstract ITmfStateProvider createStateProvider();

    protected StateSystemBackendType getBackendType() {
        return StateSystemBackendType.FULL;
    }

    protected String getSsFileName() {
        return String.valueOf(this.getId()) + EXTENSION;
    }

    @Nullable
    public ITmfStateSystem getStateSystem() {
        return this.fStateSystem;
    }

    public void waitForInitialization() {
        try {
            this.fInitialized.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    protected boolean executeAnalysis(@Nullable IProgressMonitor monitor) {
        ITmfTrace trace;
        StateSystemBackendType backend;
        String id;
        ITmfStateProvider provider;
        IProgressMonitor mon;
        block9: {
            mon = monitor == null ? new NullProgressMonitor() : monitor;
            provider = this.createStateProvider();
            id = this.getId();
            try {
                backend = this.getBackendType();
                trace = this.getTrace();
                if (trace != null) break block9;
                this.fInitialized.countDown();
                return false;
            }
            catch (TmfTraceException e) {
                this.fInitialized.countDown();
                return false;
            }
        }
        switch (backend) {
            case FULL: {
                String directory = TmfTraceManager.getSupplementaryFileDir(trace);
                File htFile = new File(String.valueOf(directory) + this.getSsFileName());
                this.createFullHistory(id, provider, htFile);
                break;
            }
            case PARTIAL: {
                String directory = TmfTraceManager.getSupplementaryFileDir(trace);
                File htFile = new File(String.valueOf(directory) + this.getSsFileName());
                this.createPartialHistory(id, provider, htFile);
                break;
            }
            case INMEM: {
                this.createInMemoryHistory(id, provider);
                break;
            }
            case NULL: {
                this.createNullHistory(id, provider);
                break;
            }
        }
        return !mon.isCanceled();
    }

    @Override
    protected void canceling() {
        ITmfEventRequest req = this.fRequest;
        if (req != null && !req.isCompleted()) {
            req.cancel();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.fStateSystem != null) {
            this.fStateSystem.dispose();
        }
    }

    private void createFullHistory(String id, ITmfStateProvider provider, File htFile) throws TmfTraceException {
        if (htFile.exists()) {
            int version = provider.getVersion();
            try {
                HistoryTreeBackend backend = new HistoryTreeBackend(htFile, version);
                this.fHtBackend = backend;
                this.fStateSystem = StateSystemFactory.newStateSystem((String)id, (IStateHistoryBackend)backend, (boolean)false);
                this.fInitialized.countDown();
                return;
            }
            catch (IOException backend) {
                // empty catch block
            }
        }
        int QUEUE_SIZE = 10000;
        try {
            ThreadedHistoryTreeBackend backend = new ThreadedHistoryTreeBackend(htFile, provider.getStartTime(), provider.getVersion(), 10000);
            this.fHtBackend = backend;
            this.fStateSystem = StateSystemFactory.newStateSystem((String)id, (IStateHistoryBackend)backend);
            provider.assignTargetStateSystem(this.fStateSystem);
            this.build(provider);
        }
        catch (IOException e) {
            throw new TmfTraceException(e.toString(), e);
        }
    }

    private void createPartialHistory(String id, ITmfStateProvider provider, File htPartialFile) throws TmfTraceException {
        int QUEUE_SIZE = 10000;
        long granularity = 50000L;
        ThreadedHistoryTreeBackend realBackend = null;
        try {
            realBackend = new ThreadedHistoryTreeBackend(htPartialFile, provider.getStartTime(), provider.getVersion(), 10000);
        }
        catch (IOException e) {
            throw new TmfTraceException(e.toString(), e);
        }
        ITmfStateProvider partialProvider = provider.getNewInstance();
        PartialStateSystem pss = new PartialStateSystem();
        partialProvider.assignTargetStateSystem((ITmfStateSystemBuilder)pss);
        PartialHistoryBackend partialBackend = new PartialHistoryBackend(partialProvider, pss, (IStateHistoryBackend)realBackend, 50000L);
        StateSystem realSS = (StateSystem)StateSystemFactory.newStateSystem((String)id, (IStateHistoryBackend)partialBackend);
        pss.assignUpstream(realSS);
        provider.assignTargetStateSystem((ITmfStateSystemBuilder)realSS);
        this.fHtBackend = partialBackend;
        this.fStateSystem = realSS;
        this.build(provider);
    }

    private void createNullHistory(String id, ITmfStateProvider provider) {
        NullBackend backend = new NullBackend();
        this.fHtBackend = backend;
        this.fStateSystem = StateSystemFactory.newStateSystem((String)id, (IStateHistoryBackend)backend);
        provider.assignTargetStateSystem(this.fStateSystem);
        this.build(provider);
    }

    private void createInMemoryHistory(String id, ITmfStateProvider provider) {
        InMemoryBackend backend = new InMemoryBackend(provider.getStartTime());
        this.fHtBackend = backend;
        this.fStateSystem = StateSystemFactory.newStateSystem((String)id, (IStateHistoryBackend)backend);
        provider.assignTargetStateSystem(this.fStateSystem);
        this.build(provider);
    }

    private void disposeProvider(boolean deleteFiles) {
        ITmfStateProvider provider = this.fStateProvider;
        if (provider != null) {
            provider.dispose();
        }
        if (deleteFiles && this.fHtBackend != null) {
            this.fHtBackend.removeFiles();
        }
    }

    private void build(ITmfStateProvider provider) {
        if (this.fStateSystem == null || this.fHtBackend == null) {
            throw new IllegalArgumentException();
        }
        ITmfEventRequest request = this.fRequest;
        if (request != null && !request.isCompleted()) {
            request.cancel();
        }
        request = new StateSystemEventRequest(provider);
        provider.getTrace().sendRequest(request);
        this.fStateProvider = provider;
        this.fRequest = request;
        this.fInitialized.countDown();
        try {
            request.waitForCompletion();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    @Nullable
    public ITmfStateSystem getStateSystem(String id) {
        if (id.equals(this.getId())) {
            return this.fStateSystem;
        }
        return null;
    }

    @Override
    public Iterable<ITmfStateSystem> getStateSystems() {
        Set<ITmfStateSystemBuilder> ret = Collections.singleton(this.fStateSystem);
        return ret;
    }

    protected static enum StateSystemBackendType {
        FULL,
        INMEM,
        NULL,
        PARTIAL;

    }

    private class StateSystemEventRequest
    extends TmfEventRequest {
        private final ITmfStateProvider sci;
        private final ITmfTrace trace;

        public StateSystemEventRequest(ITmfStateProvider sp) {
            ITmfTrace tr;
            super(sp.getExpectedEventType(), TmfTimeRange.ETERNITY, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND);
            this.sci = sp;
            this.trace = tr = this.sci.getTrace();
        }

        @Override
        public void handleData(ITmfEvent event) {
            super.handleData(event);
            if (event.getTrace() == this.trace) {
                this.sci.processEvent(event);
            } else if (this.trace instanceof TmfExperiment) {
                ITmfTrace[] iTmfTraceArray = ((TmfExperiment)this.trace).getTraces();
                int n = iTmfTraceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITmfTrace childTrace = iTmfTraceArray[n2];
                    if (childTrace == event.getTrace()) {
                        this.sci.processEvent(event);
                    }
                    ++n2;
                }
            }
        }

        @Override
        public void handleSuccess() {
            super.handleSuccess();
            TmfStateSystemAnalysisModule.this.disposeProvider(false);
        }

        @Override
        public void handleCancel() {
            super.handleCancel();
            TmfStateSystemAnalysisModule.this.disposeProvider(true);
        }

        @Override
        public void handleFailure() {
            super.handleFailure();
            TmfStateSystemAnalysisModule.this.disposeProvider(true);
        }
    }
}

