/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.statistics;

import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.linuxtools.statesystem.core.ITmfStateSystem;
import org.eclipse.linuxtools.tmf.core.analysis.TmfAbstractAnalysisModule;
import org.eclipse.linuxtools.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.linuxtools.tmf.core.statesystem.ITmfAnalysisModuleWithStateSystems;
import org.eclipse.linuxtools.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.linuxtools.tmf.core.statistics.ITmfStatistics;
import org.eclipse.linuxtools.tmf.core.statistics.TmfStateStatistics;
import org.eclipse.linuxtools.tmf.core.statistics.TmfStatisticsEventTypesModule;
import org.eclipse.linuxtools.tmf.core.statistics.TmfStatisticsTotalsModule;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;

public class TmfStatisticsModule
extends TmfAbstractAnalysisModule
implements ITmfAnalysisModuleWithStateSystems {
    public static final String ID = "org.eclipse.linuxtools.tmf.core.statistics.analysis";
    private ITmfStatistics fStatistics = null;
    private final TmfStateSystemAnalysisModule totalsModule = new TmfStatisticsTotalsModule();
    private final TmfStateSystemAnalysisModule eventTypesModule = new TmfStatisticsEventTypesModule();
    private final CountDownLatch fInitialized = new CountDownLatch(1);

    @Nullable
    public ITmfStatistics getStatistics() {
        return this.fStatistics;
    }

    public void waitForInitialization() {
        try {
            this.fInitialized.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.totalsModule.dispose();
        this.eventTypesModule.dispose();
    }

    @Override
    public void setTrace(ITmfTrace trace) throws TmfAnalysisException {
        super.setTrace(trace);
        this.totalsModule.setTrace(trace);
        this.eventTypesModule.setTrace(trace);
    }

    @Override
    protected boolean executeAnalysis(IProgressMonitor monitor) throws TmfAnalysisException {
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            this.fInitialized.countDown();
            return false;
        }
        IStatus status1 = this.totalsModule.schedule();
        IStatus status2 = this.eventTypesModule.schedule();
        if (!status1.isOK() || !status2.isOK()) {
            this.cancelSubAnalyses();
            this.fInitialized.countDown();
            return false;
        }
        this.totalsModule.waitForInitialization();
        this.eventTypesModule.waitForInitialization();
        ITmfStateSystem totalsSS = this.totalsModule.getStateSystem();
        ITmfStateSystem eventTypesSS = this.eventTypesModule.getStateSystem();
        if (totalsSS == null || eventTypesSS == null) {
            this.fInitialized.countDown();
            return false;
        }
        this.fStatistics = new TmfStateStatistics(totalsSS, eventTypesSS);
        this.fInitialized.countDown();
        return this.totalsModule.waitForCompletion(monitor) && this.eventTypesModule.waitForCompletion(monitor);
    }

    @Override
    protected void canceling() {
        this.cancelSubAnalyses();
        ITmfStatistics stats = this.fStatistics;
        if (stats != null) {
            stats.dispose();
        }
    }

    private void cancelSubAnalyses() {
        this.totalsModule.cancel();
        this.eventTypesModule.cancel();
    }

    @Override
    public ITmfStateSystem getStateSystem(String id) {
        switch (id) {
            case "org.eclipse.linuxtools.tmf.statistics.totals": {
                return this.totalsModule.getStateSystem();
            }
            case "org.eclipse.linuxtools.tmf.statistics.types": {
                return this.eventTypesModule.getStateSystem();
            }
        }
        return null;
    }

    @Override
    public Iterable<ITmfStateSystem> getStateSystems() {
        LinkedList<ITmfStateSystem> list = new LinkedList<ITmfStateSystem>();
        list.add(this.totalsModule.getStateSystem());
        list.add(this.eventTypesModule.getStateSystem());
        return list;
    }
}

