/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.composite.c;

import org.eclipse.cdt.core.dom.ast.EScopeKind;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.ISemanticProblem;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.c.ICArrayType;
import org.eclipse.cdt.core.dom.ast.c.ICCompositeTypeScope;
import org.eclipse.cdt.core.dom.ast.c.ICPointerType;
import org.eclipse.cdt.core.dom.ast.c.ICQualifierType;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexMacroContainer;
import org.eclipse.cdt.internal.core.dom.parser.c.CArrayType;
import org.eclipse.cdt.internal.core.dom.parser.c.CFunctionType;
import org.eclipse.cdt.internal.core.dom.parser.c.CPointerType;
import org.eclipse.cdt.internal.core.dom.parser.c.CQualifierType;
import org.eclipse.cdt.internal.core.index.IIndexFragmentBinding;
import org.eclipse.cdt.internal.core.index.IIndexScope;
import org.eclipse.cdt.internal.core.index.composite.AbstractCompositeFactory;
import org.eclipse.cdt.internal.core.index.composite.CompositeIndexBinding;
import org.eclipse.cdt.internal.core.index.composite.CompositeMacroContainer;
import org.eclipse.cdt.internal.core.index.composite.CompositingNotImplementedError;
import org.eclipse.cdt.internal.core.index.composite.c.CompositeCEnumeration;
import org.eclipse.cdt.internal.core.index.composite.c.CompositeCEnumerator;
import org.eclipse.cdt.internal.core.index.composite.c.CompositeCField;
import org.eclipse.cdt.internal.core.index.composite.c.CompositeCFunction;
import org.eclipse.cdt.internal.core.index.composite.c.CompositeCParameter;
import org.eclipse.cdt.internal.core.index.composite.c.CompositeCStructure;
import org.eclipse.cdt.internal.core.index.composite.c.CompositeCTypedef;
import org.eclipse.cdt.internal.core.index.composite.c.CompositeCVariable;

public class CCompositesFactory
extends AbstractCompositeFactory {
    public CCompositesFactory(IIndex index) {
        super(index);
    }

    @Override
    public IIndexScope getCompositeScope(IIndexScope rscope) {
        if (rscope == null) {
            return null;
        }
        if (rscope.getKind() == EScopeKind.eGlobal) {
            return rscope;
        }
        if (rscope instanceof ICCompositeTypeScope) {
            ICCompositeTypeScope cscope = (ICCompositeTypeScope)((Object)rscope);
            IIndexFragmentBinding rbinding = (IIndexFragmentBinding)((Object)cscope.getCompositeType());
            return (IIndexScope)((ICompositeType)((Object)this.getCompositeBinding(rbinding))).getCompositeScope();
        }
        throw new CompositingNotImplementedError();
    }

    @Override
    public IType getCompositeType(IType rtype) {
        if (rtype instanceof IIndexFragmentBinding) {
            return (IType)((Object)this.getCompositeBinding((IIndexFragmentBinding)((Object)rtype)));
        }
        if (rtype instanceof IFunctionType) {
            IFunctionType ft = (IFunctionType)rtype;
            IType r = ft.getReturnType();
            IType r2 = this.getCompositeType(r);
            IType[] p = ft.getParameterTypes();
            IType[] p2 = this.getCompositeTypes(p);
            if (r != r2 || p != p2) {
                return new CFunctionType(r2, p2);
            }
            return ft;
        }
        if (rtype instanceof ICPointerType) {
            IType r2;
            ICPointerType pt = (ICPointerType)rtype;
            IType r = pt.getType();
            if (r != (r2 = this.getCompositeType(r))) {
                int q = 0;
                if (pt.isConst()) {
                    q |= 1;
                }
                if (pt.isVolatile()) {
                    q |= 4;
                }
                if (pt.isRestrict()) {
                    q |= 2;
                }
                return new CPointerType(r2, q);
            }
            return pt;
        }
        if (rtype instanceof ICQualifierType) {
            IType r2;
            ICQualifierType qt = (ICQualifierType)rtype;
            IType r = qt.getType();
            if (r != (r2 = this.getCompositeType(r))) {
                return new CQualifierType(r2, qt.isConst(), qt.isVolatile(), qt.isRestrict());
            }
            return qt;
        }
        if (rtype instanceof ICArrayType) {
            ICArrayType at = (ICArrayType)rtype;
            IType r = at.getType();
            IType r2 = this.getCompositeType(r);
            IValue v = at.getSize();
            IValue v2 = this.getCompositeValue(v);
            if (r != r2 || v != v2) {
                CArrayType at2 = new CArrayType(r2, at.isConst(), at.isVolatile(), at.isRestrict(), v2);
                at2.setIsStatic(at.isStatic());
                at2.setIsVariableLength(at.isVariableLength());
            }
            return at;
        }
        if (rtype instanceof IBasicType || rtype instanceof ISemanticProblem || rtype == null) {
            return rtype;
        }
        throw new CompositingNotImplementedError();
    }

    @Override
    public IValue getCompositeValue(IValue v) {
        return v;
    }

    @Override
    public IIndexBinding getCompositeBinding(IIndexFragmentBinding rbinding) {
        CompositeIndexBinding result;
        if (rbinding == null) {
            result = null;
        } else if (rbinding instanceof IParameter) {
            result = new CompositeCParameter(this, rbinding);
        } else if (rbinding instanceof IField) {
            result = new CompositeCField(this, rbinding);
        } else if (rbinding instanceof IVariable) {
            result = new CompositeCVariable(this, rbinding);
        } else if (rbinding instanceof ICompositeType) {
            result = new CompositeCStructure(this, this.findOneBinding(rbinding, false));
        } else if (rbinding instanceof IEnumeration) {
            result = new CompositeCEnumeration(this, this.findOneBinding(rbinding, false));
        } else if (rbinding instanceof IFunction) {
            result = new CompositeCFunction(this, rbinding);
        } else if (rbinding instanceof IEnumerator) {
            result = new CompositeCEnumerator(this, rbinding);
        } else if (rbinding instanceof ITypedef) {
            result = new CompositeCTypedef(this, rbinding);
        } else if (rbinding instanceof IIndexMacroContainer) {
            result = new CompositeMacroContainer(this, rbinding);
        } else {
            throw new CompositingNotImplementedError("Composite binding unavailable for " + rbinding + " " + rbinding.getClass());
        }
        return result;
    }
}

