/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.control.core.relayd.lttngviewerCommands;

import com.google.common.collect.ImmutableList;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import org.eclipse.linuxtools.internal.lttng2.control.core.relayd.lttngviewerCommands.IRelayResponse;
import org.eclipse.linuxtools.internal.lttng2.control.core.relayd.lttngviewerCommands.NewStreamsReturnCode;
import org.eclipse.linuxtools.internal.lttng2.control.core.relayd.lttngviewerCommands.StreamResponse;

public class NewStreamsResponse
implements IRelayResponse {
    private static final int SIZE = 8;
    private final NewStreamsReturnCode fStatus;
    private final int fNbStreams;
    private final List<StreamResponse> fStreamList;

    public NewStreamsResponse(DataInputStream inNet) throws IOException {
        byte[] data = new byte[8];
        inNet.readFully(data);
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.order(ByteOrder.BIG_ENDIAN);
        this.fStatus = NewStreamsReturnCode.values()[bb.getInt() - 1];
        this.fNbStreams = bb.getInt();
        ImmutableList.Builder sl = new ImmutableList.Builder();
        if (this.getStatus().equals(NewStreamsReturnCode.LTTNG_VIEWER_NEW_STREAMS_OK)) {
            int stream = 0;
            while (stream < this.fNbStreams) {
                sl.add((Object)new StreamResponse(inNet));
                ++stream;
            }
        }
        this.fStreamList = sl.build();
    }

    public NewStreamsReturnCode getStatus() {
        return this.fStatus;
    }

    public List<StreamResponse> getStreamList() {
        return this.fStreamList;
    }

    public int getNbStreams() {
        return this.fNbStreams;
    }
}

