/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.control.core.relayd.lttngviewerCommands;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.linuxtools.internal.lttng2.control.core.relayd.lttngviewerCommands.GetPacketReturnCode;
import org.eclipse.linuxtools.internal.lttng2.control.core.relayd.lttngviewerCommands.IRelayResponse;

public class TracePacketResponse
implements IRelayResponse {
    private static final int SIZE = 12;
    private final GetPacketReturnCode fStatus;
    private final int fFlags;
    private final byte[] fData;

    public TracePacketResponse(DataInputStream inNet) throws IOException {
        byte[] data = new byte[12];
        inNet.readFully(data);
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.order(ByteOrder.BIG_ENDIAN);
        this.fStatus = GetPacketReturnCode.values()[bb.getInt() - 1];
        int length = bb.getInt();
        this.fFlags = bb.getInt();
        if (this.fStatus.equals(GetPacketReturnCode.VIEWER_GET_PACKET_OK)) {
            this.fData = new byte[length];
            inNet.readFully(this.fData);
        } else {
            this.fData = new byte[0];
        }
    }

    public GetPacketReturnCode getStatus() {
        return this.fStatus;
    }

    public int getFlags() {
        return this.fFlags;
    }

    public byte[] getData() {
        return this.fData;
    }
}

