/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CreateChangeOperation;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIPlugin;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringWizardDialog;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringWizardDialog2;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;

public class UIPerformChangeOperation
extends PerformChangeOperation {
    private Display fDisplay;
    private IWizardContainer fWizardContainer;

    public UIPerformChangeOperation(Display display, Change change, IWizardContainer container) {
        super(change);
        this.fDisplay = display;
        this.fWizardContainer = container;
    }

    public UIPerformChangeOperation(Display display, CreateChangeOperation op, IWizardContainer container) {
        super(op);
        this.fDisplay = display;
        this.fWizardContainer = container;
    }

    protected void executeChange(IProgressMonitor pm) throws CoreException {
        if (this.fDisplay != null && !this.fDisplay.isDisposed()) {
            final Throwable[] exception = new Throwable[1];
            final Button[] cancelToEnable = new Button[1];
            final ISafeRunnable safeRunnable = new ISafeRunnable(){

                public void run() {
                    Button cancel = UIPerformChangeOperation.this.getCancelButton();
                    if (cancel != null && !cancel.isDisposed() && cancel.isEnabled()) {
                        cancelToEnable[0] = cancel;
                        cancel.setEnabled(false);
                    }
                }

                public void handleException(Throwable e) {
                    exception[0] = e;
                }
            };
            Runnable r = new Runnable(){

                public void run() {
                    SafeRunner.run((ISafeRunnable)safeRunnable);
                }
            };
            try {
                this.fDisplay.syncExec(r);
                if (exception[0] != null) {
                    if (exception[0] instanceof CoreException) {
                        IStatus status = ((CoreException)exception[0]).getStatus();
                        throw new CoreException((IStatus)new MultiStatus(RefactoringUIPlugin.getPluginId(), 4, new IStatus[]{status}, status.getMessage(), exception[0]));
                    }
                    String message = exception[0].getMessage();
                    throw new CoreException((IStatus)new Status(4, RefactoringUIPlugin.getPluginId(), 4, message == null ? RefactoringUIMessages.ChangeExceptionHandler_no_details : message, exception[0]));
                }
                super.executeChange(pm);
            }
            catch (Throwable throwable) {
                if (cancelToEnable[0] != null) {
                    this.fDisplay.syncExec(new Runnable(cancelToEnable){
                        private final /* synthetic */ Button[] val$cancelToEnable;
                        {
                            this.val$cancelToEnable = buttonArray;
                        }

                        public void run() {
                            if (!this.val$cancelToEnable[0].isDisposed()) {
                                this.val$cancelToEnable[0].setEnabled(true);
                            }
                        }
                    });
                }
                throw throwable;
            }
            if (cancelToEnable[0] != null) {
                this.fDisplay.syncExec(new /* invalid duplicate definition of identical inner class */);
            }
        }
    }

    private Button getCancelButton() {
        if (this.fWizardContainer instanceof RefactoringWizardDialog2) {
            return ((RefactoringWizardDialog2)this.fWizardContainer).getButton(1);
        }
        if (this.fWizardContainer instanceof RefactoringWizardDialog) {
            return ((RefactoringWizardDialog)this.fWizardContainer).getButton(1);
        }
        return null;
    }
}

