/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.model;

import org.eclipse.tm.internal.terminal.model.TerminalTextDataStore;
import org.eclipse.tm.terminal.model.ITerminalTextData;
import org.eclipse.tm.terminal.model.ITerminalTextDataSnapshot;
import org.eclipse.tm.terminal.model.LineSegment;
import org.eclipse.tm.terminal.model.Style;

public class TerminalTextDataFastScroll
implements ITerminalTextData {
    final ITerminalTextData fData;
    private int fHeight;
    private int fMaxHeight;
    int fOffset;

    public TerminalTextDataFastScroll(ITerminalTextData data, int maxHeight) {
        this.fMaxHeight = maxHeight;
        this.fData = data;
        this.fData.setDimensions(maxHeight, this.fData.getWidth());
        if (maxHeight > 2) assert (this.shiftOffset(-2) || this.throwRuntimeException());
    }

    public TerminalTextDataFastScroll(int maxHeight) {
        this(new TerminalTextDataStore(), maxHeight);
    }

    public TerminalTextDataFastScroll() {
        this(new TerminalTextDataStore(), 1);
    }

    private boolean throwRuntimeException() {
        throw new RuntimeException();
    }

    int getPositionOfLine(int line) {
        return (line + this.fOffset) % this.fMaxHeight;
    }

    void moveOffset(int delta) {
        assert (Math.abs(delta) < this.fMaxHeight || this.throwRuntimeException());
        this.fOffset = (this.fMaxHeight + this.fOffset + delta) % this.fMaxHeight;
    }

    private boolean shiftOffset(int shift) {
        this.moveOffset(shift);
        return true;
    }

    public void addLine() {
        if (this.getHeight() < this.fMaxHeight) {
            this.setDimensions(this.getHeight() + 1, this.getWidth());
        } else {
            this.scroll(0, this.getHeight(), -1);
        }
    }

    public void cleanLine(int line) {
        this.fData.cleanLine(this.getPositionOfLine(line));
    }

    public void copy(ITerminalTextData source) {
        int n = source.getHeight();
        this.setDimensions(source.getHeight(), source.getWidth());
        int i = 0;
        while (i < n) {
            this.fData.copyLine(source, i, this.getPositionOfLine(i));
            ++i;
        }
    }

    public void copyLine(ITerminalTextData source, int sourceLine, int destLine) {
        this.fData.copyLine(source, sourceLine, this.getPositionOfLine(destLine));
    }

    public void copyRange(ITerminalTextData source, int sourceStartLine, int destStartLine, int length) {
        assert (destStartLine >= 0 && destStartLine + length <= this.fHeight || this.throwRuntimeException());
        int i = 0;
        while (i < length) {
            this.fData.copyLine(source, i + sourceStartLine, this.getPositionOfLine(i + destStartLine));
            ++i;
        }
    }

    public char getChar(int line, int column) {
        assert (line >= 0 && line < this.fHeight || this.throwRuntimeException());
        return this.fData.getChar(this.getPositionOfLine(line), column);
    }

    public char[] getChars(int line) {
        assert (line >= 0 && line < this.fHeight || this.throwRuntimeException());
        return this.fData.getChars(this.getPositionOfLine(line));
    }

    public int getHeight() {
        return this.fHeight;
    }

    public LineSegment[] getLineSegments(int line, int startCol, int numberOfCols) {
        assert (line >= 0 && line < this.fHeight || this.throwRuntimeException());
        return this.fData.getLineSegments(this.getPositionOfLine(line), startCol, numberOfCols);
    }

    public int getMaxHeight() {
        return this.fMaxHeight;
    }

    public Style getStyle(int line, int column) {
        assert (line >= 0 && line < this.fHeight || this.throwRuntimeException());
        return this.fData.getStyle(this.getPositionOfLine(line), column);
    }

    public Style[] getStyles(int line) {
        assert (line >= 0 && line < this.fHeight || this.throwRuntimeException());
        return this.fData.getStyles(this.getPositionOfLine(line));
    }

    public int getWidth() {
        return this.fData.getWidth();
    }

    public ITerminalTextDataSnapshot makeSnapshot() {
        return this.fData.makeSnapshot();
    }

    private void cleanLines(int line, int len) {
        int i = line;
        while (i < line + len) {
            this.fData.cleanLine(this.getPositionOfLine(i));
            ++i;
        }
    }

    public void scroll(int startLine, int size, int shift) {
        assert (startLine >= 0 && startLine + size <= this.fHeight || this.throwRuntimeException());
        if (shift >= this.fMaxHeight || -shift >= this.fMaxHeight) {
            this.cleanLines(startLine, this.fMaxHeight - startLine);
            return;
        }
        if (size == this.fHeight) {
            this.moveOffset(-shift);
            if (shift < 0) {
                this.cleanLines(Math.max(startLine, startLine + size + shift), Math.min(-shift, this.getHeight() - startLine));
            } else {
                this.cleanLines(startLine, Math.min(shift, this.getHeight() - startLine));
            }
        } else if (shift < 0) {
            int i = startLine;
            while (i < startLine + size + shift) {
                this.fData.copyLine(this.fData, this.getPositionOfLine(i - shift), this.getPositionOfLine(i));
                ++i;
            }
            this.cleanLines(Math.max(0, startLine + size + shift), Math.min(-shift, this.getHeight() - startLine));
        } else {
            int i = startLine + size - 1;
            while (i >= startLine && i - shift >= 0) {
                this.fData.copyLine(this.fData, this.getPositionOfLine(i - shift), this.getPositionOfLine(i));
                --i;
            }
            this.cleanLines(startLine, Math.min(shift, this.getHeight() - startLine));
        }
    }

    public void setChar(int line, int column, char c, Style style) {
        assert (line >= 0 && line < this.fHeight || this.throwRuntimeException());
        this.fData.setChar(this.getPositionOfLine(line), column, c, style);
    }

    public void setChars(int line, int column, char[] chars, int start, int len, Style style) {
        assert (line >= 0 && line < this.fHeight || this.throwRuntimeException());
        this.fData.setChars(this.getPositionOfLine(line), column, chars, start, len, style);
    }

    public void setChars(int line, int column, char[] chars, Style style) {
        assert (line >= 0 && line < this.fHeight || this.throwRuntimeException());
        this.fData.setChars(this.getPositionOfLine(line), column, chars, style);
    }

    public void setDimensions(int height, int width) {
        assert (height >= 0 || this.throwRuntimeException());
        assert (width >= 0 || this.throwRuntimeException());
        if (height > this.fMaxHeight) {
            this.setMaxHeight(height);
        }
        this.fHeight = height;
        if (width != this.fData.getWidth()) {
            this.fData.setDimensions(this.fMaxHeight, width);
        }
    }

    public void setMaxHeight(int maxHeight) {
        assert (maxHeight >= this.fHeight || this.throwRuntimeException());
        int start = this.getPositionOfLine(0);
        if (start != 0) {
            TerminalTextDataStore buffer = new TerminalTextDataStore();
            buffer.setDimensions(maxHeight, this.getWidth());
            int n = Math.min(this.fMaxHeight - start, maxHeight);
            buffer.copyRange(this.fData, start, 0, n);
            if (n < maxHeight) {
                buffer.copyRange(this.fData, 0, n, Math.min(this.fMaxHeight - n, maxHeight - n));
            }
            this.fData.copy(buffer);
            this.shiftOffset(-start);
        } else {
            this.fData.setDimensions(maxHeight, this.fData.getWidth());
        }
        this.fMaxHeight = maxHeight;
    }

    public int getCursorColumn() {
        throw new UnsupportedOperationException();
    }

    public int getCursorLine() {
        throw new UnsupportedOperationException();
    }

    public void setCursorColumn(int column) {
        throw new UnsupportedOperationException();
    }

    public void setCursorLine(int line) {
        throw new UnsupportedOperationException();
    }

    public boolean isWrappedLine(int line) {
        assert (line >= 0 && line < this.fHeight || this.throwRuntimeException());
        return this.fData.isWrappedLine(this.getPositionOfLine(line));
    }

    public void setWrappedLine(int line) {
        assert (line >= 0 && line < this.fHeight || this.throwRuntimeException());
        this.fData.setWrappedLine(this.getPositionOfLine(line));
    }
}

