/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.commands;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventField;
import org.eclipse.linuxtools.tmf.core.filter.ITmfFilter;
import org.eclipse.linuxtools.tmf.core.request.ITmfEventRequest;
import org.eclipse.linuxtools.tmf.core.request.TmfEventRequest;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.linuxtools.tmf.ui.viewers.events.columns.TmfEventTableColumn;

public class ExportToTextRequest
extends TmfEventRequest {
    private final Writer fWriter;
    private final ITmfFilter fFilter;
    private final List<TmfEventTableColumn> fColumns;
    private IOException fIOException;

    public ExportToTextRequest(Writer w, ITmfFilter filter, List<TmfEventTableColumn> columns) {
        super(ITmfEvent.class, TmfTimeRange.ETERNITY, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.FOREGROUND);
        this.fWriter = w;
        this.fFilter = filter;
        this.fColumns = columns;
    }

    public IOException getIOException() {
        return this.fIOException;
    }

    public void handleData(ITmfEvent event) {
        super.handleData(event);
        if (this.isCancelled()) {
            return;
        }
        try {
            if (this.fFilter == null || this.fFilter.matches(event)) {
                if (this.fColumns != null) {
                    boolean needTab = false;
                    for (TmfEventTableColumn column : this.fColumns) {
                        if (needTab) {
                            this.fWriter.write(9);
                        }
                        this.fWriter.write(column.getItemString(event));
                        needTab = true;
                    }
                } else {
                    this.fWriter.write(event.getTimestamp().toString());
                    this.fWriter.write(9);
                    this.fWriter.write(event.getSource());
                    this.fWriter.write(9);
                    this.fWriter.write(event.getType().getName());
                    this.fWriter.write(9);
                    this.fWriter.write(event.getReference());
                    this.fWriter.write(9);
                    ITmfEventField content = event.getContent();
                    Object value = content.getValue();
                    if (value != null) {
                        this.fWriter.write(value.toString());
                    }
                }
                this.fWriter.write(10);
            }
        }
        catch (IOException ex) {
            this.fIOException = ex;
            this.fail();
        }
    }
}

