/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.parsers.custom;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.parsers.custom.CustomEvent;
import org.eclipse.linuxtools.tmf.core.parsers.custom.CustomTraceDefinition;
import org.eclipse.linuxtools.tmf.ui.viewers.events.columns.TmfEventTableColumn;

public class CustomEventTableColumns {
    public static Collection<CustomEventTableColumn> generateColumns(CustomTraceDefinition definition) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        List outputs = definition.outputs;
        int i = 0;
        while (i < outputs.size()) {
            String name = ((CustomTraceDefinition.OutputColumn)outputs.get((int)i)).name;
            if (name != null) {
                builder.add((Object)new CustomEventTableColumn(name, i));
            }
            ++i;
        }
        return builder.build();
    }

    private static final class CustomEventTableColumn
    extends TmfEventTableColumn {
        private final int fIndex;

        public CustomEventTableColumn(@NonNull String name, int idx) {
            super(name);
            this.fIndex = idx;
        }

        @Override
        public String getItemString(ITmfEvent event) {
            if (event instanceof CustomEvent) {
                String ret = ((CustomEvent)event).getEventString(this.fIndex);
                return ret == null ? "" : ret;
            }
            return "";
        }

        @Override
        public String getFilterFieldId() {
            return this.getHeaderName();
        }
    }
}

