/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchAdapter;

public abstract class TracePackageElement
extends WorkbenchAdapter {
    private final List<TracePackageElement> fChildren;
    private TracePackageElement fParent;
    private boolean fEnabled;
    private boolean fChecked;
    private boolean fVisible;

    public TracePackageElement(TracePackageElement parent) {
        this.fParent = parent;
        this.fEnabled = true;
        this.fVisible = true;
        this.fChildren = new ArrayList<TracePackageElement>();
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public void addChild(TracePackageElement child) {
        child.setParent(this);
        this.fChildren.add(child);
    }

    public void addChild(int index, TracePackageElement child) {
        this.fChildren.add(index, child);
        child.setParent(this);
    }

    public void removeChild(TracePackageElement child) {
        this.fChildren.remove((Object)child);
        child.setParent(null);
    }

    public int indexOf(TracePackageElement child) {
        return this.fChildren.indexOf((Object)child);
    }

    public TracePackageElement getParent() {
        return this.fParent;
    }

    private void setParent(TracePackageElement parent) {
        this.fParent = parent;
    }

    public abstract String getText();

    public TracePackageElement[] getChildren() {
        return this.fChildren.toArray(new TracePackageElement[this.fChildren.size()]);
    }

    public TracePackageElement[] getVisibleChildren() {
        ArrayList<TracePackageElement> visibleChildren = new ArrayList<TracePackageElement>();
        for (TracePackageElement child : this.fChildren) {
            if (!child.isVisible()) continue;
            visibleChildren.add(child);
        }
        return visibleChildren.toArray(new TracePackageElement[0]);
    }

    public long getSize(boolean checkedOnly) {
        long size = 0L;
        if (this.fChildren != null) {
            for (TracePackageElement child : this.fChildren) {
                size += child.getSize(checkedOnly);
            }
        }
        return size;
    }

    public Image getImage() {
        return null;
    }

    public boolean isEnabled() {
        return this.fEnabled;
    }

    public boolean isChecked() {
        return this.fChecked;
    }

    public boolean isVisible() {
        return this.fVisible;
    }

    public void setEnabled(boolean enabled) {
        this.fEnabled = enabled;
    }

    public void setChecked(boolean checked) {
        this.fChecked = checked;
    }

    public void setVisible(boolean visible) {
        this.fVisible = visible;
    }
}

