/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.Messages;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.TracePackageElement;
import org.eclipse.swt.graphics.Image;

public class TracePackageFilesElement
extends TracePackageElement {
    private static final String TRACE_ICON_PATH = "icons/elcl16/trace.gif";
    private String fFileName;
    private final IResource fResource;
    private long fSize = -1L;

    public TracePackageFilesElement(TracePackageElement parent, IResource resource) {
        super(parent);
        this.fFileName = null;
        this.fResource = resource;
    }

    public TracePackageFilesElement(TracePackageElement parent, String fileName) {
        super(parent);
        this.fFileName = fileName;
        this.fResource = null;
    }

    private long getSize(File file) {
        if (file.isDirectory()) {
            long size = 0L;
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                size += this.getSize(f);
                ++n2;
            }
            return size;
        }
        return file.length();
    }

    @Override
    public long getSize(boolean checkedOnly) {
        if (checkedOnly && !this.isChecked()) {
            return 0L;
        }
        if (this.fSize == -1L && this.fResource.exists()) {
            File file = this.fResource.getLocation().toFile();
            this.fSize = this.getSize(file);
        }
        return this.fSize;
    }

    @Override
    public String getText() {
        return Messages.TracePackage_TraceElement;
    }

    @Override
    public Image getImage() {
        return Activator.getDefault().getImageFromImageRegistry(TRACE_ICON_PATH);
    }

    public String getFileName() {
        return this.fFileName;
    }

    public void setFileName(String fileName) {
        this.fFileName = fileName;
    }
}

