/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.AbstractTracePackageOperation;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.Messages;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.TracePackageBookmarkElement;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.TracePackageElement;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.TracePackageFilesElement;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.TracePackageSupplFileElement;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.TracePackageSupplFilesElement;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.TracePackageTraceElement;
import org.eclipse.linuxtools.tmf.core.TmfCommonConstants;
import org.eclipse.linuxtools.tmf.core.project.model.TmfTraceImportException;
import org.eclipse.linuxtools.tmf.core.project.model.TmfTraceType;
import org.eclipse.linuxtools.tmf.core.project.model.TraceTypeHelper;
import org.eclipse.linuxtools.tmf.core.util.Pair;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceTypeUIUtils;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.wizards.datatransfer.TarException;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

public class TracePackageImportOperation
extends AbstractTracePackageOperation
implements IOverwriteQuery {
    private final TracePackageElement[] fImportTraceElements;
    private final TmfTraceFolder fTmfTraceFolder;

    public TracePackageImportOperation(String fileName, TracePackageElement[] importTraceElements, TmfTraceFolder tmfTraceFolder) {
        super(fileName);
        this.fImportTraceElements = importTraceElements;
        this.fTmfTraceFolder = tmfTraceFolder;
    }

    @Override
    public void run(IProgressMonitor progressMonitor) {
        int totalWork = this.getNbCheckedElements(this.fImportTraceElements) * 2;
        progressMonitor.beginTask(org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages.TracePackageImportOperation_ImportingPackage, totalWork);
        this.doRun(progressMonitor);
        progressMonitor.done();
    }

    private void doRun(IProgressMonitor progressMonitor) {
        try {
            this.setStatus(this.deleteExistingTraces(progressMonitor));
            if (this.getStatus().getSeverity() != 0) {
                return;
            }
            TracePackageFilesElement traceFilesElement = null;
            TracePackageElement[] tracePackageElementArray = this.fImportTraceElements;
            int n = this.fImportTraceElements.length;
            int n2 = 0;
            while (n2 < n) {
                TracePackageElement packageElement = tracePackageElementArray[n2];
                TracePackageTraceElement traceElement = (TracePackageTraceElement)packageElement;
                if (TracePackageImportOperation.isFilesChecked(packageElement)) {
                    TracePackageElement[] children;
                    TracePackageElement[] tracePackageElementArray2 = children = traceElement.getChildren();
                    int n3 = children.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        TracePackageElement element = tracePackageElementArray2[n4];
                        ModalContext.checkCanceled((IProgressMonitor)progressMonitor);
                        if (element instanceof TracePackageFilesElement) {
                            traceFilesElement = (TracePackageFilesElement)element;
                            this.setStatus(this.importTraceFiles(traceFilesElement, traceElement, progressMonitor));
                        } else if (element instanceof TracePackageSupplFilesElement) {
                            TracePackageSupplFilesElement suppFilesElement = (TracePackageSupplFilesElement)element;
                            this.setStatus(this.importSupplFiles(suppFilesElement, traceElement, progressMonitor));
                        }
                        if (this.getStatus().getSeverity() != 0) {
                            return;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (InterruptedException e) {
            this.setStatus(Status.CANCEL_STATUS);
        }
    }

    public static boolean isFilesChecked(TracePackageElement tracePackageElement) {
        TracePackageElement[] tracePackageElementArray = tracePackageElement.getChildren();
        int n = tracePackageElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            TracePackageElement element = tracePackageElementArray[n2];
            if (element instanceof TracePackageFilesElement) {
                return element.isChecked();
            }
            ++n2;
        }
        return false;
    }

    private TmfTraceElement getMatchingTraceElement(TracePackageTraceElement tracePackageElement) {
        IPath tracePath = this.fTmfTraceFolder.getPath().append(tracePackageElement.getDestinationElementPath());
        List<TmfTraceElement> traces = this.fTmfTraceFolder.getTraces();
        for (TmfTraceElement t : traces) {
            if (!t.getPath().equals((Object)tracePath)) continue;
            return t;
        }
        return null;
    }

    private IStatus deleteExistingTraces(IProgressMonitor progressMonitor) {
        TracePackageElement[] tracePackageElementArray = this.fImportTraceElements;
        int n = this.fImportTraceElements.length;
        int n2 = 0;
        while (n2 < n) {
            TmfTraceElement existingTrace;
            TracePackageElement packageElement = tracePackageElementArray[n2];
            TracePackageTraceElement traceElement = (TracePackageTraceElement)packageElement;
            if (TracePackageImportOperation.isFilesChecked(traceElement) && (existingTrace = this.getMatchingTraceElement(traceElement)) != null) {
                try {
                    existingTrace.delete((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1, 4));
                }
                catch (CoreException e) {
                    return new Status(4, "org.eclipse.linuxtools.tmf.ui", Messages.TracePackage_ErrorOperation, (Throwable)e);
                }
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }

    private void importBookmarks(IResource traceRes, TracePackageTraceElement traceElement, IProgressMonitor monitor) {
        TracePackageElement[] tracePackageElementArray = traceElement.getChildren();
        int n = tracePackageElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            TracePackageElement o = tracePackageElementArray[n2];
            if (o instanceof TracePackageBookmarkElement && o.isChecked()) {
                IFile bookmarksFile = null;
                TmfTraceElement tmfTraceElement = this.getMatchingTraceElement(traceElement);
                if (tmfTraceElement != null) {
                    try {
                        bookmarksFile = tmfTraceElement.createBookmarksFile();
                        String traceEditorId = tmfTraceElement.getEditorId();
                        String editorId = traceEditorId != null ? traceEditorId : "org.eclipse.linuxtools.tmf.ui.editors.events";
                        IDE.setDefaultEditor((IFile)bookmarksFile, (String)editorId);
                    }
                    catch (CoreException e) {
                        Activator.getDefault().logError(MessageFormat.format(org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages.TracePackageImportOperation_ErrorCreatingBookmarkFile, traceRes.getName()), e);
                    }
                }
                if (bookmarksFile == null) break;
                TracePackageBookmarkElement bookmarkElement = (TracePackageBookmarkElement)o;
                List<Map<String, String>> bookmarks = bookmarkElement.getBookmarks();
                for (Map<String, String> attrs : bookmarks) {
                    IMarker createMarker = null;
                    try {
                        createMarker = bookmarksFile.createMarker("org.eclipse.core.resources.bookmark");
                    }
                    catch (CoreException e) {
                        Activator.getDefault().logError(MessageFormat.format(org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages.TracePackageImportOperation_ErrorCreatingBookmark, traceRes.getName()), e);
                    }
                    if (createMarker == null || !createMarker.exists()) continue;
                    try {
                        for (String key : attrs.keySet()) {
                            String value = attrs.get(key);
                            if (key.equals("location")) {
                                createMarker.setAttribute("location", Integer.valueOf(value).intValue());
                                continue;
                            }
                            createMarker.setAttribute(key, (Object)value);
                        }
                    }
                    catch (CoreException e) {
                        Activator.getDefault().logError(MessageFormat.format(org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages.TracePackageImportOperation_ErrorCreatingBookmark, traceRes.getName()), e);
                    }
                }
            }
            ++n2;
        }
        monitor.worked(1);
    }

    private IStatus importTraceFiles(TracePackageFilesElement traceFilesElement, TracePackageTraceElement traceElement, IProgressMonitor monitor) {
        ArrayList<Pair<String, String>> fileNameAndLabelPairs = new ArrayList<Pair<String, String>>();
        String sourceName = traceFilesElement.getFileName();
        String destinationName = traceElement.getImportName();
        fileNameAndLabelPairs.add(new Pair((Object)sourceName, (Object)destinationName));
        IPath containerPath = this.fTmfTraceFolder.getPath();
        IStatus status = this.importFiles(this.getSpecifiedArchiveFile(), fileNameAndLabelPairs, containerPath, (IPath)Path.EMPTY, monitor);
        if (this.getStatus().getSeverity() != 0) {
            return status;
        }
        IResource traceRes = this.fTmfTraceFolder.getResource().findMember(traceElement.getDestinationElementPath());
        if (traceRes == null || !traceRes.exists()) {
            return new Status(4, "org.eclipse.linuxtools.tmf.ui", MessageFormat.format(org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages.ImportTracePackageWizardPage_ErrorFindingImportedTrace, destinationName));
        }
        TraceTypeHelper traceType = null;
        String traceTypeStr = traceElement.getTraceType();
        if (traceTypeStr != null) {
            traceType = TmfTraceType.getTraceType((String)traceTypeStr);
            if (traceType == null) {
                return new Status(4, "org.eclipse.linuxtools.tmf.ui", MessageFormat.format(org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages.ImportTracePackageWizardPage_ErrorSettingTraceType, traceElement.getTraceType(), destinationName));
            }
        } else {
            try {
                monitor.subTask(MessageFormat.format(org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages.TracePackageImportOperation_DetectingTraceType, destinationName));
                traceType = TmfTraceTypeUIUtils.selectTraceType(traceRes.getLocation().toOSString(), null, null);
            }
            catch (TmfTraceImportException tmfTraceImportException) {
                // empty catch block
            }
        }
        if (traceType != null) {
            try {
                TmfTraceTypeUIUtils.setTraceType(traceRes, traceType);
            }
            catch (CoreException e) {
                return new Status(4, "org.eclipse.linuxtools.tmf.ui", MessageFormat.format(org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages.ImportTracePackageWizardPage_ErrorSettingTraceType, traceElement.getTraceType(), destinationName), (Throwable)e);
            }
        }
        this.importBookmarks(traceRes, traceElement, monitor);
        try {
            URI uri = new File(this.getFileName()).toURI();
            Path entryPath = new Path(traceFilesElement.getFileName());
            if (traceRes instanceof IFolder) {
                entryPath = entryPath.addTrailingSeparator();
            }
            String sourceLocation = URIUtil.toUnencodedString((URI)URIUtil.toJarURI((URI)uri, (IPath)entryPath));
            traceRes.setPersistentProperty(TmfCommonConstants.SOURCE_LOCATION, sourceLocation);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return status;
    }

    private IStatus importSupplFiles(TracePackageSupplFilesElement suppFilesElement, TracePackageTraceElement traceElement, IProgressMonitor monitor) {
        TmfTraceElement existingTrace;
        ArrayList<Pair<String, String>> fileNameAndLabelPairs = new ArrayList<Pair<String, String>>();
        TracePackageElement[] tracePackageElementArray = suppFilesElement.getChildren();
        int n = tracePackageElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            TracePackageElement child = tracePackageElementArray[n2];
            if (child.isChecked()) {
                TracePackageSupplFileElement supplFile = (TracePackageSupplFileElement)child;
                fileNameAndLabelPairs.add(new Pair((Object)supplFile.getText(), (Object)new Path(supplFile.getText()).lastSegment()));
            }
            ++n2;
        }
        if (!fileNameAndLabelPairs.isEmpty() && (existingTrace = this.getMatchingTraceElement(traceElement)) != null) {
            AbstractTracePackageOperation.ArchiveFile archiveFile = this.getSpecifiedArchiveFile();
            existingTrace.refreshSupplementaryFolder();
            IPath traceFolderRelativePath = this.fTmfTraceFolder.getPath().makeRelativeTo(this.fTmfTraceFolder.getProject().getTracesFolder().getPath());
            IFolder traceSupplementaryFolder = this.fTmfTraceFolder.getTraceSupplementaryFolder(traceFolderRelativePath.toString());
            IPath destinationContainerPath = traceSupplementaryFolder.getFullPath();
            Path baseSourcePath = new Path(".tracing");
            return this.importFiles(archiveFile, fileNameAndLabelPairs, destinationContainerPath, (IPath)baseSourcePath, monitor);
        }
        return Status.OK_STATUS;
    }

    private IStatus importFiles(AbstractTracePackageOperation.ArchiveFile archiveFile, List<Pair<String, String>> fileNameAndLabelPairs, IPath destinationContainerPath, IPath baseSourcePath, IProgressMonitor monitor) {
        ArrayList<ArchiveProviderElement> objects = new ArrayList<ArchiveProviderElement>();
        Enumeration<? extends AbstractTracePackageOperation.ArchiveEntry> entries = archiveFile.entries();
        block4: while (entries.hasMoreElements()) {
            AbstractTracePackageOperation.ArchiveEntry entry = entries.nextElement();
            String entryName = entry.getName();
            Path fullArchivePath = new Path(entryName);
            if (fullArchivePath.hasTrailingSeparator()) continue;
            for (Pair<String, String> fileNameAndLabel : fileNameAndLabelPairs) {
                Path searchedArchivePath = new Path((String)fileNameAndLabel.getFirst());
                boolean fileMatch = entryName.equalsIgnoreCase(searchedArchivePath.toString());
                boolean folderMatch = entryName.startsWith(searchedArchivePath + "/");
                if (!fileMatch && !folderMatch) continue;
                IPath destinationPath = fullArchivePath.makeRelativeTo(baseSourcePath);
                String resourceLabel = folderMatch ? fullArchivePath.lastSegment() : (String)fileNameAndLabel.getSecond();
                ArchiveProviderElement pe = new ArchiveProviderElement(destinationPath.toString(), resourceLabel, archiveFile, entry);
                objects.add(pe);
                continue block4;
            }
        }
        ImportProvider provider = new ImportProvider();
        ImportOperation operation = new ImportOperation(destinationContainerPath, null, (IImportStructureProvider)provider, (IOverwriteQuery)this, objects);
        operation.setCreateContainerStructure(true);
        operation.setOverwriteResources(true);
        try {
            operation.run((IProgressMonitor)new SubProgressMonitor(monitor, fileNameAndLabelPairs.size(), 4));
            archiveFile.close();
        }
        catch (InvocationTargetException e) {
            return new Status(4, "org.eclipse.linuxtools.tmf.ui", Messages.TracePackage_ErrorOperation, (Throwable)e);
        }
        catch (InterruptedException e) {
            return Status.CANCEL_STATUS;
        }
        catch (IOException e) {
            return new Status(4, "org.eclipse.linuxtools.tmf.ui", Messages.TracePackage_ErrorOperation, (Throwable)e);
        }
        if (provider.getException() != null) {
            return new Status(4, "org.eclipse.linuxtools.tmf.ui", Messages.TracePackage_ErrorOperation, (Throwable)provider.getException());
        }
        return operation.getStatus();
    }

    public String queryOverwrite(String pathString) {
        return null;
    }

    private class ArchiveProviderElement {
        private final String fPath;
        private final String fLabel;
        private AbstractTracePackageOperation.ArchiveFile fArchiveFile;
        private AbstractTracePackageOperation.ArchiveEntry fEntry;

        public ArchiveProviderElement(String destinationPath, String label, AbstractTracePackageOperation.ArchiveFile archiveFile, AbstractTracePackageOperation.ArchiveEntry entry) {
            this.fPath = destinationPath;
            this.fLabel = label;
            this.fArchiveFile = archiveFile;
            this.fEntry = entry;
        }

        public InputStream getContents() throws TarException, IOException {
            return this.fArchiveFile.getInputStream(this.fEntry);
        }

        public String getFullPath() {
            return this.fPath;
        }

        public String getLabel() {
            return this.fLabel;
        }

        public boolean isFolder() {
            return false;
        }
    }

    private class ImportProvider
    implements IImportStructureProvider {
        private Exception fException;

        private ImportProvider() {
        }

        public List getChildren(Object element) {
            return null;
        }

        public InputStream getContents(Object element) {
            InputStream inputStream = null;
            try {
                inputStream = ((ArchiveProviderElement)element).getContents();
            }
            catch (IOException e) {
                this.fException = e;
            }
            catch (TarException e) {
                this.fException = e;
            }
            return inputStream;
        }

        public String getFullPath(Object element) {
            return ((ArchiveProviderElement)element).getFullPath();
        }

        public String getLabel(Object element) {
            return ((ArchiveProviderElement)element).getLabel();
        }

        public boolean isFolder(Object element) {
            return ((ArchiveProviderElement)element).isFolder();
        }

        public Exception getException() {
            return this.fException;
        }
    }
}

