/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.project.model;

import java.net.URL;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.tmf.core.project.model.TmfTraceType;
import org.eclipse.linuxtools.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.linuxtools.tmf.ui.project.model.ITmfStyledProjectModelElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfAnalysisElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfAnalysisOutputElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfCommonProjectElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceTypeUIUtils;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTracesFolder;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonLabelProvider;
import org.osgi.framework.Bundle;

public class TmfNavigatorLabelProvider
implements ICommonLabelProvider,
DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private static final Image fFolderIcon = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    private static final String fTraceIconFile = "icons/elcl16/trace.gif";
    private static final String fExperimentIconFile = "icons/elcl16/experiment.gif";
    private static final String fAnalysisIconFile = "icons/ovr16/experiment_folder_ovr.png";
    private static final String fViewIconFile = "icons/obj16/node_obj.gif";
    private final Image fTraceFolderIcon = fFolderIcon;
    private final Image fExperimentFolderIcon = fFolderIcon;
    private final Image fDefaultTraceIcon;
    private final Image fExperimentIcon;
    private final Image fDefaultAnalysisIcon;
    private final Image fDefaultViewIcon;
    private final WorkbenchLabelProvider fWorkspaceLabelProvider = new WorkbenchLabelProvider();

    public TmfNavigatorLabelProvider() {
        Bundle bundle = Activator.getDefault().getBundle();
        this.fDefaultTraceIcon = TmfNavigatorLabelProvider.loadIcon(bundle, fTraceIconFile);
        this.fExperimentIcon = TmfNavigatorLabelProvider.loadIcon(bundle, fExperimentIconFile);
        this.fDefaultAnalysisIcon = TmfNavigatorLabelProvider.loadIcon(bundle, fAnalysisIconFile);
        this.fDefaultViewIcon = TmfNavigatorLabelProvider.loadIcon(bundle, fViewIconFile);
    }

    private static Image loadIcon(Bundle bundle, String url) {
        URL imageURL;
        ImageDescriptor descriptor;
        Activator plugin = Activator.getDefault();
        String key = String.valueOf(bundle.getSymbolicName()) + "/" + url;
        Image icon = plugin.getImageRegistry().get(key);
        if (icon == null && (descriptor = ImageDescriptor.createFromURL((URL)(imageURL = bundle.getResource(url)))) != null) {
            icon = descriptor.createImage();
            plugin.getImageRegistry().put(key, icon);
        }
        return icon;
    }

    public Image getImage(Object element) {
        if (element instanceof TmfCommonProjectElement) {
            Image image;
            Bundle bundle;
            String name;
            String iconAttr;
            TmfCommonProjectElement trace = (TmfCommonProjectElement)element;
            String traceType = trace.getTraceType();
            if (traceType == null || TmfTraceType.getTraceType((String)traceType) == null) {
                return this.fWorkspaceLabelProvider.getImage((Object)((TmfCommonProjectElement)element).getResource());
            }
            IConfigurationElement traceUIAttributes = TmfTraceTypeUIUtils.getTraceUIAttributes(traceType, element instanceof TmfTraceElement ? TmfTraceType.TraceElementType.TRACE : TmfTraceType.TraceElementType.EXPERIMENT);
            if (traceUIAttributes != null && (iconAttr = traceUIAttributes.getAttribute("icon")) != null && (name = traceUIAttributes.getContributor().getName()) != null && (bundle = Platform.getBundle((String)name)) != null && (image = TmfNavigatorLabelProvider.loadIcon(bundle, iconAttr)) != null) {
                return image;
            }
            if (element instanceof TmfTraceElement) {
                return this.fDefaultTraceIcon;
            }
            return this.fExperimentIcon;
        }
        if (element instanceof TmfExperimentFolder) {
            return this.fExperimentFolderIcon;
        }
        if (element instanceof TmfTraceFolder) {
            return this.fTraceFolderIcon;
        }
        if (element instanceof TmfAnalysisOutputElement) {
            TmfAnalysisOutputElement output = (TmfAnalysisOutputElement)element;
            Image icon = output.getIcon();
            if (icon == null) {
                return this.fDefaultViewIcon;
            }
            return icon;
        }
        if (element instanceof TmfAnalysisElement) {
            Bundle bundle;
            TmfAnalysisElement analysis = (TmfAnalysisElement)element;
            String iconFile = analysis.getIconFile();
            if (iconFile != null && (bundle = analysis.getBundle()) != null) {
                Image icon = TmfNavigatorLabelProvider.loadIcon(bundle, iconFile);
                return icon;
            }
            return this.fDefaultAnalysisIcon;
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof TmfTracesFolder) {
            TmfTracesFolder folder = (TmfTracesFolder)element;
            return String.valueOf(folder.getName()) + " [" + folder.getTraces().size() + "]";
        }
        if (element instanceof TmfTraceFolder) {
            TmfTraceFolder folder = (TmfTraceFolder)element;
            int nbTraces = folder.getTraces().size();
            if (nbTraces > 0) {
                return String.valueOf(folder.getName()) + " [" + folder.getTraces().size() + "]";
            }
            return folder.getName();
        }
        if (element instanceof TmfTraceElement) {
            TmfTraceElement trace = (TmfTraceElement)element;
            if (trace.getParent() instanceof TmfExperimentElement) {
                return trace.getElementPath();
            }
            return trace.getName();
        }
        if (element instanceof TmfExperimentElement) {
            TmfExperimentElement folder = (TmfExperimentElement)element;
            return String.valueOf(folder.getName()) + " [" + folder.getTraces().size() + "]";
        }
        if (element instanceof TmfExperimentFolder) {
            TmfExperimentFolder folder = (TmfExperimentFolder)element;
            return String.valueOf(folder.getName()) + " [" + folder.getChildren().size() + "]";
        }
        if (element instanceof ITmfProjectModelElement) {
            return ((ITmfProjectModelElement)element).getName();
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public String getDescription(Object anElement) {
        return this.getText(anElement);
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public StyledString getStyledText(Object element) {
        String text = this.getText(element);
        if (text != null) {
            StyledString.Styler styler;
            if (element instanceof ITmfStyledProjectModelElement && (styler = ((ITmfStyledProjectModelElement)element).getStyler()) != null) {
                return new StyledString(text, styler);
            }
            return new StyledString(text);
        }
        return null;
    }
}

