/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.viewers.events;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.linuxtools.internal.tmf.core.filter.TmfCollapseFilter;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventField;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventType;
import org.eclipse.linuxtools.tmf.core.filter.ITmfFilter;
import org.eclipse.linuxtools.tmf.core.request.ITmfEventRequest;
import org.eclipse.linuxtools.tmf.core.request.TmfEventRequest;
import org.eclipse.linuxtools.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.ui.viewers.events.TmfEventsTable;

public class TmfEventsCache {
    private final CachedEvent[] fCache;
    private final int fCacheSize;
    private int fCacheStartIndex = 0;
    private int fCacheEndIndex = 0;
    private ITmfTrace fTrace;
    private final TmfEventsTable fTable;
    private ITmfFilter fFilter;
    private final List<Integer> fFilterIndex = new ArrayList<Integer>();
    private Job job;

    public TmfEventsCache(int cacheSize, TmfEventsTable table) {
        this.fCacheSize = cacheSize;
        this.fCache = new CachedEvent[cacheSize * 2];
        this.fTable = table;
    }

    public void setTrace(ITmfTrace trace) {
        this.fTrace = trace;
        this.clear();
    }

    public synchronized void clear() {
        if (this.job != null && this.job.getState() != 0) {
            this.job.cancel();
        }
        Arrays.fill(this.fCache, null);
        this.fCacheStartIndex = 0;
        this.fCacheEndIndex = 0;
        this.fFilterIndex.clear();
    }

    public void applyFilter(ITmfFilter filter) {
        this.fFilter = filter;
        this.clear();
    }

    public void clearFilter() {
        this.fFilter = null;
        this.clear();
    }

    public synchronized CachedEvent getEvent(int index) {
        if (index >= this.fCacheStartIndex && index < this.fCacheEndIndex) {
            int i = index - this.fCacheStartIndex;
            return this.fCache[i];
        }
        this.populateCache(index);
        return null;
    }

    public synchronized CachedEvent peekEvent(int index) {
        if (index >= this.fCacheStartIndex && index < this.fCacheEndIndex) {
            int i = index - this.fCacheStartIndex;
            return this.fCache[i];
        }
        return null;
    }

    public synchronized void storeEvent(ITmfEvent event, long rank, int index) {
        int i;
        if (index == this.fCacheEndIndex && (i = index - this.fCacheStartIndex) < this.fCache.length) {
            this.fCache[i] = new CachedEvent(event, rank);
            ++this.fCacheEndIndex;
        }
        if (this.fFilter != null && index % this.fCacheSize == 0) {
            i = index / this.fCacheSize;
            this.fFilterIndex.add(i, (int)rank);
        }
    }

    public synchronized void updateCollapsedEvent(int index) {
        int i = index - this.fCacheStartIndex;
        if (i < this.fCache.length) {
            ++this.fCache[i].repeatCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFilteredEventIndex(final long rank) {
        int startRank;
        int current;
        ITmfFilter filter = this.fFilter;
        TmfEventsCache tmfEventsCache = this;
        synchronized (tmfEventsCache) {
            int start = 0;
            int end = this.fFilterIndex.size();
            if (this.fCacheEndIndex - this.fCacheStartIndex > 1) {
                if (rank < this.fCache[0].rank) {
                    end = this.fCacheStartIndex / this.fCacheSize + 1;
                } else if (rank > this.fCache[this.fCacheEndIndex - this.fCacheStartIndex - 1].rank) {
                    start = this.fCacheEndIndex / this.fCacheSize;
                } else {
                    int i = 0;
                    while (i < this.fCacheEndIndex - this.fCacheStartIndex) {
                        if (this.fCache[i].rank >= rank) {
                            return this.fCacheStartIndex + i;
                        }
                        ++i;
                    }
                    return this.fCacheEndIndex;
                }
            }
            current = (start + end) / 2;
            while (current != start) {
                if (rank < (long)this.fFilterIndex.get(current).intValue()) {
                    end = current;
                    current = (start + end) / 2;
                    continue;
                }
                start = current;
                current = (start + end) / 2;
            }
            startRank = this.fFilterIndex.size() > 0 ? this.fFilterIndex.get(current) : 0;
        }
        int index = current * this.fCacheSize;
        class DataRequest
        extends TmfEventRequest {
            ITmfFilter requestFilter;
            int requestRank;
            int requestIndex;

            DataRequest(Class<? extends ITmfEvent> dataType, ITmfFilter reqFilter, int start, int nbRequested) {
                super(dataType, TmfTimeRange.ETERNITY, (long)start, nbRequested, ITmfEventRequest.ExecutionType.FOREGROUND);
                this.requestFilter = reqFilter;
                this.requestRank = start;
                this.requestIndex = n;
            }

            public void handleData(ITmfEvent event) {
                super.handleData(event);
                if (this.isCancelled()) {
                    return;
                }
                if ((long)this.requestRank >= rank) {
                    this.cancel();
                    return;
                }
                ++this.requestRank;
                if (this.requestFilter.matches(event)) {
                    ++this.requestIndex;
                }
            }

            public int getFilteredIndex() {
                return this.requestIndex;
            }
        }
        DataRequest request = new DataRequest(ITmfEvent.class, filter, startRank, Integer.MAX_VALUE, index);
        this.fTrace.sendRequest((ITmfEventRequest)request);
        try {
            request.waitForCompletion();
            return request.getFilteredIndex();
        }
        catch (InterruptedException e) {
            Activator.getDefault().logError("Filter request interrupted!", e);
            return 0;
        }
    }

    private synchronized void populateCache(int index) {
        if (this.job != null && this.job.getState() != 0) {
            if (index >= this.fCacheStartIndex && index < this.fCacheStartIndex + this.fCache.length) {
                return;
            }
            this.job.cancel();
        }
        this.fCacheEndIndex = this.fCacheStartIndex = Math.max(0, index - this.fCacheSize);
        this.job = new Job("Fetching Events"){
            private int startIndex;
            private int skipCount;
            {
                this.startIndex = TmfEventsCache.this.fCacheStartIndex;
                this.skipCount = 0;
            }

            protected IStatus run(final IProgressMonitor monitor) {
                int nbRequested;
                if (TmfEventsCache.this.fFilter == null) {
                    nbRequested = TmfEventsCache.this.fCache.length;
                } else {
                    nbRequested = Integer.MAX_VALUE;
                    int i = this.startIndex / TmfEventsCache.this.fCacheSize;
                    if (i < TmfEventsCache.this.fFilterIndex.size()) {
                        this.skipCount = this.startIndex - i * TmfEventsCache.this.fCacheSize;
                        this.startIndex = (Integer)TmfEventsCache.this.fFilterIndex.get(i);
                    }
                }
                TmfEventRequest request = new TmfEventRequest(ITmfEvent.class, TmfTimeRange.ETERNITY, this.startIndex, nbRequested, ITmfEventRequest.ExecutionType.FOREGROUND){
                    private int count;
                    private long rank;
                    {
                        super($anonymous0, $anonymous1, $anonymous2, $anonymous3, $anonymous4);
                        this.count = 0;
                        this.rank = startIndex;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Unable to fully structure code
                     */
                    public void handleData(ITmfEvent event) {
                        if (monitor.isCanceled()) {
                            this.cancel();
                            return;
                        }
                        super.handleData(event);
                        if (TmfEventsCache.access$1(1.access$3(this)) != null && !TmfEventsCache.access$1(1.access$3(this)).matches(event)) ** GOTO lbl-1000
                        v0 = this;
                        v1 = 1.access$1(v0);
                        1.access$2(v0, v1 - 1);
                        if (v1 <= 0) {
                            var2_2 = 1.access$3(this);
                            synchronized (var2_2) {
                                if (monitor.isCanceled()) {
                                    return;
                                }
                                TmfEventsCache.access$2((TmfEventsCache)1.access$3(this))[this.count] = new CachedEvent(event, this.rank);
                                ++this.count;
                                v2 = 1.access$3(this);
                                TmfEventsCache.access$6(v2, TmfEventsCache.access$5(v2) + 1);
                            }
                            if (TmfEventsCache.access$1(1.access$3(this)) != null) {
                                TmfEventsCache.access$7(1.access$3(this)).cacheUpdated(false);
                            }
                        } else if (TmfEventsCache.access$1(1.access$3(this)) != null && !TmfEventsCache.access$1(1.access$3(this)).matches(event) && 1.access$1(this) <= 0 && this.count > 0 && TmfEventsCache.access$1(1.access$3(this)) instanceof TmfCollapseFilter) {
                            ++TmfEventsCache.access$2((TmfEventsCache)1.access$3(this))[this.count - 1].repeatCount;
                        }
                        if (this.count >= TmfEventsCache.access$2(1.access$3(this)).length) {
                            this.cancel();
                        } else if (TmfEventsCache.access$1(1.access$3(this)) != null && this.count >= TmfEventsCache.access$7(1.access$3(this)).getTable().getItemCount() - 3) {
                            this.cancel();
                        }
                        ++this.rank;
                    }
                };
                TmfEventsCache.this.fTrace.sendRequest((ITmfEventRequest)request);
                try {
                    request.waitForCompletion();
                }
                catch (InterruptedException e) {
                    Activator.getDefault().logError("Wait for completion interrupted for populateCache ", e);
                }
                TmfEventsCache.this.fTable.cacheUpdated(true);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }

            static /* synthetic */ int access$1(1 var0) {
                return var0.skipCount;
            }

            static /* synthetic */ void access$2(1 var0, int n) {
                var0.skipCount = n;
            }

            static /* synthetic */ TmfEventsCache access$3(1 var0) {
                return var0.TmfEventsCache.this;
            }
        };
        this.job.setPriority(20);
        this.job.schedule();
    }

    static /* synthetic */ int access$5(TmfEventsCache tmfEventsCache) {
        return tmfEventsCache.fCacheEndIndex;
    }

    static /* synthetic */ void access$6(TmfEventsCache tmfEventsCache, int n) {
        tmfEventsCache.fCacheEndIndex = n;
    }

    public static class CachedEvent
    implements ITmfEvent {
        ITmfEvent event;
        long rank;
        long repeatCount;

        public CachedEvent(ITmfEvent iTmfEvent, long rank) {
            this.event = iTmfEvent;
            this.rank = rank;
        }

        public Object getAdapter(Class adapter) {
            return this.event.getAdapter(adapter);
        }

        public ITmfTrace getTrace() {
            return this.event.getTrace();
        }

        public long getRank() {
            return this.event.getRank();
        }

        public ITmfTimestamp getTimestamp() {
            return this.event.getTimestamp();
        }

        public String getSource() {
            return this.event.getSource();
        }

        public ITmfEventType getType() {
            return this.event.getType();
        }

        public ITmfEventField getContent() {
            return this.event.getContent();
        }

        public String getReference() {
            return this.event.getReference();
        }
    }
}

