/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.viewers.events.columns;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventField;
import org.eclipse.linuxtools.tmf.ui.viewers.events.columns.TmfEventTableColumn;

@NonNullByDefault
public class TmfEventTableFieldColumn
extends TmfEventTableColumn {
    private final String fFieldName;

    public TmfEventTableFieldColumn(String headerAndFieldName) {
        super(headerAndFieldName);
        this.fFieldName = headerAndFieldName;
    }

    public TmfEventTableFieldColumn(String headerName, String fieldName, @Nullable String headerTooltip) {
        super(headerName, headerTooltip);
        this.fFieldName = fieldName;
    }

    @Override
    public final String getItemString(ITmfEvent event) {
        ITmfEventField field = event.getContent().getField(this.fFieldName);
        if (field == null) {
            return "";
        }
        String val = field.getFormattedValue();
        return val == null ? "" : val;
    }

    @Override
    @NonNull
    public String getFilterFieldId() {
        return this.fFieldName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fFieldName.hashCode();
        result = 31 * result + this.getHeaderName().hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TmfEventTableFieldColumn)) {
            return false;
        }
        TmfEventTableFieldColumn other = (TmfEventTableFieldColumn)obj;
        if (!this.fFieldName.equals(other.fFieldName)) {
            return false;
        }
        return this.getHeaderName().equals(other.getHeaderName());
    }
}

