/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.histogram;

import org.eclipse.linuxtools.tmf.ui.views.histogram.Histogram;
import org.eclipse.linuxtools.tmf.ui.views.histogram.HistogramView;
import org.eclipse.linuxtools.tmf.ui.views.histogram.HistogramZoom;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class FullTraceHistogram
extends Histogram {
    private final HistogramZoom fZoom = new HistogramZoom(this, this.getStartTime(), this.getTimeLimit());
    private long fRangeStartTime = 0L;
    private long fRangeDuration;
    private int fStartDelta;
    private boolean fMouseMoved;

    public FullTraceHistogram(HistogramView view, Composite parent) {
        super(view, parent);
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void clear() {
        this.fRangeStartTime = 0L;
        this.fRangeDuration = 0L;
        if (this.fZoom != null) {
            this.fZoom.setFullRange(0L, 0L);
            this.fZoom.setNewRange(0L, 0L);
        }
        super.clear();
    }

    public void setFullRange(long startTime, long endTime) {
        this.fZoom.setFullRange(startTime, endTime);
        this.fZoom.setNewRange(this.fRangeStartTime, this.fRangeDuration);
    }

    public void setTimeRange(long startTime, long duration) {
        this.fRangeStartTime = startTime;
        this.fRangeDuration = duration;
        this.fZoom.setNewRange(this.fRangeStartTime, this.fRangeDuration);
        this.fDataModel.complete();
    }

    @Override
    public void mouseDown(MouseEvent event) {
        if (this.fScaledData != null && this.fDragState == 0 && this.fDataModel.getStartTime() < this.fDataModel.getEndTime()) {
            if (event.button == 2 || event.button == 1 && (event.stateMask & SWT.MODIFIER_MASK) == 262144) {
                this.fDragState = 2;
                this.fDragButton = event.button;
                int center = (int)((this.fRangeStartTime + this.fRangeDuration / 2L - this.fScaledData.fFirstBucketTime) / this.fScaledData.fBucketDuration);
                this.fStartDelta = center - event.x;
                this.fMouseMoved = false;
                return;
            }
            if (event.button == 3) {
                this.fDragState = 3;
                this.fDragButton = event.button;
                long time = Math.min(this.getTimestamp(event.x), this.getEndTime());
                if ((event.stateMask & SWT.MODIFIER_MASK) == 131072) {
                    if (time < this.fRangeStartTime + this.fRangeDuration / 2L) {
                        this.fRangeStartTime += this.fRangeDuration;
                    }
                } else {
                    this.fRangeStartTime = time;
                }
                this.fRangeDuration = time - this.fRangeStartTime;
                this.fCanvas.redraw();
                return;
            }
        }
        super.mouseDown(event);
    }

    @Override
    public void mouseUp(MouseEvent event) {
        if (this.fDragState == 2 && event.button == this.fDragButton) {
            this.fDragState = 0;
            this.fDragButton = 0;
            if (!this.fMouseMoved) {
                long startTime = this.getTimestamp(event.x) - this.fRangeDuration / 2L;
                this.fRangeStartTime = Math.max(this.getStartTime(), Math.min(this.getEndTime() - this.fRangeDuration, startTime));
            }
            ((HistogramView)this.fParentView).updateTimeRange(this.fRangeStartTime, this.fRangeStartTime + this.fRangeDuration);
            return;
        }
        if (this.fDragState == 3 && event.button == this.fDragButton) {
            this.fDragState = 0;
            this.fDragButton = 0;
            if (this.fRangeDuration < 0L) {
                this.fRangeStartTime += this.fRangeDuration;
                this.fRangeDuration = -this.fRangeDuration;
            }
            if (this.fRangeDuration > 0L) {
                ((HistogramView)this.fParentView).updateTimeRange(this.fRangeStartTime, this.fRangeStartTime + this.fRangeDuration);
            } else {
                this.fRangeStartTime = this.fZoom.getStartTime();
                this.fRangeDuration = this.fZoom.getDuration();
                this.fCanvas.redraw();
            }
            return;
        }
        super.mouseUp(event);
    }

    @Override
    public void mouseMove(MouseEvent event) {
        if (this.fDragState == 2) {
            int center = event.x + this.fStartDelta;
            long newStart = this.getTimestamp(center) - this.fRangeDuration / 2L;
            this.fRangeStartTime = Math.max(this.getStartTime(), Math.min(this.getEndTime() - this.fRangeDuration, newStart));
            this.fCanvas.redraw();
            this.fMouseMoved = true;
            return;
        }
        if (this.fDragState == 3) {
            long endTime = Math.max(this.getStartTime(), Math.min(this.getEndTime(), this.getTimestamp(event.x)));
            this.fRangeDuration = endTime - this.fRangeStartTime;
            this.fCanvas.redraw();
            return;
        }
        super.mouseMove(event);
    }

    @Override
    public void paintControl(PaintEvent event) {
        super.paintControl(event);
        Image image = (Image)this.fCanvas.getData("double-buffer-image");
        assert (image != null);
        Image rangeRectangleImage = new Image(image.getDevice(), image, 0);
        GC rangeWindowGC = new GC((Drawable)rangeRectangleImage);
        if (this.fScaledData != null && (this.fRangeDuration != 0L || this.fDragState == 3)) {
            this.drawTimeRangeWindow(rangeWindowGC, this.fRangeStartTime, this.fRangeDuration);
        }
        event.gc.drawImage(rangeRectangleImage, 0, 0);
        rangeWindowGC.dispose();
        rangeRectangleImage.dispose();
    }

    public HistogramZoom getZoom() {
        return this.fZoom;
    }
}

