/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.histogram;

import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.ITmfLostEvent;
import org.eclipse.linuxtools.tmf.core.request.ITmfEventRequest;
import org.eclipse.linuxtools.tmf.core.request.TmfEventRequest;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.linuxtools.tmf.ui.views.histogram.HistogramDataModel;

public class HistogramRequest
extends TmfEventRequest {
    protected final HistogramDataModel fHistogram;
    private final boolean fFullRange;

    public HistogramRequest(HistogramDataModel histogram, TmfTimeRange range, int rank, int nbEvents, int blockSize, ITmfEventRequest.ExecutionType execType, boolean fullRange) {
        super(ITmfEvent.class, range, (long)rank, nbEvents, execType);
        this.fHistogram = histogram;
        this.fFullRange = fullRange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleData(ITmfEvent event) {
        super.handleData(event);
        HistogramDataModel histogramDataModel = this.fHistogram;
        synchronized (histogramDataModel) {
            if (!this.isCancelled()) {
                if (event instanceof ITmfLostEvent) {
                    ITmfLostEvent lostEvents = (ITmfLostEvent)event;
                    this.fHistogram.countLostEvent(lostEvents.getTimeRange(), lostEvents.getNbLostEvents(), this.fFullRange);
                } else {
                    long timestamp = event.getTimestamp().normalize(0L, -9).getValue();
                    this.fHistogram.countEvent(this.getNbRead(), timestamp, event.getTrace());
                }
            }
        }
    }

    public void handleCompleted() {
        this.fHistogram.complete();
        super.handleCompleted();
    }
}

