/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.histogram;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.tmf.core.component.ITmfComponent;
import org.eclipse.linuxtools.tmf.core.request.ITmfEventRequest;
import org.eclipse.linuxtools.tmf.core.signal.TmfRangeSynchSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalThrottler;
import org.eclipse.linuxtools.tmf.core.signal.TmfTimeSynchSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceRangeUpdatedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceUpdatedSignal;
import org.eclipse.linuxtools.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfTraceManager;
import org.eclipse.linuxtools.tmf.ui.views.TmfView;
import org.eclipse.linuxtools.tmf.ui.views.histogram.FullTraceHistogram;
import org.eclipse.linuxtools.tmf.ui.views.histogram.Histogram;
import org.eclipse.linuxtools.tmf.ui.views.histogram.HistogramRequest;
import org.eclipse.linuxtools.tmf.ui.views.histogram.HistogramScaledData;
import org.eclipse.linuxtools.tmf.ui.views.histogram.HistogramSelectionEndControl;
import org.eclipse.linuxtools.tmf.ui.views.histogram.HistogramSelectionStartControl;
import org.eclipse.linuxtools.tmf.ui.views.histogram.HistogramTextControl;
import org.eclipse.linuxtools.tmf.ui.views.histogram.HistogramTimeRangeControl;
import org.eclipse.linuxtools.tmf.ui.views.histogram.HistogramZoom;
import org.eclipse.linuxtools.tmf.ui.views.histogram.Messages;
import org.eclipse.linuxtools.tmf.ui.views.histogram.TimeRangeHistogram;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;

public class HistogramView
extends TmfView {
    @NonNull
    public static final String ID = "org.eclipse.linuxtools.tmf.ui.views.histogram";
    private static final Image LINK_IMG = Activator.getDefault().getImageFromPath("/icons/etool16/link.gif");
    private Composite fParent;
    private ITmfTrace fTrace;
    private long fTraceStartTime;
    private long fTraceEndTime;
    private long fWindowStartTime;
    private long fWindowEndTime;
    private long fWindowSpan;
    private long fSelectionBeginTime;
    private long fSelectionEndTime;
    private HistogramTextControl fSelectionStartControl;
    private HistogramTextControl fSelectionEndControl;
    private HistogramTextControl fTimeSpanControl;
    private Label fLinkButton;
    private boolean fLinkState;
    private static FullTraceHistogram fFullTraceHistogram;
    private HistogramRequest fFullTraceRequest;
    private static TimeRangeHistogram fTimeRangeHistogram;
    private HistogramRequest fTimeRangeRequest;
    private Composite fLegendArea;
    private Image[] fLegendImages;
    private final TmfSignalThrottler fTimeSyncThrottle = new TmfSignalThrottler((ITmfComponent)this, 200L);
    private final TmfSignalThrottler fTimeRangeSyncThrottle = new TmfSignalThrottler((ITmfComponent)this, 200L);
    private Action hideLostEventsAction;
    private Action showTraceAction;

    public HistogramView() {
        super(ID);
    }

    @Override
    public void dispose() {
        if (this.fTimeRangeRequest != null && !this.fTimeRangeRequest.isCompleted()) {
            this.fTimeRangeRequest.cancel();
        }
        if (this.fFullTraceRequest != null && !this.fFullTraceRequest.isCompleted()) {
            this.fFullTraceRequest.cancel();
        }
        fFullTraceHistogram.dispose();
        fTimeRangeHistogram.dispose();
        this.fSelectionStartControl.dispose();
        this.fSelectionEndControl.dispose();
        this.fTimeSpanControl.dispose();
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        this.fParent = parent;
        String selectionStartLabel = Messages.HistogramView_selectionStartLabel;
        String selectionEndLabel = Messages.HistogramView_selectionEndLabel;
        String windowSpanLabel = Messages.HistogramView_windowSpanLabel;
        Composite viewComposite = new Composite(this.fParent, 4);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 5;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        viewComposite.setLayout((Layout)gridLayout);
        Composite controlsComposite = new Composite(viewComposite, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 5;
        gridLayout.verticalSpacing = 1;
        gridLayout.makeColumnsEqualWidth = false;
        controlsComposite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 0x1000000, false, false);
        controlsComposite.setLayoutData((Object)gridData);
        Composite selectionGroup = new Composite(controlsComposite, 2048);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        selectionGroup.setLayout((Layout)gridLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 0x1000000;
        this.fSelectionStartControl = new HistogramSelectionStartControl(this, selectionGroup, selectionStartLabel, 0L);
        this.fSelectionStartControl.setLayoutData(gridData);
        this.fSelectionStartControl.setValue(Long.MIN_VALUE);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 0x1000000;
        this.fSelectionEndControl = new HistogramSelectionEndControl(this, selectionGroup, selectionEndLabel, 0L);
        this.fSelectionEndControl.setLayoutData(gridData);
        this.fSelectionEndControl.setValue(Long.MIN_VALUE);
        gridData = new GridData();
        this.fLinkButton = new Label(controlsComposite, 0);
        this.fLinkButton.setImage(LINK_IMG);
        this.fLinkButton.setLayoutData((Object)gridData);
        this.addLinkButtonListeners();
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 0x1000000;
        this.fTimeSpanControl = new HistogramTimeRangeControl(this, controlsComposite, windowSpanLabel, 0L);
        this.fTimeSpanControl.setLayoutData(gridData);
        this.fTimeSpanControl.setValue(Long.MIN_VALUE);
        Composite timeRangeComposite = new Composite(viewComposite, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginTop = 5;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginLeft = 5;
        gridLayout.marginRight = 5;
        timeRangeComposite.setLayout((Layout)gridLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        timeRangeComposite.setLayoutData((Object)gridData);
        fTimeRangeHistogram = new TimeRangeHistogram(this, timeRangeComposite);
        Composite fullRangeComposite = new Composite(viewComposite, 4);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginTop = 5;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginLeft = 5;
        gridLayout.marginRight = 5;
        fullRangeComposite.setLayout((Layout)gridLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        fullRangeComposite.setLayoutData((Object)gridData);
        fFullTraceHistogram = new FullTraceHistogram(this, fullRangeComposite);
        this.fLegendArea = new Composite(viewComposite, 4);
        this.fLegendArea.setLayoutData((Object)new GridData(1, 1, true, false, 2, 1));
        this.fLegendArea.setLayout((Layout)new RowLayout());
        HistogramZoom listener = fFullTraceHistogram.getZoom();
        this.fTimeSpanControl.addMouseWheelListener(listener);
        this.contributeToActionBars();
        ITmfTrace trace = this.getActiveTrace();
        if (trace != null) {
            this.traceSelected(new TmfTraceSelectedSignal((Object)this, trace));
        }
    }

    public void setFocus() {
        HistogramView.fFullTraceHistogram.fCanvas.setFocus();
    }

    void refresh() {
        this.fParent.layout(true);
    }

    public ITmfTrace getTrace() {
        return this.fTrace;
    }

    public TmfTimeRange getTimeRange() {
        return new TmfTimeRange((ITmfTimestamp)new TmfTimestamp(this.fWindowStartTime, -9), (ITmfTimestamp)new TmfTimestamp(this.fWindowEndTime, -9));
    }

    public Action getShowLostEventsAction() {
        if (this.hideLostEventsAction == null) {
            this.hideLostEventsAction = new Action(Messages.HistogramView_hideLostEvents, 2){

                public void run() {
                    HistogramScaledData.hideLostEvents = HistogramView.this.hideLostEventsAction.isChecked();
                    long maxNbEvents = HistogramScaledData.hideLostEvents ? fFullTraceHistogram.fScaledData.fMaxValue : fFullTraceHistogram.fScaledData.fMaxCombinedValue;
                    fFullTraceHistogram.setMaxNbEvents(maxNbEvents);
                    maxNbEvents = HistogramScaledData.hideLostEvents ? fTimeRangeHistogram.fScaledData.fMaxValue : fTimeRangeHistogram.fScaledData.fMaxCombinedValue;
                    fTimeRangeHistogram.setMaxNbEvents(maxNbEvents);
                }
            };
            this.hideLostEventsAction.setText(Messages.HistogramView_hideLostEvents);
            this.hideLostEventsAction.setToolTipText(Messages.HistogramView_hideLostEvents);
            this.hideLostEventsAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/hide_lost_events.gif"));
        }
        return this.hideLostEventsAction;
    }

    public Action getShowTraceAction() {
        if (this.showTraceAction == null) {
            this.showTraceAction = new Action(Messages.HistogramView_showTraces, 2){

                public void run() {
                    Histogram.showTraces = HistogramView.this.showTraceAction.isChecked();
                    fFullTraceHistogram.fCanvas.redraw();
                    fTimeRangeHistogram.fCanvas.redraw();
                    HistogramView.this.updateLegendArea();
                }
            };
            this.showTraceAction.setChecked(true);
            this.showTraceAction.setText(Messages.HistogramView_showTraces);
            this.showTraceAction.setToolTipText(Messages.HistogramView_showTraces);
            this.showTraceAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/show_hist_traces.gif"));
        }
        return this.showTraceAction;
    }

    void updateSelectionTime(long beginTime, long endTime) {
        this.updateDisplayedSelectionTime(beginTime, endTime);
        TmfTimestamp beginTs = new TmfTimestamp(beginTime, -9);
        TmfTimestamp endTs = new TmfTimestamp(endTime, -9);
        TmfTimeSynchSignal signal = new TmfTimeSynchSignal((Object)this, (ITmfTimestamp)beginTs, (ITmfTimestamp)endTs);
        this.fTimeSyncThrottle.queue((TmfSignal)signal);
    }

    long getSelectionBegin() {
        return this.fSelectionBeginTime;
    }

    long getSelectionEnd() {
        return this.fSelectionEndTime;
    }

    boolean getLinkState() {
        return this.fLinkState;
    }

    void updateTimeRange(long startTime, long endTime) {
        if (this.fTrace != null) {
            TmfTimeRange timeRange = new TmfTimeRange((ITmfTimestamp)new TmfTimestamp(startTime, -9), (ITmfTimestamp)new TmfTimestamp(endTime, -9));
            this.fTimeSpanControl.setValue(endTime - startTime);
            this.updateDisplayedTimeRange(startTime, endTime);
            TmfRangeSynchSignal signal = new TmfRangeSynchSignal((Object)this, timeRange);
            this.fTimeRangeSyncThrottle.queue((TmfSignal)signal);
        }
    }

    public synchronized void updateTimeRange(long newDuration) {
        if (this.fTrace != null) {
            long delta = newDuration - this.fWindowSpan;
            long newStartTime = this.fWindowStartTime - delta / 2L;
            this.setNewRange(newStartTime, newDuration);
        }
    }

    private void setNewRange(long startTime, long duration) {
        long endTime;
        long realStart = startTime;
        if (realStart < this.fTraceStartTime) {
            realStart = this.fTraceStartTime;
        }
        if ((endTime = realStart + duration) > this.fTraceEndTime) {
            endTime = this.fTraceEndTime;
            realStart = endTime - duration > this.fTraceStartTime ? endTime - duration : this.fTraceStartTime;
        }
        this.updateTimeRange(realStart, endTime);
    }

    @TmfSignalHandler
    public void traceOpened(TmfTraceOpenedSignal signal) {
        assert (signal != null);
        this.fTrace = signal.getTrace();
        this.loadTrace();
    }

    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        assert (signal != null);
        if (this.fTrace != signal.getTrace()) {
            this.fTrace = signal.getTrace();
            this.loadTrace();
        }
    }

    private void loadTrace() {
        this.initializeHistograms();
        this.fParent.redraw();
    }

    @TmfSignalHandler
    public void traceClosed(TmfTraceClosedSignal signal) {
        if (signal.getTrace() != this.fTrace) {
            return;
        }
        if (this.fTimeRangeRequest != null && !this.fTimeRangeRequest.isCompleted()) {
            this.fTimeRangeRequest.cancel();
        }
        if (this.fFullTraceRequest != null && !this.fFullTraceRequest.isCompleted()) {
            this.fFullTraceRequest.cancel();
        }
        this.fTrace = null;
        this.fTraceStartTime = 0L;
        this.fTraceEndTime = 0L;
        this.fWindowStartTime = 0L;
        this.fWindowEndTime = 0L;
        this.fWindowSpan = 0L;
        this.fSelectionBeginTime = 0L;
        this.fSelectionEndTime = 0L;
        fFullTraceHistogram.clear();
        fTimeRangeHistogram.clear();
        this.fSelectionStartControl.setValue(Long.MIN_VALUE);
        this.fSelectionEndControl.setValue(Long.MIN_VALUE);
        this.fTimeSpanControl.setValue(Long.MIN_VALUE);
        Control[] controlArray = this.fLegendArea.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        if (this.fLegendImages != null) {
            controlArray = this.fLegendImages;
            n = this.fLegendImages.length;
            n2 = 0;
            while (n2 < n) {
                Control i = controlArray[n2];
                i.dispose();
                ++n2;
            }
        }
        this.fLegendImages = null;
        this.fLegendArea.layout();
        this.fLegendArea.getParent().layout();
    }

    @TmfSignalHandler
    public void traceRangeUpdated(TmfTraceRangeUpdatedSignal signal) {
        if (signal.getTrace() != this.fTrace) {
            return;
        }
        TmfTimeRange fullRange = signal.getRange();
        this.fTraceStartTime = fullRange.getStartTime().normalize(0L, -9).getValue();
        this.fTraceEndTime = fullRange.getEndTime().normalize(0L, -9).getValue();
        fFullTraceHistogram.setFullRange(this.fTraceStartTime, this.fTraceEndTime);
        fTimeRangeHistogram.setFullRange(this.fTraceStartTime, this.fTraceEndTime);
        this.sendFullRangeRequest(fullRange);
    }

    @TmfSignalHandler
    public void traceUpdated(TmfTraceUpdatedSignal signal) {
        if (signal.getTrace() != this.fTrace) {
            return;
        }
        TmfTimeRange fullRange = signal.getTrace().getTimeRange();
        this.fTraceStartTime = fullRange.getStartTime().normalize(0L, -9).getValue();
        this.fTraceEndTime = fullRange.getEndTime().normalize(0L, -9).getValue();
        fFullTraceHistogram.setFullRange(this.fTraceStartTime, this.fTraceEndTime);
        fTimeRangeHistogram.setFullRange(this.fTraceStartTime, this.fTraceEndTime);
        if (this.fFullTraceRequest != null && this.fFullTraceRequest.getRange().getEndTime().compareTo(signal.getRange().getEndTime()) < 0) {
            this.sendFullRangeRequest(fullRange);
        }
    }

    @TmfSignalHandler
    public void currentTimeUpdated(final TmfTimeSynchSignal signal) {
        if (Display.getCurrent() == null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (HistogramView.this.fParent.isDisposed()) {
                        return;
                    }
                    HistogramView.this.currentTimeUpdated(signal);
                }
            });
            return;
        }
        ITmfTimestamp beginTime = signal.getBeginTime().normalize(0L, -9);
        ITmfTimestamp endTime = signal.getEndTime().normalize(0L, -9);
        this.updateDisplayedSelectionTime(beginTime.getValue(), endTime.getValue());
    }

    @TmfSignalHandler
    public void timeRangeUpdated(final TmfRangeSynchSignal signal) {
        if (Display.getCurrent() == null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (HistogramView.this.fParent.isDisposed()) {
                        return;
                    }
                    HistogramView.this.timeRangeUpdated(signal);
                }
            });
            return;
        }
        if (this.fTrace != null) {
            TmfTimeRange range = signal.getCurrentRange().getIntersection(this.fTrace.getTimeRange());
            if (range == null) {
                return;
            }
            this.updateDisplayedTimeRange(range.getStartTime().normalize(0L, -9).getValue(), range.getEndTime().normalize(0L, -9).getValue());
            this.sendTimeRangeRequest(this.fWindowStartTime, this.fWindowEndTime);
            this.fTimeSpanControl.setValue(this.fWindowSpan);
        }
    }

    private void initializeHistograms() {
        TmfTimeRange fullRange = this.updateTraceTimeRange();
        long selectionBeginTime = this.fTraceManager.getSelectionBeginTime().normalize(0L, -9).getValue();
        long selectionEndTime = this.fTraceManager.getSelectionEndTime().normalize(0L, -9).getValue();
        long startTime = this.fTraceManager.getCurrentRange().getStartTime().normalize(0L, -9).getValue();
        long duration = this.fTraceManager.getCurrentRange().getEndTime().normalize(0L, -9).getValue() - startTime;
        if (this.fTimeRangeRequest != null && !this.fTimeRangeRequest.isCompleted()) {
            this.fTimeRangeRequest.cancel();
        }
        fTimeRangeHistogram.clear();
        fTimeRangeHistogram.setFullRange(this.fTraceStartTime, this.fTraceEndTime);
        fTimeRangeHistogram.setTimeRange(startTime, duration);
        fTimeRangeHistogram.setSelection(selectionBeginTime, selectionEndTime);
        HistogramView.fTimeRangeHistogram.fDataModel.setTrace(this.fTrace);
        if (this.fFullTraceRequest != null && !this.fFullTraceRequest.isCompleted()) {
            this.fFullTraceRequest.cancel();
        }
        fFullTraceHistogram.clear();
        fFullTraceHistogram.setFullRange(this.fTraceStartTime, this.fTraceEndTime);
        fFullTraceHistogram.setTimeRange(startTime, duration);
        fFullTraceHistogram.setSelection(selectionBeginTime, selectionEndTime);
        HistogramView.fFullTraceHistogram.fDataModel.setTrace(this.fTrace);
        this.fWindowStartTime = startTime;
        this.fWindowSpan = duration;
        this.fWindowEndTime = startTime + duration;
        this.fSelectionBeginTime = selectionBeginTime;
        this.fSelectionEndTime = selectionEndTime;
        this.fSelectionStartControl.setValue(this.fSelectionBeginTime);
        this.fSelectionEndControl.setValue(this.fSelectionEndTime);
        this.fTimeSpanControl.setValue(duration);
        ITmfTrace[] traces = TmfTraceManager.getTraceSet((ITmfTrace)this.fTrace);
        if (traces != null) {
            this.showTraceAction.setEnabled(traces.length < fFullTraceHistogram.getMaxNbTraces());
        }
        this.updateLegendArea();
        if (!fullRange.equals((Object)TmfTimeRange.NULL_RANGE)) {
            this.sendTimeRangeRequest(startTime, startTime + duration);
            this.sendFullRangeRequest(fullRange);
        }
    }

    private void updateLegendArea() {
        Control[] controlArray = this.fLegendArea.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        if (this.fLegendImages != null) {
            controlArray = this.fLegendImages;
            n = this.fLegendImages.length;
            n2 = 0;
            while (n2 < n) {
                Control i = controlArray[n2];
                i.dispose();
                ++n2;
            }
        }
        this.fLegendImages = null;
        if (fFullTraceHistogram.showTraces()) {
            ITmfTrace[] traces = TmfTraceManager.getTraceSet((ITmfTrace)this.fTrace);
            this.fLegendImages = new Image[traces.length];
            int traceIndex = 0;
            ITmfTrace[] iTmfTraceArray = traces;
            int n3 = traces.length;
            int n4 = 0;
            while (n4 < n3) {
                ITmfTrace trace = iTmfTraceArray[n4];
                this.fLegendImages[traceIndex] = new Image((Device)this.fLegendArea.getDisplay(), 16, 16);
                GC gc = new GC((Drawable)this.fLegendImages[traceIndex]);
                gc.setBackground(fFullTraceHistogram.getTraceColor(traceIndex));
                gc.fillRectangle(0, 0, 15, 15);
                gc.setForeground(this.fLegendArea.getDisplay().getSystemColor(2));
                gc.drawRectangle(0, 0, 15, 15);
                gc.dispose();
                CLabel label = new CLabel(this.fLegendArea, 0);
                label.setText(trace.getName());
                label.setImage(this.fLegendImages[traceIndex]);
                ++traceIndex;
                ++n4;
            }
        }
        this.fLegendArea.layout();
        this.fLegendArea.getParent().layout();
    }

    private void updateDisplayedSelectionTime(long beginTime, long endTime) {
        this.fSelectionBeginTime = beginTime;
        this.fSelectionEndTime = endTime;
        fFullTraceHistogram.setSelection(this.fSelectionBeginTime, this.fSelectionEndTime);
        fTimeRangeHistogram.setSelection(this.fSelectionBeginTime, this.fSelectionEndTime);
        this.fSelectionStartControl.setValue(this.fSelectionBeginTime);
        this.fSelectionEndControl.setValue(this.fSelectionEndTime);
    }

    private void updateDisplayedTimeRange(long start, long end) {
        this.fWindowStartTime = start;
        this.fWindowEndTime = end;
        this.fWindowSpan = this.fWindowEndTime - this.fWindowStartTime;
        fFullTraceHistogram.setTimeRange(this.fWindowStartTime, this.fWindowSpan);
    }

    private TmfTimeRange updateTraceTimeRange() {
        this.fTraceStartTime = 0L;
        this.fTraceEndTime = 0L;
        TmfTimeRange timeRange = this.fTrace.getTimeRange();
        if (!timeRange.equals((Object)TmfTimeRange.NULL_RANGE)) {
            this.fTraceStartTime = timeRange.getStartTime().normalize(0L, -9).getValue();
            this.fTraceEndTime = timeRange.getEndTime().normalize(0L, -9).getValue();
        }
        return timeRange;
    }

    private void sendTimeRangeRequest(long startTime, long endTime) {
        if (this.fTimeRangeRequest != null && !this.fTimeRangeRequest.isCompleted()) {
            this.fTimeRangeRequest.cancel();
        }
        TmfTimestamp startTS = new TmfTimestamp(startTime, -9);
        TmfTimestamp endTS = new TmfTimestamp(endTime, -9);
        TmfTimeRange timeRange = new TmfTimeRange((ITmfTimestamp)startTS, (ITmfTimestamp)endTS);
        fTimeRangeHistogram.clear();
        fTimeRangeHistogram.setFullRange(this.fTraceStartTime, this.fTraceEndTime);
        fTimeRangeHistogram.setTimeRange(startTime, endTime - startTime);
        int cacheSize = this.fTrace.getCacheSize();
        this.fTimeRangeRequest = new HistogramRequest(fTimeRangeHistogram.getDataModel(), timeRange, 0, Integer.MAX_VALUE, cacheSize, ITmfEventRequest.ExecutionType.FOREGROUND, false);
        this.fTrace.sendRequest((ITmfEventRequest)this.fTimeRangeRequest);
    }

    private void sendFullRangeRequest(TmfTimeRange fullRange) {
        if (this.fFullTraceRequest != null && !this.fFullTraceRequest.isCompleted()) {
            this.fFullTraceRequest.cancel();
        }
        int cacheSize = this.fTrace.getCacheSize();
        this.fFullTraceRequest = new HistogramRequest(fFullTraceHistogram.getDataModel(), fullRange, (int)HistogramView.fFullTraceHistogram.fDataModel.getNbEvents(), Integer.MAX_VALUE, cacheSize, ITmfEventRequest.ExecutionType.BACKGROUND, true);
        this.fTrace.sendRequest((ITmfEventRequest)this.fFullTraceRequest);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        bars.getToolBarManager().add((IAction)this.getShowLostEventsAction());
        bars.getToolBarManager().add((IAction)this.getShowTraceAction());
        bars.getToolBarManager().add((IContributionItem)new Separator());
    }

    private void addLinkButtonListeners() {
        this.fLinkButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                HistogramView.this.fSelectionEndControl.setEnabled(HistogramView.this.fLinkState);
                HistogramView.this.fLinkState = !HistogramView.this.fLinkState;
                HistogramView.this.fLinkButton.redraw();
            }
        });
        this.fLinkButton.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (HistogramView.this.fLinkState) {
                    Rectangle r = HistogramView.this.fLinkButton.getBounds();
                    r.x = -1;
                    r.y = -1;
                    e.gc.setForeground(e.display.getSystemColor(18));
                    e.gc.drawRectangle(r);
                    r.x = 0;
                    r.y = 0;
                    e.gc.setForeground(e.display.getSystemColor(16));
                    e.gc.drawRectangle(r);
                }
            }
        });
    }
}

