/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.histogram;

import org.eclipse.linuxtools.tmf.ui.views.histogram.Histogram;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseWheelListener;

public class HistogramZoom
implements MouseWheelListener,
KeyListener {
    private static final double ZOOM_FACTOR = 0.8;
    private final Histogram fHistogram;
    private long fAbsoluteStartTime;
    private long fAbsoluteEndTime;
    private final long fMinWindowSize;
    private long fRangeStartTime;
    private long fRangeDuration;

    public HistogramZoom(Histogram histogram, long start, long end) {
        this.fHistogram = histogram;
        this.fAbsoluteStartTime = start;
        this.fAbsoluteEndTime = end;
        this.fMinWindowSize = 0L;
        this.fRangeStartTime = this.fAbsoluteStartTime;
        this.fRangeDuration = this.fAbsoluteStartTime + this.fMinWindowSize;
        histogram.addMouseWheelListener(this);
        histogram.addKeyListener(this);
    }

    public synchronized long getStartTime() {
        return this.fRangeStartTime;
    }

    public synchronized long getEndTime() {
        return this.fRangeStartTime + this.fRangeDuration;
    }

    public synchronized long getDuration() {
        return this.fRangeDuration;
    }

    public synchronized void setFullRange(long startTime, long endTime) {
        this.fAbsoluteStartTime = startTime;
        this.fAbsoluteEndTime = endTime;
    }

    public synchronized void setNewRange(long startTime, long duration) {
        long endTime;
        long realStart = startTime;
        if (realStart < this.fAbsoluteStartTime) {
            realStart = this.fAbsoluteStartTime;
        }
        if ((endTime = realStart + duration) > this.fAbsoluteEndTime) {
            endTime = this.fAbsoluteEndTime;
            realStart = endTime - duration > this.fAbsoluteStartTime ? endTime - duration : this.fAbsoluteStartTime;
        }
        this.fRangeStartTime = realStart;
        this.fRangeDuration = endTime - realStart;
    }

    public void mouseScrolled(MouseEvent event) {
        this.zoom(event.count);
    }

    public void keyPressed(KeyEvent e) {
        if (e.character == '+') {
            this.zoom(1);
        } else if (e.character == '-') {
            this.zoom(-1);
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    private synchronized void zoom(int nbClicks) {
        long requestedRange = nbClicks > 0 ? Math.round(0.8 * (double)this.fRangeDuration) : (long)Math.ceil((double)this.fRangeDuration * 1.25);
        long requestedStart = this.validateStart(this.fRangeStartTime + (this.fRangeDuration - requestedRange) / 2L);
        long requestedEnd = this.validateEnd(requestedStart, requestedStart + requestedRange);
        requestedStart = this.validateStart(requestedEnd - requestedRange);
        this.fHistogram.updateTimeRange(requestedStart, requestedEnd);
    }

    private long validateStart(long start) {
        long realStart = start;
        if (realStart < this.fAbsoluteStartTime) {
            realStart = this.fAbsoluteStartTime;
        }
        if (realStart > this.fAbsoluteEndTime) {
            realStart = this.fAbsoluteEndTime - this.fMinWindowSize;
        }
        return realStart;
    }

    private long validateEnd(long start, long end) {
        long realEnd = end;
        if (realEnd > this.fAbsoluteEndTime) {
            realEnd = this.fAbsoluteEndTime;
        }
        if (realEnd < start + this.fMinWindowSize) {
            realEnd = start + this.fMinWindowSize;
        }
        return realEnd;
    }
}

