/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.histogram;

import org.eclipse.linuxtools.tmf.ui.views.histogram.Histogram;
import org.eclipse.linuxtools.tmf.ui.views.histogram.HistogramView;
import org.eclipse.linuxtools.tmf.ui.views.histogram.HistogramZoom;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class TimeRangeHistogram
extends Histogram {
    private HistogramZoom fZoom = new HistogramZoom(this, this.getStartTime(), this.getTimeLimit());
    private long fRangeStartTime = 0L;
    private long fRangeDuration;
    private long fFullRangeStartTime = 0L;
    private long fFullRangeEndTime = 0L;
    private int fStartPosition;
    private int fMinOffset;
    private int fMaxOffset;

    public TimeRangeHistogram(HistogramView view, Composite parent) {
        super(view, parent);
    }

    @Override
    public synchronized void clear() {
        this.fRangeStartTime = 0L;
        this.fRangeDuration = 0L;
        this.fFullRangeStartTime = 0L;
        this.fFullRangeEndTime = 0L;
        this.setOffset(0);
        if (this.fZoom != null) {
            this.fZoom.setFullRange(0L, 0L);
            this.fZoom.setNewRange(0L, 0L);
        }
        super.clear();
    }

    public synchronized void setTimeRange(long startTime, long duration) {
        this.fRangeStartTime = startTime;
        this.fRangeDuration = duration;
        this.fZoom.setNewRange(startTime, duration);
        if (this.getDataModel().getNbEvents() == 0L) {
            this.getDataModel().setTimeRange(startTime, startTime + duration);
            this.getDataModel().setEndTime(startTime + duration);
        }
    }

    public void setFullRange(long startTime, long endTime) {
        this.fFullRangeStartTime = startTime;
        this.fFullRangeEndTime = endTime;
        this.fZoom.setFullRange(startTime, endTime);
        this.fZoom.setNewRange(this.fRangeStartTime, this.fRangeDuration);
    }

    @Override
    public void mouseDown(MouseEvent event) {
        if (this.fScaledData != null && this.fDragState == 0 && this.fDataModel.getStartTime() < this.fDataModel.getEndTime()) {
            if (event.button == 2 || event.button == 1 && (event.stateMask & SWT.MODIFIER_MASK) == 262144) {
                this.fDragState = 2;
                this.fDragButton = event.button;
                this.fStartPosition = event.x;
                long maxOffset = (this.fRangeStartTime - this.fFullRangeStartTime) / this.fScaledData.fBucketDuration;
                long minOffset = (this.fRangeStartTime + this.fRangeDuration - this.fFullRangeEndTime) / this.fScaledData.fBucketDuration;
                this.fMaxOffset = (int)Math.max(Integer.MIN_VALUE, Math.min(Integer.MAX_VALUE, maxOffset));
                this.fMinOffset = (int)Math.max(Integer.MIN_VALUE, Math.min(Integer.MAX_VALUE, minOffset));
                return;
            }
            if (event.button == 3) {
                this.fDragState = 3;
                this.fDragButton = event.button;
                this.fRangeStartTime = Math.min(this.getTimestamp(event.x), this.getEndTime());
                this.fRangeDuration = 0L;
                this.fCanvas.redraw();
                return;
            }
        }
        super.mouseDown(event);
    }

    @Override
    public void mouseUp(MouseEvent event) {
        if (this.fDragState == 2 && event.button == this.fDragButton) {
            this.fDragState = 0;
            this.fDragButton = 0;
            if (event.x != this.fStartPosition) {
                int nbBuckets = event.x - this.fStartPosition;
                long delta = (long)nbBuckets * this.fScaledData.fBucketDuration;
                long startTime = this.fRangeStartTime - delta;
                this.fRangeStartTime = Math.max(this.fFullRangeStartTime, Math.min(this.fFullRangeEndTime - this.fRangeDuration, startTime));
                ((HistogramView)this.fParentView).updateTimeRange(this.fRangeStartTime, this.fRangeStartTime + this.fRangeDuration);
                this.setOffset(0);
            }
            return;
        }
        if (this.fDragState == 3 && event.button == this.fDragButton) {
            this.fDragState = 0;
            this.fDragButton = 0;
            if (this.fRangeDuration < 0L) {
                this.fRangeStartTime += this.fRangeDuration;
                this.fRangeDuration = -this.fRangeDuration;
            }
            if (this.fRangeDuration > 0L) {
                ((HistogramView)this.fParentView).updateTimeRange(this.fRangeStartTime, this.fRangeStartTime + this.fRangeDuration);
            } else {
                this.fRangeStartTime = this.fZoom.getStartTime();
                this.fRangeDuration = this.fZoom.getDuration();
                this.fCanvas.redraw();
            }
            return;
        }
        super.mouseUp(event);
    }

    @Override
    public void mouseMove(MouseEvent event) {
        if (this.fDragState == 2) {
            int offset = Math.max(this.fMinOffset, Math.min(this.fMaxOffset, event.x - this.fStartPosition));
            this.setOffset(offset);
            this.fCanvas.redraw();
            return;
        }
        if (this.fDragState == 3) {
            long endTime = Math.max(this.getStartTime(), Math.min(this.getEndTime(), this.getTimestamp(event.x)));
            this.fRangeDuration = endTime - this.fRangeStartTime;
            this.fCanvas.redraw();
            return;
        }
        super.mouseMove(event);
    }

    @Override
    public void paintControl(PaintEvent event) {
        super.paintControl(event);
        if (this.fDragState == 3) {
            Image image = (Image)this.fCanvas.getData("double-buffer-image");
            assert (image != null);
            Image rangeRectangleImage = new Image(image.getDevice(), image, 0);
            GC rangeWindowGC = new GC((Drawable)rangeRectangleImage);
            this.drawTimeRangeWindow(rangeWindowGC, this.fRangeStartTime, this.fRangeDuration);
            event.gc.drawImage(rangeRectangleImage, 0, 0);
            rangeWindowGC.dispose();
            rangeRectangleImage.dispose();
        }
    }
}

