/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.synchronization;

import java.util.Map;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceSynchronizedSignal;
import org.eclipse.linuxtools.tmf.core.synchronization.SynchronizationAlgorithm;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfExperiment;
import org.eclipse.linuxtools.tmf.core.trace.TmfTraceManager;
import org.eclipse.linuxtools.tmf.ui.views.TmfView;
import org.eclipse.linuxtools.tmf.ui.views.synchronization.Messages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class TmfSynchronizationView
extends TmfView {
    public static final String ID = "org.eclipse.linuxtools.tmf.ui.views.synchronization";
    public static final String TMF_SYNCHRONIZATION_VIEW = "SynchronizationView";
    private SynchronizationAlgorithm fAlgoSync;
    private Tree fTree;

    public TmfSynchronizationView() {
        super(TMF_SYNCHRONIZATION_VIEW);
    }

    public void createPartControl(Composite parent) {
        this.fTree = new Tree(parent, 0);
        TreeColumn nameCol = new TreeColumn(this.fTree, 0, 0);
        TreeColumn valueCol = new TreeColumn(this.fTree, 0, 1);
        nameCol.setText(Messages.TmfSynchronizationView_NameColumn);
        valueCol.setText(Messages.TmfSynchronizationView_ValueColumn);
        this.fTree.setItemCount(0);
        this.fTree.setHeaderVisible(true);
        nameCol.pack();
        valueCol.pack();
        ITmfTrace trace = TmfTraceManager.getInstance().getActiveTrace();
        if (trace != null) {
            this.traceSelected(new TmfTraceSelectedSignal((Object)this, trace));
        }
    }

    private void updateTable() {
        this.fTree.setItemCount(0);
        if (this.fAlgoSync == null) {
            return;
        }
        for (Map.Entry entry : this.fAlgoSync.getStats().entrySet()) {
            TreeItem item = new TreeItem(this.fTree, 0);
            item.setText(0, ((String)entry.getKey()).toString());
            item.setText(1, ((Map)entry.getValue()).toString());
            for (Map.Entry subentry : ((Map)entry.getValue()).entrySet()) {
                TreeItem subitem = new TreeItem(item, 0);
                subitem.setText(0, ((String)subentry.getKey()).toString());
                subitem.setText(1, subentry.getValue().toString());
            }
        }
        int i = 0;
        while (i < this.fTree.getItemCount()) {
            this.fTree.getItem(i).setExpanded(true);
            ++i;
        }
        TreeColumn[] treeColumnArray = this.fTree.getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn column = treeColumnArray[n2];
            column.pack();
            ++n2;
        }
    }

    public void setFocus() {
        this.fTree.setFocus();
    }

    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        this.fAlgoSync = null;
        if (signal.getTrace() instanceof TmfExperiment) {
            this.fAlgoSync = ((TmfExperiment)signal.getTrace()).synchronizeTraces();
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                TmfSynchronizationView.this.updateTable();
            }
        });
    }

    @TmfSignalHandler
    public void traceSynchronized(TmfTraceSynchronizedSignal signal) {
        if (signal.getSyncAlgo() != this.fAlgoSync) {
            this.fAlgoSync = signal.getSyncAlgo();
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TmfSynchronizationView.this.updateTable();
                }
            });
        }
    }
}

