/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.widgets.timegraph.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.linuxtools.internal.tmf.ui.Messages;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.dialogs.FilteredCheckboxTree;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.dialogs.TreePatternFilter;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class TimeGraphFilterDialog
extends SelectionStatusDialog {
    private static final int BUTTON_CHECK_SELECTED_ID = 1024;
    private static final int BUTTON_UNCHECK_SELECTED_ID = 1025;
    private static final int BUTTON_CHECK_SUBTREE_ID = 1026;
    private static final int BUTTON_UNCHECK_SUBTREE_ID = 1027;
    private static final int DEFAULT_WIDTH = 60;
    private static final int DEFAULT_HEIGHT = 18;
    private FilteredCheckboxTree fTree;
    private IBaseLabelProvider fLabelProvider;
    private ITreeContentProvider fContentProvider;
    private String[] fColumnNames;
    private ISelectionStatusValidator fValidator = null;
    private ViewerComparator fComparator;
    private String fEmptyListMessage = "";
    private IStatus fCurrStatus = new Status(0, "org.eclipse.ui", 0, "", null);
    private List<ViewerFilter> fFilters;
    private Object fInput;
    private boolean fIsEmpty;
    private int fWidth = 60;
    private int fHeight = 18;
    private Object[] fExpandedElements;

    public TimeGraphFilterDialog(Shell parent) {
        super(parent);
        this.setResult(new ArrayList(0));
        this.setStatusLineAboveButtons(true);
        this.setHelpAvailable(false);
        this.fExpandedElements = null;
    }

    public void setInitialSelection(Object selection) {
        this.setInitialSelections(new Object[]{selection});
    }

    public void setEmptyListMessage(String message) {
        this.fEmptyListMessage = message;
    }

    public void setComparator(ViewerComparator comparator) {
        this.fComparator = comparator;
    }

    public void addFilter(ViewerFilter filter) {
        if (this.fFilters == null) {
            this.fFilters = new ArrayList<ViewerFilter>();
        }
        this.fFilters.add(filter);
    }

    public void setValidator(ISelectionStatusValidator validator) {
        this.fValidator = validator;
    }

    public void setInput(Object input) {
        this.fInput = input;
    }

    public void setExpandedElements(Object[] elements) {
        this.fExpandedElements = elements != null ? Arrays.copyOf(elements, elements.length) : null;
    }

    public void setSize(int width, int height) {
        this.fWidth = width;
        this.fHeight = height;
    }

    public void setContentProvider(ITreeContentProvider contentProvider) {
        this.fContentProvider = contentProvider;
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        this.fLabelProvider = labelProvider;
    }

    public void setColumnNames(String[] columnNames) {
        this.fColumnNames = columnNames != null ? Arrays.copyOf(columnNames, columnNames.length) : null;
    }

    protected void updateOKStatus() {
        if (!this.fIsEmpty) {
            if (this.fValidator != null) {
                this.fCurrStatus = this.fValidator.validate(this.fTree.getCheckedElements());
                this.updateStatus(this.fCurrStatus);
            } else if (!this.fCurrStatus.isOK()) {
                this.fCurrStatus = new Status(0, "org.eclipse.ui", 0, "", null);
            }
        } else {
            this.fCurrStatus = new Status(4, "org.eclipse.ui", 0, this.fEmptyListMessage, null);
        }
        this.updateStatus(this.fCurrStatus);
    }

    public int open() {
        this.fIsEmpty = this.evaluateIfTreeEmpty(this.fInput);
        super.open();
        return this.getReturnCode();
    }

    protected void cancelPressed() {
        this.setResult(null);
        super.cancelPressed();
    }

    protected void computeResult() {
        this.setResult(Arrays.asList(this.fTree.getCheckedElements()));
    }

    public void create() {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                TimeGraphFilterDialog.super.create();
                TimeGraphFilterDialog.this.fTree.setCheckedElements(TimeGraphFilterDialog.this.getInitialElementSelections().toArray());
                if (TimeGraphFilterDialog.this.fExpandedElements != null) {
                    TimeGraphFilterDialog.this.fTree.getViewer().setExpandedElements(TimeGraphFilterDialog.this.fExpandedElements);
                }
                TimeGraphFilterDialog.this.updateOKStatus();
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Label messageLabel = this.createMessageArea(composite);
        CheckboxTreeViewer treeViewer = this.createTreeViewer(composite);
        Composite buttonComposite = this.createSelectionButtons(composite);
        GridData data = new GridData(1808);
        data.widthHint = this.convertWidthInCharsToPixels(this.fWidth);
        data.heightHint = this.convertHeightInCharsToPixels(this.fHeight);
        Tree treeWidget = treeViewer.getTree();
        treeWidget.setLayoutData((Object)data);
        treeWidget.setFont(parent.getFont());
        if (this.fIsEmpty) {
            messageLabel.setEnabled(false);
            treeWidget.setEnabled(false);
            buttonComposite.setEnabled(false);
        }
        return composite;
    }

    protected CheckboxTreeViewer createTreeViewer(Composite parent) {
        TreePatternFilter filter = new TreePatternFilter();
        filter.setIncludeLeadingWildcard(true);
        this.fTree = new FilteredCheckboxTree(parent, 2050, filter, true);
        Tree tree = this.fTree.getViewer().getTree();
        tree.setHeaderVisible(true);
        String[] stringArray = this.fColumnNames;
        int n = this.fColumnNames.length;
        int n2 = 0;
        while (n2 < n) {
            String columnName = stringArray[n2];
            TreeColumn column = new TreeColumn(tree, 16384);
            column.setText(columnName);
            column.pack();
            ++n2;
        }
        this.fTree.getViewer().setContentProvider((IContentProvider)this.fContentProvider);
        this.fTree.getViewer().setLabelProvider(this.fLabelProvider);
        this.fTree.addCheckStateListener(new CheckStateListener());
        this.fTree.getViewer().setComparator(this.fComparator);
        if (this.fFilters != null) {
            int i = 0;
            while (i != this.fFilters.size()) {
                this.fTree.getViewer().addFilter(this.fFilters.get(i));
                ++i;
            }
        }
        this.fTree.getViewer().setInput(this.fInput);
        stringArray = tree.getColumns();
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            String column = stringArray[n2];
            column.pack();
            ++n2;
        }
        return (CheckboxTreeViewer)this.fTree.getViewer();
    }

    protected CheckboxTreeViewer getTreeViewer() {
        return (CheckboxTreeViewer)this.fTree.getViewer();
    }

    protected Composite createSelectionButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 131072);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setFont(composite.getFont());
        GridData data = new GridData(640);
        data.grabExcessHorizontalSpace = true;
        buttonComposite.setLayoutData((Object)data);
        Button checkSelectedButton = this.createButton(buttonComposite, 1024, Messages.TmfTimeFilterDialog_CHECK_SELECTED, false);
        Button checkSubtreeButton = this.createButton(buttonComposite, 1026, Messages.TmfTimeFilterDialog_CHECK_SUBTREE, false);
        Button checkAllButton = this.createButton(buttonComposite, 18, Messages.TmfTimeFilterDialog_CHECK_ALL, false);
        Button uncheckSelectedButton = this.createButton(buttonComposite, 1025, Messages.TmfTimeFilterDialog_UNCHECK_SELECTED, false);
        Button uncheckSubtreeButton = this.createButton(buttonComposite, 1027, Messages.TmfTimeFilterDialog_UNCHECK_SUBTREE, false);
        Button uncheckAllButton = this.createButton(buttonComposite, 19, Messages.TmfTimeFilterDialog_UNCHECK_ALL, false);
        layout.numColumns = 3;
        buttonComposite.setLayout((Layout)layout);
        checkSelectedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeSelection selection = (TreeSelection)TimeGraphFilterDialog.this.fTree.getViewer().getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    TimeGraphFilterDialog.this.checkElement(element);
                    ++n2;
                }
                TimeGraphFilterDialog.this.updateOKStatus();
            }
        });
        checkSubtreeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeSelection selection = (TreeSelection)TimeGraphFilterDialog.this.fTree.getViewer().getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    TimeGraphFilterDialog.this.checkElementAndSubtree(element);
                    ++n2;
                }
            }
        });
        checkAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] viewerElements = TimeGraphFilterDialog.this.fContentProvider.getElements(TimeGraphFilterDialog.this.fInput);
                int i = 0;
                while (i < viewerElements.length) {
                    TimeGraphFilterDialog.this.fTree.setSubtreeChecked(viewerElements[i], true);
                    ++i;
                }
                TimeGraphFilterDialog.this.updateOKStatus();
            }
        });
        uncheckSelectedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeSelection selection = (TreeSelection)TimeGraphFilterDialog.this.fTree.getViewer().getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    TimeGraphFilterDialog.this.uncheckElement(element);
                    ++n2;
                }
                TimeGraphFilterDialog.this.updateOKStatus();
            }
        });
        uncheckSubtreeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeSelection selection = (TreeSelection)TimeGraphFilterDialog.this.fTree.getViewer().getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    TimeGraphFilterDialog.this.uncheckElement(element);
                    ++n2;
                }
                TimeGraphFilterDialog.this.updateOKStatus();
            }
        });
        uncheckAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] viewerElements;
                Object[] objectArray = viewerElements = TimeGraphFilterDialog.this.fContentProvider.getElements(TimeGraphFilterDialog.this.fInput);
                int n = viewerElements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (TimeGraphFilterDialog.this.fTree.getViewer().testFindItem(element) != null) {
                        TimeGraphFilterDialog.this.uncheckElement(element);
                    }
                    ++n2;
                }
                TimeGraphFilterDialog.this.updateOKStatus();
            }
        });
        return buttonComposite;
    }

    private void checkElement(Object element) {
        this.fTree.setChecked(element, true);
        Object parent = this.fContentProvider.getParent(element);
        if (parent != null && !this.fTree.getChecked(parent)) {
            this.checkElement(parent);
        }
    }

    private void checkElementAndSubtree(Object element) {
        this.checkElement(element);
        Object[] objectArray = this.fContentProvider.getChildren(element);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            this.checkElementAndSubtree(child);
            ++n2;
        }
    }

    private void uncheckElement(Object element) {
        this.fTree.setChecked(element, false);
        Object[] objectArray = this.fContentProvider.getChildren(element);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            this.uncheckElement(child);
            ++n2;
        }
    }

    private boolean evaluateIfTreeEmpty(Object input) {
        Object[] elements = this.fContentProvider.getElements(input);
        if (elements.length > 0 && this.fFilters != null) {
            int i = 0;
            while (i < this.fFilters.size()) {
                ViewerFilter curr = this.fFilters.get(i);
                elements = curr.filter((Viewer)this.fTree.getViewer(), input, elements);
                ++i;
            }
        }
        return elements.length == 0;
    }

    private class CheckStateListener
    implements ICheckStateListener {
        CheckStateListener() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            try {
                try {
                    ITimeGraphEntry entry = (ITimeGraphEntry)event.getElement();
                    boolean checked = event.getChecked();
                    if (checked) {
                        TimeGraphFilterDialog.this.checkElement(entry);
                    } else {
                        TimeGraphFilterDialog.this.uncheckElement(entry);
                    }
                }
                catch (ClassCastException e) {
                    TimeGraphFilterDialog.this.updateOKStatus();
                    return;
                }
            }
            finally {
                TimeGraphFilterDialog.this.updateOKStatus();
            }
        }
    }
}

