/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.control.core.model;

public enum TraceEventType {
    TRACEPOINT("tracepoint"),
    SYSCALL("syscall"),
    PROBE("probe"),
    FUNCTION("function"),
    UNKNOWN("unknown");

    private final String fInName;

    private TraceEventType(String name) {
        this.fInName = name;
    }

    public String getInName() {
        return this.fInName;
    }

    public static TraceEventType valueOfString(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        TraceEventType[] traceEventTypeArray = TraceEventType.values();
        int n = traceEventTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TraceEventType teType = traceEventTypeArray[n2];
            if (teType.getInName().equalsIgnoreCase(name)) {
                return teType;
            }
            ++n2;
        }
        return UNKNOWN;
    }
}

