/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.operations;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rse.ui.view.IContextObject;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.PendingUpdateAdapter;

public class SystemDeferredTreeContentManager
extends DeferredTreeContentManager {
    private List _pendingQueries = new ArrayList();

    public SystemDeferredTreeContentManager(ITreeContentProvider provider, AbstractTreeViewer viewer) {
        super(provider, viewer);
    }

    protected IDeferredWorkbenchAdapter getAdapter(Object element) {
        if (element instanceof IContextObject) {
            element = ((IContextObject)element).getModelObject();
        }
        return super.getAdapter(element);
    }

    public Object[] getChildren(Object parent, final Viewer viewer) {
        final ISelection selection = viewer.getSelection();
        IDeferredWorkbenchAdapter element = this.getAdapter(parent);
        if (element == null) {
            return null;
        }
        PendingUpdateAdapter placeholder = new PendingUpdateAdapter(){

            protected void setRemoved(boolean removedValue) {
                super.setRemoved(removedValue);
                ISelection curSel = viewer.getSelection();
                if (SystemDeferredTreeContentManager.this.isSelectionContainedIn(curSel, selection)) {
                    viewer.setSelection(selection);
                }
            }
        };
        if (!this._pendingQueries.contains(parent)) {
            this.startFetchingDeferredChildren(parent, element, placeholder);
            this._pendingQueries.add(parent);
            return new Object[]{placeholder};
        }
        return null;
    }

    private boolean isSelectionContainedIn(ISelection sel, ISelection parent) {
        if (sel.isEmpty()) {
            return true;
        }
        if (sel.equals(parent)) {
            return false;
        }
        if (sel instanceof IStructuredSelection && parent instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)sel;
            List spar = ((IStructuredSelection)parent).toList();
            for (Object o : ssel) {
                if (spar.contains(o)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected void addChildren(Object parent, Object[] children, IProgressMonitor monitor) {
        super.addChildren(parent, children, monitor);
        this._pendingQueries.remove(parent);
    }
}

