/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.internal.ssh;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.remotetools.core.IRemoteCopyTools;
import org.eclipse.ptp.remotetools.core.IRemoteItem;
import org.eclipse.ptp.remotetools.core.messages.Messages;
import org.eclipse.ptp.remotetools.exception.CancelException;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;
import org.eclipse.ptp.remotetools.exception.RemoteOperationException;
import org.eclipse.ptp.remotetools.internal.common.Debug;
import org.eclipse.ptp.remotetools.internal.common.FileEnumeration;
import org.eclipse.ptp.remotetools.internal.common.FileRecursiveEnumeration;
import org.eclipse.ptp.remotetools.internal.ssh.ExecutionManager;
import org.eclipse.ptp.remotetools.internal.ssh.FileTools;
import org.eclipse.ptp.remotetools.internal.ssh.RemoteFileEnumeration;
import org.eclipse.ptp.remotetools.internal.ssh.RemoteFileRecursiveEnumeration;

public class CopyTools
implements IRemoteCopyTools {
    private FileTools remoteFileTools;

    public CopyTools(ExecutionManager manager) throws RemoteConnectionException {
        this.remoteFileTools = (FileTools)manager.getRemoteFileTools();
    }

    public void downloadFileToDir(String remotePath, File localDir) throws RemoteConnectionException, CancelException, RemoteOperationException {
        this.remoteFileTools.validateRemotePath(remotePath);
        File localFile = new File(localDir, this.remoteFileTools.suffixOfRemotePath(remotePath));
        if (!localDir.exists() && !localDir.mkdirs()) {
            throw new RemoteOperationException(NLS.bind((String)Messages.CopyTools_0, (Object)localDir.getAbsolutePath()));
        }
        this.doDownloadFileToFile(remotePath, localFile);
    }

    public void downloadFileToDir(String remotePath, String localPath) throws RemoteConnectionException, CancelException, RemoteOperationException {
        File localDir = new File(localPath);
        this.downloadFileToDir(remotePath, localDir);
    }

    public void downloadFileToFile(String remotePath, File localFile) throws RemoteConnectionException, CancelException, RemoteOperationException {
        this.remoteFileTools.validateRemotePath(remotePath);
        File localDir = localFile.getParentFile();
        if (!localDir.exists() && !localDir.mkdirs()) {
            throw new RemoteOperationException(NLS.bind((String)Messages.CopyTools_0, (Object)localDir.getAbsolutePath()));
        }
        this.doDownloadFileToFile(remotePath, localFile);
    }

    public void downloadFileToFile(String remotePath, String localPath) throws RemoteConnectionException, CancelException, RemoteOperationException {
        File localFile = new File(localPath);
        this.downloadFileToFile(remotePath, localFile);
    }

    public void uploadFileToDir(File localFile, String remotePath) throws RemoteConnectionException, CancelException, RemoteOperationException {
        this.remoteFileTools.validateRemotePath(remotePath);
        this.remoteFileTools.assureDirectory(remotePath, null);
        remotePath = this.remoteFileTools.concatenateRemotePath(remotePath, localFile.getName());
        this.doUploadFileToFile(localFile, remotePath);
    }

    public void uploadFileToDir(String localPath, String remotePath) throws RemoteConnectionException, CancelException, RemoteOperationException {
        File localFile = new File(localPath);
        this.uploadFileToDir(localFile, remotePath);
    }

    public void uploadFileToFile(File localFile, String remotePath) throws RemoteConnectionException, CancelException, RemoteOperationException {
        this.remoteFileTools.validateRemotePath(remotePath);
        this.remoteFileTools.assureDirectory(this.remoteFileTools.parentOfRemotePath(remotePath), null);
        this.doUploadFileToFile(localFile, remotePath);
    }

    public void uploadFileToFile(String localPath, String remotePath) throws RemoteConnectionException, CancelException, RemoteOperationException {
        File localFile = new File(localPath);
        this.uploadFileToFile(localFile, remotePath);
    }

    private void doDownloadFileToFile(String remotePath, File localFile) throws RemoteConnectionException, CancelException, RemoteOperationException {
        FileOutputStream sink = null;
        try {
            try {
                sink = new FileOutputStream(localFile);
                this.remoteFileTools.downloadIntoOutputStream(remotePath, sink, null);
            }
            catch (FileNotFoundException e) {
                throw new RemoteOperationException(NLS.bind((String)Messages.CopyTools_doDownloadFileToFile_CannotWriteFile, (Object)e.getMessage()), e);
            }
        }
        finally {
            try {
                if (sink != null) {
                    sink.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void doUploadFileToFile(File localFile, String remotePath) throws RemoteConnectionException, CancelException, RemoteOperationException {
        FileInputStream source = null;
        try {
            try {
                source = new FileInputStream(localFile);
                this.remoteFileTools.uploadFromInputStream(source, remotePath, null);
            }
            catch (FileNotFoundException e) {
                throw new RemoteOperationException(NLS.bind((String)Messages.CopyTools_doUploadFileFromFile_CannotReadFile, (Object)e.getMessage()), e);
            }
        }
        finally {
            try {
                if (source != null) {
                    source.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void downloadDirToDir(String remotePath, File localDir, boolean recursive) throws RemoteConnectionException, RemoteOperationException, CancelException {
        this.remoteFileTools.validateRemotePath(remotePath);
        remotePath = this.remoteFileTools.addTrailingSlash(remotePath);
        if (!localDir.exists() && !localDir.mkdirs()) {
            throw new RemoteOperationException(NLS.bind((String)Messages.CopyTools_0, (Object)localDir.getAbsolutePath()));
        }
        try {
            block5: {
                if (!recursive) break block5;
                enumeration = new RemoteFileRecursiveEnumeration(this.remoteFileTools, this.remoteFileTools.removeTrailingSlash(remotePath));
                ** GOTO lbl24
            }
            enumeration = new RemoteFileEnumeration(this.remoteFileTools, this.remoteFileTools.removeTrailingSlash(remotePath));
            if (true) ** GOTO lbl24
        }
        catch (IllegalArgumentException e) {
            throw new RemoteOperationException(e.getMessage());
        }
        do {
            remoteFilePath = ((IRemoteItem)enumeration.nextElement()).getPath();
            relativePath = remoteFilePath.substring(remotePath.length());
            localFile = new File(localDir, relativePath);
            if (this.remoteFileTools.hasDirectory(remoteFilePath, null)) {
                Debug.println("Create: " + remoteFilePath);
                if (localFile.exists() || localDir.mkdirs()) continue;
                throw new RemoteOperationException(NLS.bind((String)Messages.CopyTools_0, (Object)localFile.getAbsolutePath()));
            }
            Debug.println(String.valueOf(relativePath) + " -> " + remoteFilePath);
            this.doDownloadFileToFile(remoteFilePath, localFile);
lbl24:
            // 4 sources

        } while (enumeration.hasMoreElements());
    }

    public void downloadDirToDir(String remotePath, String localPath, boolean recursive) throws RemoteConnectionException, RemoteOperationException, CancelException {
        File localDir = new File(localPath);
        this.downloadDirToDir(remotePath, localDir, recursive);
    }

    /*
     * Unable to fully structure code
     */
    public void uploadDirToDir(File localDir, String remotePath, boolean recursive) throws RemoteConnectionException, RemoteOperationException, CancelException {
        this.remoteFileTools.validateRemotePath(remotePath);
        this.remoteFileTools.assureDirectory(remotePath, null);
        try {
            enumeration = recursive ? new FileRecursiveEnumeration(localDir) : new FileEnumeration(localDir);
        }
        catch (IOException e) {
            throw new RemoteOperationException(e.getMessage());
        }
        try {
            rootPath = localDir.getCanonicalPath();
            if (true) ** GOTO lbl28
        }
        catch (IOException e) {
            throw new RemoteOperationException(e);
        }
        do {
            file = enumeration.nextElement();
            try {
                relativePath = file.getCanonicalPath().substring(rootPath.length() + 1).replace('\\', '/');
            }
            catch (IOException e) {
                throw new RemoteOperationException(e);
            }
            remoteFilePath = this.remoteFileTools.concatenateRemotePath(remotePath, relativePath);
            if (file.isDirectory()) {
                Debug.println("Create: " + remoteFilePath);
                this.remoteFileTools.assureDirectory(remoteFilePath, null);
                this.remoteFileTools.uploadPermissions(file.getAbsoluteFile(), remoteFilePath);
                continue;
            }
            Debug.println(String.valueOf(relativePath) + " -> " + remoteFilePath);
            this.doUploadFileToFile(file, remoteFilePath);
lbl28:
            // 3 sources

        } while (enumeration.hasMoreElements());
    }

    public void uploadDirToDir(String localPath, String remotePath, boolean recursive) throws RemoteConnectionException, RemoteOperationException, CancelException {
        File localFile = new File(localPath);
        this.uploadDirToDir(localFile, remotePath, recursive);
    }
}

