/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.libhover.utils;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.linuxtools.cdt.libhover.FunctionInfo;
import org.eclipse.linuxtools.cdt.libhover.LibHoverInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BuildFunctionInfos {
    private Document document;
    private LibHoverInfo hoverInfo = new LibHoverInfo();

    public BuildFunctionInfos(Document document) {
        this.document = document;
    }

    public Document getDocument() {
        return this.document;
    }

    private FunctionInfo getFunctionInfoFromNode(String name, Node functionNode, Document document) {
        FunctionInfo f = new FunctionInfo(name);
        NamedNodeMap functionNodeMap = functionNode.getAttributes();
        Node functionNodeReturntypeNode = functionNodeMap.item(0);
        String functionNodeRtName = functionNodeReturntypeNode.getNodeName();
        if (functionNodeRtName.equals("returntype")) {
            String functionNodeRtValue = functionNodeReturntypeNode.getNodeValue();
            f.setReturnType(functionNodeRtValue);
        }
        NodeList kids = functionNode.getChildNodes();
        int fnk = 0;
        while (fnk < kids.getLength()) {
            Node kid = kids.item(fnk);
            String kidName = kid.getNodeName();
            if (kidName.equals("prototype")) {
                String prototype = null;
                NodeList parms = kid.getChildNodes();
                int fnp = 0;
                while (fnp < parms.getLength()) {
                    Node parm = parms.item(fnp);
                    String parmName = parm.getNodeName();
                    if (parmName.equals("parameter")) {
                        NamedNodeMap parmMap = parm.getAttributes();
                        Node parmNode = parmMap.item(0);
                        String parameter = parmNode.getNodeValue();
                        prototype = prototype == null ? parameter : String.valueOf(prototype) + ", " + parameter;
                    }
                    ++fnp;
                }
                f.setPrototype(prototype);
            } else if (kidName.equals("headers")) {
                NodeList headers = kid.getChildNodes();
                int fnh = 0;
                while (fnh < headers.getLength()) {
                    Node header = headers.item(fnh);
                    String headerName = header.getNodeName();
                    if (headerName.equals("header")) {
                        NamedNodeMap headerMap = header.getAttributes();
                        Node headerNode = headerMap.item(0);
                        f.addHeader(headerNode.getNodeValue());
                    }
                    ++fnh;
                }
            } else if (kidName.equals("groupsynopsis")) {
                NodeList synopsisNode;
                Element elem2;
                NamedNodeMap attr = kid.getAttributes();
                Node idnode = attr.getNamedItem("id");
                String id = idnode.getNodeValue();
                if (id != null && (elem2 = document.getElementById(id)) != null && (synopsisNode = elem2.getElementsByTagName("synopsis")) != null && synopsisNode.getLength() > 0) {
                    Node synopsis = synopsisNode.item(0);
                    Node textNode = synopsis.getLastChild();
                    f.setDescription(textNode.getNodeValue());
                }
            } else if (kidName.equals("synopsis")) {
                Node textNode = kid.getLastChild();
                f.setDescription(textNode.getNodeValue());
            }
            ++fnk;
        }
        return f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void buildCPPInfo(String fileName) {
        Document document = this.getDocument();
        NodeList nl = document.getElementsByTagName("construct");
        int i2 = 0;
        while (i2 < nl.getLength()) {
            Node n = nl.item(i2);
            NamedNodeMap m = n.getAttributes();
            Node id = m.getNamedItem("id");
            if (id != null && id.getNodeValue().startsWith("function-")) {
                String name = id.getNodeValue().substring(9);
                NodeList nl2 = n.getChildNodes();
                int j = 0;
                while (j < nl2.getLength()) {
                    Node n2 = nl2.item(j);
                    if (n2.getNodeName().equals("function")) {
                        FunctionInfo f = this.getFunctionInfoFromNode(name, n2, document);
                        this.hoverInfo.functions.put(name, f);
                    }
                    ++j;
                }
            }
            ++i2;
        }
        try {
            Throwable i2 = null;
            Object var5_8 = null;
            try {
                FileOutputStream f = new FileOutputStream(fileName);
                try {
                    try (ObjectOutputStream out = new ObjectOutputStream(f);){
                        out.writeObject(this.hoverInfo);
                    }
                    if (f == null) return;
                }
                catch (Throwable throwable) {
                    if (i2 == null) {
                        i2 = throwable;
                    } else if (i2 != throwable) {
                        i2.addSuppressed(throwable);
                    }
                    if (f == null) throw i2;
                    f.close();
                    throw i2;
                }
                f.close();
                return;
            }
            catch (Throwable throwable) {
                if (i2 == null) {
                    i2 = throwable;
                    throw i2;
                } else {
                    if (i2 == throwable) throw i2;
                    i2.addSuppressed(throwable);
                }
                throw i2;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            URI acDoc = new URI(args[0]);
            IPath p = URIUtil.toPath((URI)acDoc);
            InputStream docStream = null;
            if (p == null) {
                URL url = acDoc.toURL();
                docStream = url.openStream();
            } else {
                docStream = new FileInputStream(p.toFile());
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(docStream);
            if (doc != null) {
                BuildFunctionInfos d = new BuildFunctionInfos(doc);
                d.buildCPPInfo(args[1]);
            }
            System.out.println("Built " + args[1] + " from " + args[0]);
        }
        catch (IOException | URISyntaxException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
        }
    }
}

