/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.ui;

import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceLookupParticipant;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.sourcelookup.ISourceLookupResult;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.linuxtools.internal.valgrind.core.ValgrindError;
import org.eclipse.linuxtools.internal.valgrind.core.ValgrindStackFrame;
import org.eclipse.linuxtools.profiling.ui.ProfileUIUtils;
import org.eclipse.linuxtools.valgrind.core.IValgrindMessage;
import org.eclipse.linuxtools.valgrind.ui.CollapseAction;
import org.eclipse.linuxtools.valgrind.ui.ExpandAction;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CoreMessagesViewer {
    static ImageRegistry imageRegistry = new ImageRegistry();
    private static final String VALGRIND_ERROR = "Valgrind_Error";
    private static final String VALGRIND_INFO = "Valgrind_Info";
    private static final String VALGRIND_ERROR_IMAGE = "icons/valgrind-error.png";
    public static final String VALGRIND_INFO_IMAGE = "icons/valgrind-info.png";
    private IDoubleClickListener doubleClickListener;
    private ITreeContentProvider contentProvider;
    private TreeViewer viewer;

    public CoreMessagesViewer(Composite parent, int style) {
        ImageDescriptor d;
        this.viewer = new TreeViewer(parent, 0x304 | style);
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        if (imageRegistry.getDescriptor(VALGRIND_ERROR) == null && (d = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.linuxtools.valgrind.ui", (String)VALGRIND_ERROR_IMAGE)) != null) {
            imageRegistry.put(VALGRIND_ERROR, d);
        }
        if (imageRegistry.getDescriptor(VALGRIND_INFO) == null && (d = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.linuxtools.valgrind.ui", (String)VALGRIND_INFO_IMAGE)) != null) {
            imageRegistry.put(VALGRIND_INFO, d);
        }
        this.contentProvider = new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof Object[]) {
                    return (Object[])parentElement;
                }
                return ((IValgrindMessage)parentElement).getChildren();
            }

            public Object getParent(Object element) {
                return ((IValgrindMessage)element).getParent();
            }

            public boolean hasChildren(Object element) {
                return this.getChildren(element).length > 0;
            }

            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IValgrindMessage)element).getText();
            }

            public Image getImage(Object element) {
                Image image = element instanceof ValgrindStackFrame ? DebugUITools.getImage((String)"IMG_OBJS_STACKFRAME") : (element instanceof ValgrindError ? imageRegistry.get(CoreMessagesViewer.VALGRIND_ERROR) : imageRegistry.get(CoreMessagesViewer.VALGRIND_INFO));
                return image;
            }
        });
        this.doubleClickListener = new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object element = ((TreeSelection)event.getSelection()).getFirstElement();
                if (element instanceof ValgrindStackFrame) {
                    ILaunchConfiguration config;
                    AbstractSourceLookupDirector director;
                    ISourceLookupParticipant[] participants;
                    ValgrindStackFrame frame = (ValgrindStackFrame)element;
                    ILaunch launch = frame.getLaunch();
                    ISourceLocator locator = launch.getSourceLocator();
                    if (locator instanceof AbstractSourceLookupDirector && (participants = (director = (AbstractSourceLookupDirector)locator).getParticipants()).length == 0 && (config = launch.getLaunchConfiguration()) != null) {
                        try {
                            IPersistableSourceLocator sourceLocator;
                            String id = config.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, null);
                            if (id == null) {
                                sourceLocator = CDebugUIPlugin.createDefaultSourceLocator();
                                sourceLocator.initializeDefaults(config);
                            } else {
                                sourceLocator = DebugPlugin.getDefault().getLaunchManager().newSourceLocator(id);
                                String memento = config.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, null);
                                if (memento == null) {
                                    sourceLocator.initializeDefaults(config);
                                } else {
                                    sourceLocator.initializeFromMemento(memento);
                                }
                            }
                            locator = sourceLocator;
                            launch.setSourceLocator((ISourceLocator)sourceLocator);
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    }
                    ISourceLookupResult result = DebugUITools.lookupSource((Object)frame.getFile(), (ISourceLocator)locator);
                    try {
                        ProfileUIUtils.openEditorAndSelect((ISourceLookupResult)result, (int)frame.getLine());
                    }
                    catch (BadLocationException | PartInitException e) {
                        e.printStackTrace();
                    }
                } else if (CoreMessagesViewer.this.viewer.getExpandedState(element)) {
                    CoreMessagesViewer.this.viewer.collapseToLevel(element, -1);
                } else {
                    CoreMessagesViewer.this.viewer.expandToLevel(element, 1);
                }
            }
        };
        this.viewer.addDoubleClickListener(this.doubleClickListener);
        final ExpandAction expandAction = new ExpandAction(this.viewer);
        final CollapseAction collapseAction = new CollapseAction(this.viewer);
        MenuManager manager = new MenuManager();
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ITreeSelection selection = (ITreeSelection)CoreMessagesViewer.this.viewer.getSelection();
                Object element = selection.getFirstElement();
                if (CoreMessagesViewer.this.contentProvider.hasChildren(element)) {
                    manager.add((IAction)expandAction);
                    manager.add((IAction)collapseAction);
                }
            }
        });
        manager.setRemoveAllWhenShown(true);
        Menu contextMenu = manager.createContextMenu((Control)this.viewer.getTree());
        this.viewer.getControl().setMenu(contextMenu);
    }

    public IDoubleClickListener getDoubleClickListener() {
        return this.doubleClickListener;
    }

    public TreeViewer getTreeViewer() {
        return this.viewer;
    }
}

