/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.search;

import java.net.URI;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IPositionConverter;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.viewsupport.CElementLabels;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.internal.rdt.core.model.Scope;
import org.eclipse.ptp.internal.rdt.core.search.RemoteLineSearchElement;
import org.eclipse.ptp.internal.rdt.core.search.RemoteSearchMatch;
import org.eclipse.ptp.internal.rdt.core.search.RemoteSearchQuery;
import org.eclipse.ptp.internal.rdt.core.search.RemoteSearchTextSelectionQuery;
import org.eclipse.ptp.internal.rdt.core.subsystems.ICIndexSubsystem;
import org.eclipse.ptp.internal.rdt.ui.search.RemoteLineSearchElementAdapter;
import org.eclipse.ptp.internal.rdt.ui.search.RemoteSearchMatchAdapter;
import org.eclipse.ptp.internal.rdt.ui.search.RemoteSearchResult;
import org.eclipse.ptp.rdt.ui.messages.Messages;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class RemoteSearchQueryAdapter
implements ISearchQuery {
    protected ICIndexSubsystem fSubsystem;
    protected RemoteSearchQuery fQuery;
    protected RemoteSearchResult fResult;
    protected Scope fScope;
    private static final MatchesComparator MATCHES_COMPARATOR = new MatchesComparator();
    protected static final long LABEL_FLAGS = 34629665L;

    protected RemoteSearchQueryAdapter() {
        throw new IllegalStateException();
    }

    public RemoteSearchQueryAdapter(ICIndexSubsystem subsystem, Scope scope, RemoteSearchQuery query) {
        this.fSubsystem = subsystem;
        this.fScope = scope;
        if (query == null) {
            throw new IllegalArgumentException("Query must not be null.");
        }
        this.fQuery = query;
        this.fResult = new RemoteSearchResult(this);
    }

    protected String labelForBinding(String defaultLabel) {
        if (this.fQuery == null) {
            return null;
        }
        ICElement elem = this.fQuery.getcElement();
        if (elem != null) {
            return CElementLabels.getElementLabel((ICElement)elem, (long)34629665L);
        }
        return defaultLabel;
    }

    public boolean canRerun() {
        return this.fQuery != null ? this.fQuery.canRerun() : true;
    }

    public boolean canRunInBackground() {
        return this.fQuery != null ? this.fQuery.canRunInBackground() : true;
    }

    public abstract String getResultLabel(int var1);

    public String getResultLabel(String pattern, int matchCount) {
        return this.getResultLabel(pattern, null, matchCount);
    }

    public String getResultLabel(String pattern, String scope, int matchCount) {
        String label;
        if (this.fQuery == null) {
            return Messages.getString("RemoteSearchPatternQueryAdapter_0");
        }
        int kindFlags = this.fQuery.getFlags() & 7;
        switch (kindFlags) {
            case 4: {
                label = NLS.bind((String)CSearchMessages.PDOMSearchQuery_refs_result_label, (Object)pattern);
                break;
            }
            case 1: {
                label = NLS.bind((String)CSearchMessages.PDOMSearchQuery_decls_result_label, (Object)pattern);
                break;
            }
            case 2: {
                label = NLS.bind((String)CSearchMessages.PDOMSearchQuery_defs_result_label, (Object)pattern);
                break;
            }
            case 3: {
                label = NLS.bind((String)CSearchMessages.PDOMSearchQuery_decldefs_result_label, (Object)pattern);
                break;
            }
            default: {
                label = NLS.bind((String)CSearchMessages.PDOMSearchQuery_occurrences_result_label, (Object)pattern);
            }
        }
        if (scope != null) {
            label = NLS.bind((String)CSearchMessages.PDOMSearchPatternQuery_PatternQuery_labelPatternInScope, (Object)label, (Object)scope);
        }
        String countLabel = org.eclipse.cdt.internal.ui.util.Messages.format((String)CSearchMessages.CSearchResultCollector_matches, (Object[])new Object[]{new Integer(matchCount)});
        return String.valueOf(label) + " " + countLabel;
    }

    public String getLabel() {
        if (this.fQuery == null) {
            return null;
        }
        String type = (this.fQuery.getFlags() & 4) != 0 ? CSearchMessages.PDOMSearchQuery_refs_label : ((this.fQuery.getFlags() & 1) != 0 ? CSearchMessages.PDOMSearchQuery_decls_label : CSearchMessages.PDOMSearchQuery_defs_label);
        return type;
    }

    public ISearchResult getSearchResult() {
        return this.fResult;
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        this.fSubsystem.checkAllProjects(monitor);
        RemoteSearchResult result = (RemoteSearchResult)this.getSearchResult();
        result.removeAll();
        if (this.fQuery != null) {
            this.fQuery.cleanupResult();
        }
        this.fQuery = this.fSubsystem.runQuery2(this.fScope, this.fQuery, monitor);
        if (this.fQuery != null) {
            this.postProcessQuery();
            return new Status(0, "org.eclipse.ptp.rdt.ui", "");
        }
        return new Status(0, "org.eclipse.ptp.rdt.ui", "");
    }

    public RemoteSearchQuery getQuery() {
        return this.fQuery;
    }

    public ICProject[] getProjects() {
        return new ICProject[0];
    }

    private void postProcessQuery() {
        if (this.fQuery == null) {
            return;
        }
        List remoteSearchMatches = this.fQuery.getMatches();
        Map remoteLineSearchElementMatches = this.fQuery.getRemoteLineSearchElementMatchs();
        Map localLineSearchElementMatches = this.fQuery.getLocalLineSearchElementMatches();
        Map localLineSearchElements = this.fQuery.getLocalLineSearchElements();
        Map remoteLineSearchElements = this.fQuery.getRemoteLineSearchElements();
        try {
            if (remoteSearchMatches.size() > 0) {
                int i = 0;
                Match[] matches = new Match[remoteSearchMatches.size()];
                for (RemoteSearchMatch match : remoteSearchMatches) {
                    matches[i] = new RemoteSearchMatchAdapter(match);
                    ++i;
                }
                Arrays.sort(matches, MATCHES_COMPARATOR);
                this.fResult.addMatches(matches);
            }
            if (remoteLineSearchElementMatches.size() > 0) {
                this.collectNames(remoteLineSearchElementMatches, remoteLineSearchElements);
            }
            if (localLineSearchElementMatches.size() > 0) {
                this.createLocalMatches(localLineSearchElementMatches, localLineSearchElements);
            }
        }
        catch (CoreException e) {
            CUIPlugin.log((Throwable)e);
        }
    }

    private void collectNames(Map<IIndexFile, Set<RemoteLineSearchElement.RemoteLineSearchElementMatch>> remoteLineSearchElementMatches, Map<IIndexFile, RemoteLineSearchElement[]> remoteLineSearchElements) throws CoreException {
        IEditorPart[] dirtyEditors = CUIPlugin.getDirtyEditors();
        HashMap<IPath, ITextEditor> pathsDirtyEditors = new HashMap<IPath, ITextEditor>();
        IEditorPart[] iEditorPartArray = dirtyEditors;
        int n = dirtyEditors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorPart editorPart = iEditorPartArray[n2];
            if (editorPart instanceof ITextEditor) {
                ITextEditor textEditor = (ITextEditor)editorPart;
                IEditorInput editorInput = editorPart.getEditorInput();
                if (editorInput instanceof IPathEditorInput) {
                    IPathEditorInput pathEditorInput = (IPathEditorInput)editorInput;
                    pathsDirtyEditors.put(pathEditorInput.getPath(), textEditor);
                }
            }
            ++n2;
        }
        for (Map.Entry<IIndexFile, Set<RemoteLineSearchElement.RemoteLineSearchElementMatch>> entry : remoteLineSearchElementMatches.entrySet()) {
            IIndexFile file = entry.getKey();
            Set<RemoteLineSearchElement.RemoteLineSearchElementMatch> matches = entry.getValue();
            RemoteLineSearchElement[] lineElements = new RemoteLineSearchElement[]{};
            IPath absolutePath = IndexLocationFactory.getAbsolutePath((IIndexFileLocation)file.getLocation());
            if (pathsDirtyEditors.containsKey(absolutePath)) {
                matches = this.convertMatchesPositions(file, matches);
                ITextEditor textEditor = (ITextEditor)pathsDirtyEditors.get(absolutePath);
                IEditorInput input = textEditor.getEditorInput();
                IDocument document = textEditor.getDocumentProvider().getDocument((Object)input);
                RemoteLineSearchElement.RemoteLineSearchElementMatch[] matchesArray = matches.toArray(new RemoteLineSearchElement.RemoteLineSearchElementMatch[matches.size()]);
                lineElements = RemoteLineSearchElementAdapter.createElements(file.getLocation(), matchesArray, document);
            } else {
                lineElements = remoteLineSearchElements.get(file);
            }
            if (lineElements == null) continue;
            RemoteLineSearchElement[] remoteLineSearchElementArray = lineElements;
            int n3 = lineElements.length;
            int n4 = 0;
            while (n4 < n3) {
                RemoteLineSearchElement searchElement = remoteLineSearchElementArray[n4];
                RemoteLineSearchElement.RemoteLineSearchElementMatch[] remoteLineSearchElementMatchArray = searchElement.getMatches();
                int n5 = remoteLineSearchElementMatchArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    RemoteLineSearchElement.RemoteLineSearchElementMatch lineMatch = remoteLineSearchElementMatchArray[n6];
                    int offset = lineMatch.getOffset();
                    int length = lineMatch.getLength();
                    RemoteSearchMatchAdapter match = new RemoteSearchMatchAdapter(searchElement, offset, length);
                    if (lineMatch.isPolymorphicCall()) {
                        match.setIsPolymorphicCall();
                    }
                    this.fResult.addMatch(match);
                    ++n6;
                }
                ++n4;
            }
        }
    }

    private Set<RemoteLineSearchElement.RemoteLineSearchElementMatch> convertMatchesPositions(IIndexFile file, Set<RemoteLineSearchElement.RemoteLineSearchElementMatch> matches) throws CoreException {
        IPath path = IndexLocationFactory.getPath((IIndexFileLocation)file.getLocation());
        long timestamp = file.getTimestamp();
        IPositionConverter converter = CCorePlugin.getPositionTrackerManager().findPositionConverter(path, timestamp);
        if (converter != null) {
            HashSet<RemoteLineSearchElement.RemoteLineSearchElementMatch> convertedMatches = new HashSet<RemoteLineSearchElement.RemoteLineSearchElementMatch>();
            for (RemoteLineSearchElement.RemoteLineSearchElementMatch match : matches) {
                Region region = new Region(match.getOffset(), match.getLength());
                region = converter.historicToActual((IRegion)region);
                int offset = region.getOffset();
                int length = region.getLength();
                boolean isPolymorphicCall = match.isPolymorphicCall();
                ICElement enclosingElement = match.getEnclosingElement();
                boolean isWriteAccess = match.isWriteAccess();
                convertedMatches.add(new RemoteLineSearchElement.RemoteLineSearchElementMatch(offset, length, isPolymorphicCall, enclosingElement, isWriteAccess));
            }
            matches = convertedMatches;
        }
        return matches;
    }

    protected void createLocalMatches(Map<IIndexFileLocation, Set<RemoteLineSearchElement.RemoteLineSearchElementMatch>> localLineSearchElementMatches, Map<IIndexFileLocation, RemoteLineSearchElement[]> localLineSearchElements) throws CoreException {
        if (localLineSearchElementMatches.isEmpty()) {
            return;
        }
        if (this.fQuery instanceof RemoteSearchTextSelectionQuery) {
            String fullPath = ((RemoteSearchTextSelectionQuery)this.fQuery).getTuFullPath();
            ITextEditor dirtyTextEditor = null;
            if (fullPath != null) {
                IEditorPart[] iEditorPartArray = CUIPlugin.getDirtyEditors();
                int n = iEditorPartArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorPart editorPart = iEditorPartArray[n2];
                    if (editorPart instanceof ITextEditor) {
                        IPathEditorInput pathEditorInput;
                        IPath path;
                        ITextEditor textEditor = (ITextEditor)editorPart;
                        IEditorInput editorInput = editorPart.getEditorInput();
                        if (editorInput instanceof IPathEditorInput && fullPath.equals((path = (pathEditorInput = (IPathEditorInput)editorInput).getPath()).toOSString())) {
                            dirtyTextEditor = textEditor;
                            break;
                        }
                    }
                    ++n2;
                }
            }
            for (Map.Entry<IIndexFileLocation, Set<RemoteLineSearchElement.RemoteLineSearchElementMatch>> entry : localLineSearchElementMatches.entrySet()) {
                RemoteLineSearchElement[] lineElements;
                IIndexFileLocation fileloc = entry.getKey();
                Set<RemoteLineSearchElement.RemoteLineSearchElementMatch> matches = entry.getValue();
                RemoteLineSearchElement.RemoteLineSearchElementMatch[] matchesArray = matches.toArray(new RemoteLineSearchElement.RemoteLineSearchElementMatch[matches.size()]);
                if (dirtyTextEditor != null) {
                    IEditorInput input = dirtyTextEditor.getEditorInput();
                    IDocument document = dirtyTextEditor.getDocumentProvider().getDocument((Object)input);
                    lineElements = RemoteLineSearchElementAdapter.createElements(fileloc, matchesArray, document);
                } else {
                    lineElements = localLineSearchElements.get(fileloc);
                }
                if (lineElements == null) continue;
                RemoteLineSearchElement[] remoteLineSearchElementArray = lineElements;
                int n = lineElements.length;
                int n3 = 0;
                while (n3 < n) {
                    RemoteLineSearchElement searchElement = remoteLineSearchElementArray[n3];
                    RemoteLineSearchElement.RemoteLineSearchElementMatch[] remoteLineSearchElementMatchArray = searchElement.getMatches();
                    int n4 = remoteLineSearchElementMatchArray.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        RemoteLineSearchElement.RemoteLineSearchElementMatch lineMatch = remoteLineSearchElementMatchArray[n5];
                        int offset = lineMatch.getOffset();
                        int length = lineMatch.getLength();
                        RemoteSearchMatchAdapter match = new RemoteSearchMatchAdapter(searchElement, offset, length);
                        this.fResult.addMatch(match);
                        ++n5;
                    }
                    ++n3;
                }
            }
        }
    }

    private static final class MatchesComparator
    implements Comparator<Match> {
        private MatchesComparator() {
        }

        @Override
        public int compare(Match m1, Match m2) {
            int diff = 0;
            if (m1 instanceof RemoteSearchMatchAdapter && m2 instanceof RemoteSearchMatchAdapter) {
                RemoteSearchMatchAdapter rm1 = (RemoteSearchMatchAdapter)m1;
                RemoteSearchMatchAdapter rm2 = (RemoteSearchMatchAdapter)m2;
                IIndexFileLocation rm1_loc = rm1.getLocation();
                IIndexFileLocation rm2_loc = rm2.getLocation();
                if (rm1_loc != null && rm2_loc != null) {
                    URI rm1_uri = rm1_loc.getURI();
                    URI rm2_uri = rm2_loc.getURI();
                    if (rm1_uri != null && rm2_uri != null) {
                        diff = rm1_uri.compareTo(rm2_uri);
                    }
                }
            }
            if (diff == 0) {
                diff = m1.getOffset() - m2.getOffset();
            }
            if (diff == 0) {
                diff = m2.getLength() - m1.getLength();
            }
            return diff;
        }
    }
}

