/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.util;

import java.io.StringReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICFolderDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.internal.ui.wizards.settingswizards.ISettingsProcessor;
import org.eclipse.cdt.internal.ui.wizards.settingswizards.IncludePathsSettingsProcessor;
import org.eclipse.cdt.internal.ui.wizards.settingswizards.MacroSettingsProcessor;
import org.eclipse.cdt.internal.ui.wizards.settingswizards.SettingsImportExportException;
import org.eclipse.cdt.internal.ui.wizards.settingswizards.XMLUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ImportRemotePathSymbolsHandler {
    public static final List<ISettingsProcessor> processors = Arrays.asList(new IncludePathsSettingsProcessor(), new MacroSettingsProcessor());
    private static ErrorHandler ABORTING_ERROR_HANDER = new ErrorHandler(){

        @Override
        public void error(SAXParseException e) throws SAXException {
            throw e;
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            throw e;
        }
    };

    public static void importProjectSettings(String projectSetting, IProject project) {
        if (projectSetting != null && projectSetting.length() > 0) {
            try {
                ICConfigurationDescription config = ImportRemotePathSymbolsHandler.getActiveProjectConfig(project);
                ICProjectDescription writableDescription = CoreModel.getDefault().getProjectDescription(project, true);
                ICConfigurationDescription writableConfig = writableDescription.getConfigurationById(config.getId());
                ICFolderDescription writableProjectRoot = writableConfig.getRootFolderDescription();
                HashMap<String, ISettingsProcessor> importers = new HashMap<String, ISettingsProcessor>();
                for (ISettingsProcessor processor : processors) {
                    importers.put(processor.getSectionName(), processor);
                }
                Document document = ImportRemotePathSymbolsHandler.parse(projectSetting);
                Element root = document.getDocumentElement();
                List sections = XMLUtils.extractChildElements((Element)root, (String)"section");
                for (Element section : sections) {
                    ISettingsProcessor importer;
                    String sectionName = section.getAttribute("name");
                    if (sectionName == null || (importer = (ISettingsProcessor)importers.get(sectionName)) == null) continue;
                    importer.readSectionXML(writableProjectRoot, section);
                }
                CoreModel.getDefault().setProjectDescription(project, writableDescription);
            }
            catch (SettingsImportExportException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    private static ICConfigurationDescription getActiveProjectConfig(IProject prj) {
        ICConfigurationDescription[] cfgDescs = null;
        if (prj == null) {
            return null;
        }
        if (cfgDescs == null) {
            ICProjectDescription pDesc = CoreModel.getDefault().getProjectDescription(prj);
            ICConfigurationDescription[] iCConfigurationDescriptionArray = cfgDescs = pDesc == null ? null : pDesc.getConfigurations();
            if (cfgDescs == null || cfgDescs.length == 0) {
                return null;
            }
        }
        int i = 0;
        while (i < cfgDescs.length) {
            if (cfgDescs[i].isActive()) {
                return cfgDescs[i];
            }
            ++i;
        }
        return null;
    }

    private static Document parse(String inputXMLString) throws SettingsImportExportException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        factory.setIgnoringComments(true);
        try {
            DocumentBuilder parser = factory.newDocumentBuilder();
            parser.setErrorHandler(ABORTING_ERROR_HANDER);
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(inputXMLString));
            Document doc = parser.parse(is);
            return doc;
        }
        catch (Exception e) {
            throw new SettingsImportExportException((Throwable)e);
        }
    }
}

