/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.control.ui.views.handlers;

import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.linuxtools.internal.lttng2.control.core.model.LogLevelType;
import org.eclipse.linuxtools.internal.lttng2.control.core.model.TraceLogLevel;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.dialogs.IEnableEventsDialog;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.dialogs.TraceControlDialogFactory;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.handlers.BaseControlViewHandler;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.handlers.CommandParameter;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.model.ITraceControlComponent;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.model.impl.TargetNodeComponent;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.model.impl.TraceDomainComponent;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.model.impl.TraceProviderGroup;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class BaseEnableEventHandler
extends BaseControlViewHandler {
    protected CommandParameter fParam = null;

    public abstract void enableEvents(CommandParameter var1, List<String> var2, boolean var3, String var4, IProgressMonitor var5) throws ExecutionException;

    public abstract void enableSyscalls(CommandParameter var1, IProgressMonitor var2) throws ExecutionException;

    public abstract void enableProbe(CommandParameter var1, String var2, boolean var3, String var4, IProgressMonitor var5) throws ExecutionException;

    public abstract void enableLogLevel(CommandParameter var1, String var2, LogLevelType var3, TraceLogLevel var4, String var5, IProgressMonitor var6) throws ExecutionException;

    public abstract TraceDomainComponent getDomain(CommandParameter var1);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        this.fLock.lock();
        try {
            final CommandParameter param = this.fParam.clone();
            TargetNodeComponent node = param.getSession().getTargetNode();
            List<ITraceControlComponent> providers = node.getChildren(TraceProviderGroup.class);
            final IEnableEventsDialog dialog = TraceControlDialogFactory.getInstance().getEnableEventsDialog();
            dialog.setTraceProviderGroup((TraceProviderGroup)providers.get(0));
            dialog.setTraceDomainComponent(this.getDomain(param));
            if (dialog.open() != 0) {
                return null;
            }
            Job job = new Job(Messages.TraceControl_ChangeEventStateJob){

                protected IStatus run(IProgressMonitor monitor) {
                    ExecutionException error = null;
                    try {
                        List<String> eventNames;
                        String filter = dialog.getFilterExpression();
                        if (dialog.isTracepoints()) {
                            if (dialog.isAllTracePoints()) {
                                BaseEnableEventHandler.this.enableEvents(param, null, dialog.isKernel(), filter, monitor);
                            } else {
                                eventNames = dialog.getEventNames();
                                if (!eventNames.isEmpty()) {
                                    BaseEnableEventHandler.this.enableEvents(param, eventNames, dialog.isKernel(), filter, monitor);
                                }
                            }
                        }
                        if (dialog.isAllSysCalls()) {
                            BaseEnableEventHandler.this.enableSyscalls(param, monitor);
                        }
                        if (dialog.isDynamicProbe() && dialog.getProbeEventName() != null && dialog.getProbeName() != null) {
                            BaseEnableEventHandler.this.enableProbe(param, dialog.getProbeEventName(), false, dialog.getProbeName(), monitor);
                        }
                        if (dialog.isDynamicFunctionProbe() && dialog.getFunctionEventName() != null && dialog.getFunction() != null) {
                            BaseEnableEventHandler.this.enableProbe(param, dialog.getFunctionEventName(), true, dialog.getFunction(), monitor);
                        }
                        if (dialog.isWildcard()) {
                            eventNames = dialog.getEventNames();
                            eventNames.add(dialog.getWildcard());
                            if (!eventNames.isEmpty()) {
                                BaseEnableEventHandler.this.enableEvents(param, eventNames, dialog.isKernel(), filter, monitor);
                            }
                        }
                        if (dialog.isLogLevel()) {
                            BaseEnableEventHandler.this.enableLogLevel(param, dialog.getLogLevelEventName(), dialog.getLogLevelType(), dialog.getLogLevel(), filter, monitor);
                        }
                    }
                    catch (ExecutionException e) {
                        error = e;
                    }
                    BaseEnableEventHandler.this.refresh(param);
                    if (error != null) {
                        return new Status(4, "org.eclipse.linuxtools.lttng2.control.ui", Messages.TraceControl_ChangeEventStateFailure, (Throwable)error);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }
        finally {
            this.fLock.unlock();
        }
        return null;
    }
}

