/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.control.ui.views.remote;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.preferences.ControlPreferences;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.remote.CommandResult;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.remote.ICommandResult;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.remote.ICommandShell;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.remote.InputReader;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteProcess;
import org.eclipse.remote.core.IRemoteProcessBuilder;

public class CommandShell
implements ICommandShell {
    private static final String BEGIN_TAG = "org.eclipse.linuxtools-BEGIN-TAG:";
    private static final String END_TAG = "org.eclipse.linuxtools-END-TAG:";
    private static final String RSE_ADAPTER_ID = "org.eclipse.ptp.remote.RSERemoteServices";
    private static final String SHELL_ECHO_CMD = "echo ";
    private static final char CMD_SEPARATOR = ';';
    private static final String CMD_RESULT_VAR = " $?";
    private IRemoteConnection fConnection = null;
    private final ExecutorService fExecutor = Executors.newFixedThreadPool(1);
    private int fBackedByShell;

    public CommandShell(IRemoteConnection connection) {
        this.fConnection = connection;
    }

    @Override
    public void connect() throws ExecutionException {
    }

    @Override
    public void disconnect() {
        this.fExecutor.shutdown();
    }

    @Override
    public ICommandResult executeCommand(final List<String> command, final IProgressMonitor monitor) throws ExecutionException {
        if (this.fConnection.isOpen()) {
            FutureTask<CommandResult> future = new FutureTask<CommandResult>(new Callable<CommandResult>(){

                @Override
                public CommandResult call() throws IOException, InterruptedException {
                    if (monitor == null || !monitor.isCanceled()) {
                        boolean wrapCommand = CommandShell.RSE_ADAPTER_ID.equals(CommandShell.this.fConnection.getRemoteServices().getId()) && CommandShell.this.isBackedByShell();
                        IRemoteProcess process = CommandShell.this.startRemoteProcess(wrapCommand, command);
                        InputReader stdout = new InputReader(process.getInputStream());
                        InputReader stderr = new InputReader(process.getErrorStream());
                        try {
                            stdout.waitFor(monitor);
                            stderr.waitFor(monitor);
                            if (monitor == null || !monitor.isCanceled()) {
                                CommandResult commandResult = CommandShell.createResult(wrapCommand, process.waitFor(), stdout.toString(), stderr.toString());
                                return commandResult;
                            }
                        }
                        catch (OperationCanceledException operationCanceledException) {
                        }
                        catch (InterruptedException e) {
                            CommandResult commandResult = new CommandResult(1, new String[0], new String[]{e.getMessage()});
                            return commandResult;
                        }
                        finally {
                            stdout.stop();
                            stderr.stop();
                            process.destroy();
                        }
                    }
                    return new CommandResult(1, new String[0], new String[]{"cancelled"});
                }
            });
            this.fExecutor.execute(future);
            try {
                ICommandResult iCommandResult = future.get(ControlPreferences.getInstance().getCommandTimeout(), TimeUnit.SECONDS);
                return iCommandResult;
            }
            catch (java.util.concurrent.ExecutionException ex) {
                throw new ExecutionException(Messages.TraceControl_ExecutionFailure, (Throwable)ex);
            }
            catch (InterruptedException ex) {
                throw new ExecutionException(Messages.TraceControl_ExecutionCancelled, (Throwable)ex);
            }
            catch (TimeoutException ex) {
                throw new ExecutionException(Messages.TraceControl_ExecutionTimeout, (Throwable)ex);
            }
            finally {
                future.cancel(true);
            }
        }
        throw new ExecutionException(Messages.TraceControl_ShellNotConnected, null);
    }

    private IRemoteProcess startRemoteProcess(boolean wrapCommand, List<String> command) throws IOException {
        if (wrapCommand) {
            StringBuilder formattedCommand = new StringBuilder();
            formattedCommand.append(SHELL_ECHO_CMD).append(BEGIN_TAG);
            formattedCommand.append(';');
            for (String cmd : command) {
                formattedCommand.append(cmd).append(' ');
            }
            formattedCommand.append(';');
            formattedCommand.append(SHELL_ECHO_CMD).append(END_TAG).append(CMD_RESULT_VAR);
            String[] args = formattedCommand.toString().trim().split("\\s+");
            return this.fConnection.getProcessBuilder(args).start();
        }
        return this.fConnection.getProcessBuilder(command).start();
    }

    private boolean isBackedByShell() throws InterruptedException {
        block13: {
            if (this.fBackedByShell == 0) {
                String cmd = "echo org.eclipse.linuxtools-BEGIN-TAG:;echo org.eclipse.linuxtools-END-TAG:";
                IRemoteProcessBuilder pb = this.fConnection.getProcessBuilder(cmd.trim().split("\\s+"));
                pb.redirectErrorStream(true);
                IRemoteProcess process = null;
                InputReader reader = null;
                try {
                    try {
                        process = pb.start();
                        reader = new InputReader(process.getInputStream());
                        reader.waitFor((IProgressMonitor)new NullProgressMonitor());
                        process.waitFor();
                        this.fBackedByShell = -1;
                        String result = reader.toString();
                        int pos = result.indexOf(BEGIN_TAG, CommandShell.skipEchoBeginTag(result));
                        if (pos >= 0 && result.substring(pos + BEGIN_TAG.length()).trim().startsWith(END_TAG)) {
                            this.fBackedByShell = 1;
                        }
                    }
                    catch (IOException e) {
                        this.fBackedByShell = -1;
                        if (process != null) {
                            process.destroy();
                        }
                        if (reader != null) {
                            reader.stop();
                        }
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    if (process != null) {
                        process.destroy();
                    }
                    if (reader != null) {
                        reader.stop();
                    }
                    throw throwable;
                }
                if (process != null) {
                    process.destroy();
                }
                if (reader != null) {
                    reader.stop();
                }
            }
        }
        return this.fBackedByShell == 1;
    }

    private static CommandResult createResult(boolean isWrapped, int origResult, String origStdout, String origStderr) {
        String stderr;
        String stdout;
        int result;
        if (isWrapped) {
            String[] holder = new String[]{origStdout};
            result = CommandShell.unwrapOutput(holder);
            stdout = holder[0];
            stderr = origStderr.isEmpty() ? stdout : origStderr;
        } else {
            result = origResult;
            stdout = origStdout;
            stderr = origStderr;
        }
        String[] output = CommandShell.splitLines(stdout);
        String[] error = CommandShell.splitLines(stderr);
        return new CommandResult(result, output, error);
    }

    private static String[] splitLines(String output) {
        if (output == null) {
            return null;
        }
        return output.split("\\r?\\n");
    }

    private static int unwrapOutput(String[] outputHolder) {
        String output = outputHolder[0];
        int begin = CommandShell.skipEchoBeginTag(output);
        if ((begin = output.indexOf(BEGIN_TAG, begin)) < 0) {
            outputHolder[0] = "";
            return 1;
        }
        int end = output.indexOf(END_TAG, begin += BEGIN_TAG.length());
        if (end < 0) {
            outputHolder[0] = output.substring(begin).trim();
            return 1;
        }
        outputHolder[0] = output.substring(begin, end).trim();
        String tail = output.substring(end + END_TAG.length()).trim();
        int numEnd = 0;
        while (numEnd < tail.length()) {
            if (!Character.isDigit(tail.charAt(numEnd))) break;
            ++numEnd;
        }
        try {
            return Integer.parseInt(tail.substring(0, numEnd));
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    private static int skipEchoBeginTag(String output) {
        int i;
        String searchFor = "echo org.eclipse.linuxtools-BEGIN-TAG:";
        int begin = 0;
        while ((i = output.indexOf("echo org.eclipse.linuxtools-BEGIN-TAG:", begin)) >= begin) {
            begin = i + "echo org.eclipse.linuxtools-BEGIN-TAG:".length();
        }
        return begin;
    }
}

