/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.control.ui.views.remote;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.runtime.IProgressMonitor;

class InputReader {
    private final InputStreamReader fReader;
    private final Thread fThread;
    private final StringBuilder fResult = new StringBuilder();
    private volatile boolean fDone;

    public InputReader(InputStream inputStream) {
        this.fReader = new InputStreamReader(inputStream);
        this.fThread = new Thread(){

            @Override
            public void run() {
                char[] buffer = new char[1024];
                try {
                    int read;
                    while (!InputReader.this.fDone && (read = InputReader.this.fReader.read(buffer)) > 0) {
                        InputReader.this.fResult.append(buffer, 0, read);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        this.fThread.start();
    }

    public void waitFor(IProgressMonitor monitor) throws InterruptedException {
        while (this.fThread.isAlive() && (monitor == null || !monitor.isCanceled())) {
            this.fThread.join(300L);
        }
    }

    public void stop() {
        this.fDone = true;
        this.fThread.interrupt();
    }

    public String toString() {
        return this.fResult.toString();
    }
}

