/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.control.ui.views.remote;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.remote.CommandShell;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.remote.ICommandShell;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.remote.IRemoteSystemProxy;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionChangeEvent;
import org.eclipse.remote.core.IRemoteConnectionChangeListener;
import org.eclipse.remote.core.IRemoteFileManager;
import org.eclipse.remote.core.IRemoteProcessBuilder;
import org.eclipse.remote.core.exception.RemoteConnectionException;

public class RemoteSystemProxy
implements IRemoteSystemProxy,
IRemoteConnectionChangeListener {
    private IRemoteConnection fHost;
    private boolean fExplicitConnect;

    public RemoteSystemProxy(IRemoteConnection host) {
        this.fHost = host;
        this.fHost.addConnectionChangeListener((IRemoteConnectionChangeListener)this);
    }

    @Override
    public IRemoteFileManager getFileServiceSubSystem() {
        return this.fHost.getFileManager();
    }

    @Override
    public IRemoteProcessBuilder getProcessBuilder(String ... command) {
        return this.fHost.getProcessBuilder(command);
    }

    @Override
    public void connect(IProgressMonitor monitor) throws ExecutionException {
        try {
            if (!this.fHost.isOpen()) {
                this.fExplicitConnect = true;
                this.fHost.open(monitor);
            }
        }
        catch (RemoteConnectionException e) {
            throw new ExecutionException("Cannot connect " + this.fHost.getName(), (Throwable)e);
        }
    }

    @Override
    public void disconnect() throws ExecutionException {
        this.fHost.close();
    }

    @Override
    public void dispose() {
        this.fHost.removeConnectionChangeListener((IRemoteConnectionChangeListener)this);
        if (this.fExplicitConnect) {
            this.fHost.close();
        }
    }

    @Override
    public ICommandShell createCommandShell() throws ExecutionException {
        CommandShell shell = new CommandShell(this.fHost);
        shell.connect();
        return shell;
    }

    @Override
    public void addConnectionChangeListener(IRemoteConnectionChangeListener listener) {
        this.fHost.addConnectionChangeListener(listener);
    }

    @Override
    public void removeConnectionChangeListener(IRemoteConnectionChangeListener listener) {
        this.fHost.removeConnectionChangeListener(listener);
    }

    @Override
    public boolean isConnected() {
        return this.fHost.isOpen();
    }

    public void connectionChanged(IRemoteConnectionChangeEvent event) {
        int type = event.getType();
        if (type == 4 || type == 1) {
            this.fExplicitConnect = false;
        }
    }
}

