/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.control.ui.views.service;

import org.osgi.framework.Version;

public class LttngVersion
extends Version {
    private final String fLicense;
    private final String fCommit;
    private final String fName;
    private final String fDescription;
    private final String fUrl;
    private final String fFullVersion;

    public LttngVersion(String version) {
        super(version);
        this.fLicense = "";
        this.fCommit = "";
        this.fName = "";
        this.fDescription = "";
        this.fUrl = "";
        this.fFullVersion = "";
    }

    public LttngVersion(int major, int minor, int micro, String license, String commit, String name, String description, String url, String fullVersion) {
        super(major, minor, micro);
        this.fLicense = license;
        this.fCommit = commit;
        this.fName = name;
        this.fDescription = description;
        this.fUrl = url;
        this.fFullVersion = fullVersion;
    }

    public int compareTo(LttngVersion other) {
        if (other == this) {
            return 0;
        }
        int result = this.getMajor() - other.getMajor();
        if (result != 0) {
            return result;
        }
        result = this.getMinor() - other.getMinor();
        if (result != 0) {
            return result;
        }
        result = this.getMicro() - other.getMicro();
        if (result != 0) {
            return result;
        }
        return this.getQualifier().compareTo(other.getQualifier());
    }

    public String getLicense() {
        return this.fLicense;
    }

    public String getCommit() {
        return this.fCommit;
    }

    public String getName() {
        return this.fName;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public String getUrl() {
        return this.fUrl;
    }

    public String getFullVersion() {
        return this.fFullVersion;
    }
}

