/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.analysis.xml.core.stateprovider;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.linuxtools.statesystem.core.ITmfStateSystem;
import org.eclipse.linuxtools.tmf.analysis.xml.core.model.ITmfXmlModelFactory;
import org.eclipse.linuxtools.tmf.analysis.xml.core.model.TmfXmlEventHandler;
import org.eclipse.linuxtools.tmf.analysis.xml.core.model.TmfXmlLocation;
import org.eclipse.linuxtools.tmf.analysis.xml.core.model.readwrite.TmfXmlReadWriteModelFactory;
import org.eclipse.linuxtools.tmf.analysis.xml.core.module.IXmlStateSystemContainer;
import org.eclipse.linuxtools.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XmlStateProvider
extends AbstractTmfStateProvider
implements IXmlStateSystemContainer {
    private final IPath fFilePath;
    @NonNull
    private final String fStateId;
    private final Set<TmfXmlEventHandler> fEventHandlers = new HashSet<TmfXmlEventHandler>();
    private final Set<TmfXmlLocation> fLocations;
    private final Map<String, String> fDefinedValues = new HashMap<String, String>();

    public XmlStateProvider(ITmfTrace trace, @NonNull String stateid, IPath file) {
        super(trace, ITmfEvent.class, stateid);
        this.fStateId = stateid;
        this.fFilePath = file;
        Element doc = XmlUtils.getElementInFile(this.fFilePath.makeAbsolute().toOSString(), "stateProvider", this.fStateId);
        if (doc == null) {
            this.fLocations = new HashSet<TmfXmlLocation>();
            return;
        }
        ITmfXmlModelFactory modelFactory = TmfXmlReadWriteModelFactory.getInstance();
        NodeList definedStateNodes = doc.getElementsByTagName("definedValue");
        int i = 0;
        while (i < definedStateNodes.getLength()) {
            Element element = (Element)definedStateNodes.item(i);
            this.fDefinedValues.put(element.getAttribute("name"), element.getAttribute("value"));
            ++i;
        }
        NodeList locationNodes = doc.getElementsByTagName("location");
        HashSet<TmfXmlLocation> locations = new HashSet<TmfXmlLocation>();
        int i2 = 0;
        while (i2 < locationNodes.getLength()) {
            Element element = (Element)locationNodes.item(i2);
            TmfXmlLocation location = modelFactory.createLocation(element, this);
            locations.add(location);
            ++i2;
        }
        this.fLocations = Collections.unmodifiableSet(locations);
        NodeList nodes = doc.getElementsByTagName("eventHandler");
        int i3 = 0;
        while (i3 < nodes.getLength()) {
            Element element = (Element)nodes.item(i3);
            TmfXmlEventHandler handler = modelFactory.createEventHandler(element, this);
            this.fEventHandlers.add(handler);
            ++i3;
        }
    }

    @NonNull
    public String getStateId() {
        return this.fStateId;
    }

    public int getVersion() {
        Element ssNode = XmlUtils.getElementInFile(this.fFilePath.makeAbsolute().toOSString(), "stateProvider", this.fStateId);
        if (ssNode != null) {
            return Integer.parseInt(ssNode.getAttribute("version"));
        }
        throw new IllegalStateException("The state provider XML node should have a version attribute");
    }

    public XmlStateProvider getNewInstance() {
        return new XmlStateProvider(this.getTrace(), this.getStateId(), this.fFilePath);
    }

    protected void eventHandle(ITmfEvent event) {
        if (event == null) {
            return;
        }
        for (TmfXmlEventHandler eventHandler : this.fEventHandlers) {
            eventHandler.handleEvent(event);
        }
    }

    @Override
    public ITmfStateSystem getStateSystem() {
        return this.ss;
    }

    @Override
    public Iterable<TmfXmlLocation> getLocations() {
        return this.fLocations;
    }

    public String getDefinedValue(String constant) {
        return this.fDefinedValues.get(constant);
    }

    @Override
    public String getAttributeValue(String name) {
        String attribute = name;
        if (attribute.startsWith("$")) {
            attribute = this.getDefinedValue(attribute.substring(1));
        }
        return attribute;
    }
}

