/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.analysis.xml.core.stateprovider;

import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.linuxtools.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.linuxtools.tmf.analysis.xml.core.stateprovider.XmlStateProvider;
import org.eclipse.linuxtools.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.linuxtools.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.w3c.dom.Element;

public class XmlStateSystemModule
extends TmfStateSystemAnalysisModule {
    @Nullable
    private IPath fXmlFile;

    protected TmfStateSystemAnalysisModule.StateSystemBackendType getBackendType() {
        return TmfStateSystemAnalysisModule.StateSystemBackendType.FULL;
    }

    @NonNull
    protected ITmfStateProvider createStateProvider() {
        return new XmlStateProvider(this.getTrace(), this.getId(), this.fXmlFile);
    }

    public String getName() {
        List<Element> labels;
        String name = this.getId();
        IPath xmlFile = this.fXmlFile;
        if (xmlFile == null) {
            return name;
        }
        Element doc = XmlUtils.getElementInFile(xmlFile.makeAbsolute().toString(), "stateProvider", this.getId());
        List<Element> head = XmlUtils.getChildElements(doc, "head");
        if (head.size() == 1 && !(labels = XmlUtils.getChildElements(head.get(0), "label")).isEmpty()) {
            name = labels.get(0).getAttribute("value");
        }
        return name;
    }

    public void setXmlFile(IPath file) {
        this.fXmlFile = file;
    }

    public IPath getXmlFile() {
        return this.fXmlFile;
    }
}

