/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.core.statesystem.backends.partial;

import java.io.File;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.backends.partial.PartialStateSystem;
import org.eclipse.linuxtools.statesystem.core.backend.IStateHistoryBackend;
import org.eclipse.linuxtools.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.linuxtools.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.linuxtools.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.linuxtools.statesystem.core.interval.TmfStateInterval;
import org.eclipse.linuxtools.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.request.ITmfEventRequest;
import org.eclipse.linuxtools.tmf.core.request.TmfEventRequest;
import org.eclipse.linuxtools.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.linuxtools.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;

public class PartialHistoryBackend
implements IStateHistoryBackend {
    @NonNull
    private final ITmfStateProvider partialInput;
    @NonNull
    private final PartialStateSystem partialSS;
    @NonNull
    private final IStateHistoryBackend innerHistory;
    @NonNull
    private final TreeMap<Long, Long> checkpoints = new TreeMap();
    @NonNull
    private final CountDownLatch checkpointsReady = new CountDownLatch(1);
    private final long granularity;
    private long latestTime;

    public PartialHistoryBackend(ITmfStateProvider partialInput, PartialStateSystem pss, IStateHistoryBackend realBackend, long granularity) {
        if (granularity <= 0L || partialInput == null || pss == null || partialInput.getAssignedStateSystem() != pss) {
            throw new IllegalArgumentException();
        }
        long startTime = realBackend.getStartTime();
        this.partialInput = partialInput;
        this.partialSS = pss;
        this.innerHistory = realBackend;
        this.granularity = granularity;
        this.latestTime = startTime;
        this.registerCheckpoints();
    }

    private void registerCheckpoints() {
        CheckpointsRequest request = new CheckpointsRequest(this.partialInput, this.checkpoints);
        this.partialInput.getTrace().sendRequest(request);
    }

    public long getStartTime() {
        return this.innerHistory.getStartTime();
    }

    public long getEndTime() {
        return this.latestTime;
    }

    public void insertPastState(long stateStartTime, long stateEndTime, int quark, ITmfStateValue value) throws TimeRangeException {
        this.waitForCheckpoints();
        if (stateEndTime > this.latestTime) {
            this.latestTime = stateEndTime;
        }
        if (stateStartTime <= this.checkpoints.floorKey(stateEndTime)) {
            this.innerHistory.insertPastState(stateStartTime, stateEndTime, quark, value);
        }
    }

    public void finishedBuilding(long endTime) throws TimeRangeException {
        this.innerHistory.finishedBuilding(endTime);
    }

    public FileInputStream supplyAttributeTreeReader() {
        return this.innerHistory.supplyAttributeTreeReader();
    }

    public File supplyAttributeTreeWriterFile() {
        return this.innerHistory.supplyAttributeTreeWriterFile();
    }

    public long supplyAttributeTreeWriterFilePosition() {
        return this.innerHistory.supplyAttributeTreeWriterFilePosition();
    }

    public void removeFiles() {
        this.innerHistory.removeFiles();
    }

    public void dispose() {
        this.partialInput.dispose();
        this.partialSS.dispose();
        this.innerHistory.dispose();
    }

    public void doQuery(List<ITmfStateInterval> currentStateInfo, long t) throws TimeRangeException, StateSystemDisposedException {
        this.waitForCheckpoints();
        this.partialSS.getUpstreamSS().waitUntilBuilt();
        if (!this.checkValidTime(t)) {
            throw new TimeRangeException();
        }
        long checkpointTime = this.checkpoints.floorKey(t);
        this.innerHistory.doQuery(currentStateInfo, checkpointTime);
        this.partialSS.takeQueryLock();
        this.partialSS.replaceOngoingState(currentStateInfo);
        TmfTimeRange range = new TmfTimeRange(new TmfTimestamp(checkpointTime + 1L, -9), new TmfTimestamp(t, -9));
        PartialStateSystemRequest request = new PartialStateSystemRequest(this.partialInput, range);
        this.partialInput.getTrace().sendRequest(request);
        try {
            request.waitForCompletion();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        try {
            int i = 0;
            while (i < currentStateInfo.size()) {
                long start = 0L;
                ITmfStateValue val = null;
                start = this.partialSS.getOngoingStartTime(i);
                val = this.partialSS.queryOngoingState(i);
                TmfStateInterval interval = new TmfStateInterval(start, t, i, val);
                currentStateInfo.set(i, (ITmfStateInterval)interval);
                ++i;
            }
        }
        catch (AttributeNotFoundException e) {
            e.printStackTrace();
        }
        this.partialSS.releaseQueryLock();
    }

    public ITmfStateInterval doSingularQuery(long t, int attributeQuark) {
        throw new UnsupportedOperationException();
    }

    public boolean checkValidTime(long t) {
        return t >= this.getStartTime() && t <= this.getEndTime();
    }

    public void debugPrint(PrintWriter writer) {
    }

    private void waitForCheckpoints() {
        try {
            this.checkpointsReady.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private class CheckpointsRequest
    extends TmfEventRequest {
        private final ITmfTrace trace;
        private final Map<Long, Long> checkpts;
        private long eventCount;
        private long lastCheckpointAt;

        public CheckpointsRequest(ITmfStateProvider input, Map<Long, Long> checkpoints) {
            super(input.getExpectedEventType(), TmfTimeRange.ETERNITY, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.FOREGROUND);
            checkpoints.clear();
            this.trace = input.getTrace();
            this.checkpts = checkpoints;
            this.eventCount = 0L;
            this.lastCheckpointAt = 0L;
            checkpoints.put(input.getStartTime(), 0L);
        }

        @Override
        public void handleData(ITmfEvent event) {
            super.handleData(event);
            if (event.getTrace() == this.trace) {
                ++this.eventCount;
                if (this.eventCount >= this.lastCheckpointAt + PartialHistoryBackend.this.granularity) {
                    this.checkpts.put(event.getTimestamp().getValue(), this.eventCount);
                    this.lastCheckpointAt = this.eventCount;
                }
            }
        }

        @Override
        public void handleCompleted() {
            super.handleCompleted();
            PartialHistoryBackend.this.checkpointsReady.countDown();
        }
    }

    private class PartialStateSystemRequest
    extends TmfEventRequest {
        private final ITmfStateProvider sci;
        private final ITmfTrace trace;

        PartialStateSystemRequest(ITmfStateProvider sci, TmfTimeRange range) {
            super(sci.getExpectedEventType(), range, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND);
            this.sci = sci;
            this.trace = sci.getTrace();
        }

        @Override
        public void handleData(ITmfEvent event) {
            super.handleData(event);
            if (event.getTrace() == this.trace) {
                this.sci.processEvent(event);
            }
        }

        @Override
        public void handleCompleted() {
            if (PartialHistoryBackend.this.partialInput instanceof AbstractTmfStateProvider) {
                ((AbstractTmfStateProvider)PartialHistoryBackend.this.partialInput).waitForEmptyQueue();
            }
            super.handleCompleted();
        }
    }
}

