/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.linuxtools.internal.tmf.core.Activator;
import org.eclipse.linuxtools.internal.tmf.core.analysis.TmfAnalysisModuleSources;
import org.eclipse.linuxtools.tmf.core.analysis.IAnalysisModule;
import org.eclipse.linuxtools.tmf.core.analysis.IAnalysisModuleHelper;
import org.eclipse.linuxtools.tmf.core.analysis.IAnalysisModuleSource;
import org.eclipse.linuxtools.tmf.core.analysis.IAnalysisParameterProvider;
import org.eclipse.linuxtools.tmf.core.analysis.ITmfNewAnalysisModuleListener;
import org.eclipse.linuxtools.tmf.core.analysis.Messages;
import org.eclipse.linuxtools.tmf.core.analysis.TmfAnalysisModuleOutputs;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;

public class TmfAnalysisManager {
    private static final Map<String, IAnalysisModuleHelper> fAnalysisModules = new HashMap<String, IAnalysisModuleHelper>();
    private static final Map<String, List<Class<? extends IAnalysisParameterProvider>>> fParameterProviders = new HashMap<String, List<Class<? extends IAnalysisParameterProvider>>>();
    private static final Map<Class<? extends IAnalysisParameterProvider>, IAnalysisParameterProvider> fParamProviderInstances = new HashMap<Class<? extends IAnalysisParameterProvider>, IAnalysisParameterProvider>();
    private static final List<IAnalysisModuleSource> fSources = new ArrayList<IAnalysisModuleSource>();
    private static final List<ITmfNewAnalysisModuleListener> fListeners = new ArrayList<ITmfNewAnalysisModuleListener>();

    @Deprecated
    public TmfAnalysisManager() {
    }

    public static synchronized void registerModuleSource(IAnalysisModuleSource source) {
        fSources.add(source);
        TmfAnalysisManager.refreshModules();
    }

    public static synchronized void initialize() {
        fSources.clear();
        fListeners.clear();
        TmfAnalysisManager.initializeModuleSources();
        TmfAnalysisManager.initializeNewModuleListeners();
    }

    private static synchronized void initializeModuleSources() {
        for (IAnalysisModuleSource source : TmfAnalysisModuleSources.getSources()) {
            fSources.add(source);
        }
    }

    private static synchronized void initializeNewModuleListeners() {
        for (ITmfNewAnalysisModuleListener output : TmfAnalysisModuleOutputs.getOutputListeners()) {
            fListeners.add(output);
        }
    }

    public static synchronized void addNewModuleListener(ITmfNewAnalysisModuleListener listener) {
        fListeners.add(listener);
    }

    public static synchronized Map<String, IAnalysisModuleHelper> getAnalysisModules() {
        if (fAnalysisModules.isEmpty()) {
            for (IAnalysisModuleSource source : fSources) {
                for (IAnalysisModuleHelper helper : source.getAnalysisModules()) {
                    fAnalysisModules.put(helper.getId(), helper);
                }
            }
        }
        return Collections.unmodifiableMap(fAnalysisModules);
    }

    public static Map<String, IAnalysisModuleHelper> getAnalysisModules(Class<? extends ITmfTrace> traceclass) {
        Map<String, IAnalysisModuleHelper> allModules = TmfAnalysisManager.getAnalysisModules();
        HashMap<String, IAnalysisModuleHelper> map = new HashMap<String, IAnalysisModuleHelper>();
        for (IAnalysisModuleHelper module : allModules.values()) {
            if (!module.appliesToTraceType(traceclass)) continue;
            map.put(module.getId(), module);
        }
        return Collections.unmodifiableMap(map);
    }

    public static IAnalysisModuleHelper getAnalysisModule(String id) {
        Map<String, IAnalysisModuleHelper> map = TmfAnalysisManager.getAnalysisModules();
        return map.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerParameterProvider(String analysisId, Class<? extends IAnalysisParameterProvider> paramProvider) {
        Map<String, List<Class<? extends IAnalysisParameterProvider>>> map = fParameterProviders;
        synchronized (map) {
            if (!fParameterProviders.containsKey(analysisId)) {
                fParameterProviders.put(analysisId, new ArrayList());
            }
            fParameterProviders.get(analysisId).add(paramProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IAnalysisParameterProvider> getParameterProviders(IAnalysisModule module, ITmfTrace trace) {
        ArrayList<IAnalysisParameterProvider> providerList = new ArrayList<IAnalysisParameterProvider>();
        Map<String, List<Class<? extends IAnalysisParameterProvider>>> map = fParameterProviders;
        synchronized (map) {
            if (!fParameterProviders.containsKey(module.getId())) {
                return providerList;
            }
            for (Class<? extends IAnalysisParameterProvider> providerClass : fParameterProviders.get(module.getId())) {
                try {
                    IAnalysisParameterProvider provider = fParamProviderInstances.get(providerClass);
                    if (provider == null) {
                        provider = providerClass.newInstance();
                        fParamProviderInstances.put(providerClass, provider);
                    }
                    if (provider == null || !provider.appliesToTrace(trace)) continue;
                    providerList.add(provider);
                }
                catch (IllegalArgumentException e) {
                    Activator.logError(Messages.TmfAnalysisManager_ErrorParameterProvider, e);
                }
                catch (SecurityException e) {
                    Activator.logError(Messages.TmfAnalysisManager_ErrorParameterProvider, e);
                }
                catch (InstantiationException e) {
                    Activator.logError(Messages.TmfAnalysisManager_ErrorParameterProvider, e);
                }
                catch (IllegalAccessException e) {
                    Activator.logError(Messages.TmfAnalysisManager_ErrorParameterProvider, e);
                }
            }
        }
        return providerList;
    }

    public static synchronized void refreshModules() {
        fAnalysisModules.clear();
    }

    public static synchronized void analysisModuleCreated(IAnalysisModule module) {
        for (ITmfNewAnalysisModuleListener listener : fListeners) {
            listener.moduleCreated(module);
        }
    }
}

