/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.callstack;

import org.eclipse.linuxtools.internal.tmf.core.Activator;
import org.eclipse.linuxtools.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.linuxtools.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.linuxtools.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.linuxtools.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.linuxtools.tmf.core.callstack.Messages;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.osgi.util.NLS;

public abstract class CallStackStateProvider
extends AbstractTmfStateProvider {
    public static final String THREADS = "Threads";
    public static final String CALL_STACK = "CallStack";
    public static final String UNDEFINED = "UNDEFINED";
    private static final String ID = "org.eclipse.linuxtools.tmf.callstack";
    private static final String NO_FUNCTION = "no function";

    public CallStackStateProvider(ITmfTrace trace) {
        super(trace, ITmfEvent.class, ID);
    }

    @Override
    protected void eventHandle(ITmfEvent event) {
        if (!this.considerEvent(event)) {
            return;
        }
        try {
            String functionEntryName = this.functionEntry(event);
            if (functionEntryName != null) {
                long timestamp = event.getTimestamp().normalize(0L, -9).getValue();
                String thread = this.getThreadName(event);
                int threadQuark = this.ss.getQuarkAbsoluteAndAdd(new String[]{THREADS, thread});
                Long threadId = this.getThreadId(event);
                if (threadId != null) {
                    this.ss.updateOngoingState((ITmfStateValue)TmfStateValue.newValueLong((long)threadId), threadQuark);
                }
                int callStackQuark = this.ss.getQuarkRelativeAndAdd(threadQuark, new String[]{CALL_STACK});
                TmfStateValue value = TmfStateValue.newValueString((String)functionEntryName);
                this.ss.pushAttribute(timestamp, (ITmfStateValue)value, callStackQuark);
                return;
            }
            String functionExitName = this.functionExit(event);
            if (functionExitName != null) {
                String poppedName;
                long timestamp = event.getTimestamp().normalize(0L, -9).getValue();
                String thread = this.getThreadName(event);
                int quark = this.ss.getQuarkAbsoluteAndAdd(new String[]{THREADS, thread, CALL_STACK});
                ITmfStateValue poppedValue = this.ss.popAttribute(timestamp, quark);
                String string = poppedName = poppedValue == null ? NO_FUNCTION : poppedValue.unboxStr();
                if (!functionExitName.equals(UNDEFINED) && !functionExitName.equals(poppedName)) {
                    Activator.logWarning(NLS.bind((String)Messages.CallStackStateProvider_UnmatchedPoppedValue, (Object)functionExitName, (Object)poppedName));
                }
            }
        }
        catch (TimeRangeException e) {
            e.printStackTrace();
        }
        catch (AttributeNotFoundException e) {
            e.printStackTrace();
        }
        catch (StateValueTypeException e) {
            e.printStackTrace();
        }
    }

    protected abstract boolean considerEvent(ITmfEvent var1);

    protected abstract String functionEntry(ITmfEvent var1);

    protected abstract String functionExit(ITmfEvent var1);

    protected abstract String getThreadName(ITmfEvent var1);

    protected Long getThreadId(ITmfEvent event) {
        return null;
    }
}

