/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.event.matching;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.matching.IMatchProcessingUnit;
import org.eclipse.linuxtools.tmf.core.event.matching.ITmfNetworkMatchDefinition;
import org.eclipse.linuxtools.tmf.core.event.matching.TmfEventDependency;
import org.eclipse.linuxtools.tmf.core.event.matching.TmfEventMatches;
import org.eclipse.linuxtools.tmf.core.event.matching.TmfEventMatching;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;

public class TmfNetworkEventMatching
extends TmfEventMatching {
    private final Map<ITmfTrace, Map<List<Object>, ITmfEvent>> fUnmatchedIn = new LinkedHashMap<ITmfTrace, Map<List<Object>, ITmfEvent>>();
    private final Map<ITmfTrace, Map<List<Object>, ITmfEvent>> fUnmatchedOut = new LinkedHashMap<ITmfTrace, Map<List<Object>, ITmfEvent>>();

    public TmfNetworkEventMatching(Collection<ITmfTrace> traces) {
        this(traces, new TmfEventMatches());
    }

    public TmfNetworkEventMatching(Collection<ITmfTrace> traces, IMatchProcessingUnit tmfEventMatches) {
        super(traces, tmfEventMatches);
    }

    @Override
    public void initMatching() {
        this.fUnmatchedIn.clear();
        this.fUnmatchedOut.clear();
        for (ITmfTrace iTmfTrace : this.getTraces()) {
            this.fUnmatchedIn.put(iTmfTrace, new HashMap());
            this.fUnmatchedOut.put(iTmfTrace, new HashMap());
        }
        super.initMatching();
    }

    protected int countEvents(Map<List<Object>, ITmfEvent> tbl) {
        return tbl.size();
    }

    @Override
    protected TmfEventMatching.MatchingType getMatchingType() {
        return TmfEventMatching.MatchingType.NETWORK;
    }

    @Override
    public void matchEvent(ITmfEvent event, ITmfTrace trace) {
        Map<ITmfTrace, Map<List<Object>, ITmfEvent>> companionTbl;
        Map<ITmfTrace, Map<List<Object>, ITmfEvent>> unmatchedTbl;
        if (!(this.getEventDefinition(event.getTrace()) instanceof ITmfNetworkMatchDefinition)) {
            return;
        }
        ITmfNetworkMatchDefinition def = (ITmfNetworkMatchDefinition)this.getEventDefinition(event.getTrace());
        Direction evType = def.getDirection(event);
        if (evType == null) {
            return;
        }
        List<Object> eventKey = def.getUniqueField(event);
        switch (evType) {
            case IN: {
                unmatchedTbl = this.fUnmatchedIn;
                companionTbl = this.fUnmatchedOut;
                break;
            }
            case OUT: {
                unmatchedTbl = this.fUnmatchedOut;
                companionTbl = this.fUnmatchedIn;
                break;
            }
            default: {
                return;
            }
        }
        boolean found = false;
        TmfEventDependency dep = null;
        for (Map<List<Object>, ITmfEvent> map : companionTbl.values()) {
            if (!map.containsKey(eventKey)) continue;
            found = true;
            ITmfEvent companionEvent = map.get(eventKey);
            map.remove(eventKey);
            switch (evType) {
                case IN: {
                    dep = new TmfEventDependency(companionEvent, event);
                    break;
                }
                case OUT: {
                    dep = new TmfEventDependency(event, companionEvent);
                    break;
                }
            }
        }
        if (found) {
            this.getProcessingUnit().addMatch(dep);
        } else if (!unmatchedTbl.get(trace).containsKey(eventKey)) {
            unmatchedTbl.get(trace).put(eventKey, event);
        }
    }

    @Override
    public String toString() {
        String cr = System.getProperty("line.separator");
        StringBuilder b = new StringBuilder();
        b.append(this.getProcessingUnit());
        int i = 0;
        for (ITmfTrace iTmfTrace : this.getTraces()) {
            b.append("Trace " + i++ + ":" + cr + "  " + this.countEvents(this.fUnmatchedIn.get(iTmfTrace)) + " unmatched incoming events" + cr + "  " + this.countEvents(this.fUnmatchedOut.get(iTmfTrace)) + " unmatched outgoing events" + cr);
        }
        return b.toString();
    }

    public static enum Direction {
        IN,
        OUT;

    }
}

