/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.filter.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.filter.model.ITmfFilterTreeNode;
import org.eclipse.linuxtools.tmf.core.filter.model.TmfFilterTreeNode;

public class TmfFilterContainsNode
extends TmfFilterTreeNode {
    public static final String NODE_NAME = "CONTAINS";
    public static final String NOT_ATTR = "not";
    public static final String FIELD_ATTR = "field";
    public static final String VALUE_ATTR = "value";
    public static final String IGNORECASE_ATTR = "ignorecase";
    private boolean fNot = false;
    private String fField;
    private String fValue;
    private transient String fValueUpperCase;
    private boolean fIgnoreCase = false;

    public TmfFilterContainsNode(ITmfFilterTreeNode parent) {
        super(parent);
    }

    public boolean isNot() {
        return this.fNot;
    }

    public void setNot(boolean not) {
        this.fNot = not;
    }

    public String getField() {
        return this.fField;
    }

    public void setField(String field) {
        this.fField = field;
    }

    public String getValue() {
        return this.fValue;
    }

    public void setValue(String value) {
        this.fValue = value;
        if (value != null) {
            this.fValueUpperCase = value.toUpperCase();
        }
    }

    public boolean isIgnoreCase() {
        return this.fIgnoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.fIgnoreCase = ignoreCase;
    }

    @Override
    public String getNodeName() {
        return NODE_NAME;
    }

    @Override
    public boolean matches(ITmfEvent event) {
        Object value = this.getFieldValue(event, this.fField);
        if (value == null) {
            return this.fNot;
        }
        String valueString = value.toString();
        if (this.fIgnoreCase) {
            return valueString.toUpperCase().contains(this.fValueUpperCase) ^ this.fNot;
        }
        return valueString.contains(this.fValue) ^ this.fNot;
    }

    @Override
    public List<String> getValidChildren() {
        return new ArrayList<String>(0);
    }

    public String toString() {
        return String.valueOf(this.fField) + (this.fNot ? " not contains " : " contains ") + (this.fIgnoreCase ? "ignorecase \"" : "\"") + this.fValue + '\"';
    }

    @Override
    public ITmfFilterTreeNode clone() {
        TmfFilterContainsNode clone = (TmfFilterContainsNode)super.clone();
        clone.fField = this.fField;
        clone.setValue(this.fValue);
        return clone;
    }
}

