/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.parsers.custom;

import java.util.regex.Matcher;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventField;
import org.eclipse.linuxtools.tmf.core.event.TmfEvent;
import org.eclipse.linuxtools.tmf.core.event.TmfEventType;
import org.eclipse.linuxtools.tmf.core.parsers.custom.CustomEvent;
import org.eclipse.linuxtools.tmf.core.parsers.custom.CustomTraceDefinition;
import org.eclipse.linuxtools.tmf.core.parsers.custom.CustomTxtEventType;
import org.eclipse.linuxtools.tmf.core.parsers.custom.CustomTxtTraceDefinition;
import org.eclipse.linuxtools.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;

public class CustomTxtEvent
extends CustomEvent {
    public CustomTxtEvent(CustomTxtTraceDefinition definition) {
        super(definition);
        this.setType(new CustomTxtEventType(definition));
    }

    public CustomTxtEvent(CustomTxtTraceDefinition definition, TmfEvent other) {
        super(definition, other);
    }

    public CustomTxtEvent(CustomTxtTraceDefinition definition, ITmfTrace parentTrace, ITmfTimestamp timestamp, String source, TmfEventType type, String reference) {
        super(definition, parentTrace, timestamp, source, type, reference);
    }

    @Override
    public void setContent(ITmfEventField content) {
        super.setContent(content);
    }

    public void processGroups(CustomTxtTraceDefinition.InputLine input, Matcher matcher) {
        if (input.columns == null) {
            return;
        }
        int i = 0;
        while (i < input.columns.size()) {
            String value;
            CustomTxtTraceDefinition.InputData column = input.columns.get(i);
            if (i < matcher.groupCount() && matcher.group(i + 1) != null && (value = matcher.group(i + 1).trim()).length() != 0) {
                String timeStampInputFormat;
                String s;
                String name = column.name;
                if (column.action == 0) {
                    this.fData.put(name, value);
                    if (name.equals(CustomTraceDefinition.TAG_TIMESTAMP)) {
                        this.fData.put("CE_TS_I_F", column.format);
                    }
                } else if (column.action == 1) {
                    s = (String)this.fData.get(name);
                    if (s != null) {
                        this.fData.put(name, String.valueOf(s) + value);
                    } else {
                        this.fData.put(name, value);
                    }
                    if (name.equals(CustomTraceDefinition.TAG_TIMESTAMP)) {
                        timeStampInputFormat = (String)this.fData.get("CE_TS_I_F");
                        if (timeStampInputFormat != null) {
                            this.fData.put("CE_TS_I_F", String.valueOf(timeStampInputFormat) + column.format);
                        } else {
                            this.fData.put("CE_TS_I_F", column.format);
                        }
                    }
                } else if (column.action == 2) {
                    s = (String)this.fData.get(name);
                    if (s != null) {
                        this.fData.put(name, String.valueOf(s) + " | " + value);
                    } else {
                        this.fData.put(name, value);
                    }
                    if (name.equals(CustomTraceDefinition.TAG_TIMESTAMP)) {
                        timeStampInputFormat = (String)this.fData.get("CE_TS_I_F");
                        if (timeStampInputFormat != null) {
                            this.fData.put("CE_TS_I_F", String.valueOf(timeStampInputFormat) + " | " + column.format);
                        } else {
                            this.fData.put("CE_TS_I_F", column.format);
                        }
                    }
                }
            }
            ++i;
        }
    }
}

