/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.project.model;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;

public class TmfTraceCoreUtils {
    private static final boolean IS_WINDOWS = System.getProperty("os.name").contains("Windows");
    private static final String INVALID_RESOURCE_CHARACTERS_WIN = "[\\\\/:*?\\\"<>]|\\.$";
    private static final String INVALID_RESOURCE_CHARACTERS_OTHER = "[/\u0000]";
    private static final char BACKSLASH_PUA = '\uf05c';
    private static final char COLON_PUA = '\uf03a';

    public static String validateName(String input) {
        String output = input;
        String pattern = IS_WINDOWS ? INVALID_RESOURCE_CHARACTERS_WIN : INVALID_RESOURCE_CHARACTERS_OTHER;
        output = output.replaceAll(pattern, String.valueOf('_'));
        if (!ResourcesPlugin.getWorkspace().validateName(output, 3).isOK()) {
            output = String.valueOf('_') + output;
        }
        return output;
    }

    public static Path newSafePath(String path) {
        return new Path(path.replace('\\', '\uf05c').replace(':', '\uf03a'));
    }

    public static String safePathToString(String path) {
        return path.replace('\uf05c', '\\').replace('\uf03a', ':');
    }
}

