/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.project.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.linuxtools.tmf.core.TmfCommonConstants;
import org.eclipse.linuxtools.tmf.core.parsers.custom.CustomTraceDefinition;
import org.eclipse.linuxtools.tmf.core.parsers.custom.CustomTxtTrace;
import org.eclipse.linuxtools.tmf.core.parsers.custom.CustomTxtTraceDefinition;
import org.eclipse.linuxtools.tmf.core.parsers.custom.CustomXmlTrace;
import org.eclipse.linuxtools.tmf.core.parsers.custom.CustomXmlTraceDefinition;
import org.eclipse.linuxtools.tmf.core.project.model.TraceTypeHelper;
import org.eclipse.linuxtools.tmf.core.project.model.TraceValidationHelper;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalManager;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfTrace;

public final class TmfTraceType {
    private static final char SEPARATOR = ':';
    public static final String TMF_TRACE_TYPE_ID = "org.eclipse.linuxtools.tmf.core.tracetype";
    public static final String CATEGORY_ELEM = "category";
    public static final String TYPE_ELEM = "type";
    public static final String EXPERIMENT_ELEM = "experiment";
    public static final String ID_ATTR = "id";
    public static final String NAME_ATTR = "name";
    public static final String CATEGORY_ATTR = "category";
    public static final String TRACE_TYPE_ATTR = "trace_type";
    public static final String EVENT_TYPE_ATTR = "event_type";
    public static final String EXPERIMENT_TYPE_ATTR = "experiment_type";
    public static final String IS_DIR_ATTR = "isDirectory";
    public static final String CUSTOM_TXT_CATEGORY = "Custom Text";
    public static final String CUSTOM_XML_CATEGORY = "Custom XML";
    public static final String DEFAULT_EXPERIMENT_TYPE = "org.eclipse.linuxtools.tmf.core.experiment.generic";
    private static final Map<String, IConfigurationElement> TRACE_TYPE_ATTRIBUTES = new HashMap<String, IConfigurationElement>();
    private static final Map<String, IConfigurationElement> TRACE_CATEGORIES = new HashMap<String, IConfigurationElement>();
    private static final Map<String, TraceTypeHelper> TRACE_TYPES = new LinkedHashMap<String, TraceTypeHelper>();

    static {
        TmfTraceType.populateCategoriesAndTraceTypes();
        TmfTraceType.populateCustomTraceTypes();
    }

    private TmfTraceType() {
    }

    public static String getCategoryName(String categoryId) {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(TMF_TRACE_TYPE_ID);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals("category") && element.getAttribute(ID_ATTR).equals(categoryId)) {
                return element.getAttribute(NAME_ATTR);
            }
            ++n2;
        }
        return "";
    }

    public static IConfigurationElement[] getTypeElements() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(TMF_TRACE_TYPE_ID);
        LinkedList<IConfigurationElement> typeElements = new LinkedList<IConfigurationElement>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals(TYPE_ELEM)) {
                typeElements.add(element);
            }
            ++n2;
        }
        return typeElements.toArray(new IConfigurationElement[typeElements.size()]);
    }

    @Deprecated
    public static TraceTypeHelper getTraceTypeHelper(String id) {
        return TRACE_TYPES.get(id);
    }

    public static Iterable<String> getTraceTypeIDs() {
        return TRACE_TYPES.keySet();
    }

    public static Iterable<TraceTypeHelper> getTraceTypeHelpers() {
        return TRACE_TYPES.values();
    }

    public static String[] getAvailableTraceTypes() {
        return TmfTraceType.getAvailableTraceTypes(null);
    }

    public static String[] getAvailableTraceTypes(Comparator<String> comparator) {
        ArrayList<String> traceTypes = new ArrayList<String>();
        for (String key : TRACE_TYPES.keySet()) {
            TraceTypeHelper tt = TRACE_TYPES.get(key);
            if (tt.isExperimentType()) continue;
            traceTypes.add(String.valueOf(tt.getCategoryName()) + ':' + tt.getName());
        }
        if (comparator == null) {
            Collections.sort(traceTypes);
        } else {
            Collections.sort(traceTypes, comparator);
        }
        return traceTypes.toArray(new String[traceTypes.size()]);
    }

    public static List<String> getCustomTraceTypes(String type) {
        String traceTypeName;
        CustomTraceDefinition def;
        int n;
        int n2;
        CustomTraceDefinition[] customTraceDefinitionArray;
        ArrayList<String> traceTypes = new ArrayList<String>();
        if (type.equals(CUSTOM_TXT_CATEGORY)) {
            customTraceDefinitionArray = CustomTxtTraceDefinition.loadAll();
            n2 = customTraceDefinitionArray.length;
            n = 0;
            while (n < n2) {
                def = customTraceDefinitionArray[n];
                traceTypeName = ((CustomTxtTraceDefinition)def).definitionName;
                traceTypes.add(traceTypeName);
                ++n;
            }
        }
        if (type.equals(CUSTOM_XML_CATEGORY)) {
            customTraceDefinitionArray = CustomXmlTraceDefinition.loadAll();
            n2 = customTraceDefinitionArray.length;
            n = 0;
            while (n < n2) {
                def = customTraceDefinitionArray[n];
                traceTypeName = ((CustomXmlTraceDefinition)def).definitionName;
                traceTypes.add(traceTypeName);
                ++n;
            }
        }
        return traceTypes;
    }

    public static List<String> getCustomTraceTypes() {
        String traceTypeName;
        CustomTraceDefinition def;
        ArrayList<String> traceTypes = new ArrayList<String>();
        CustomTraceDefinition[] customTraceDefinitionArray = CustomTxtTraceDefinition.loadAll();
        int n = customTraceDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            def = customTraceDefinitionArray[n2];
            traceTypeName = def.definitionName;
            traceTypes.add(traceTypeName);
            ++n2;
        }
        customTraceDefinitionArray = CustomXmlTraceDefinition.loadAll();
        n = customTraceDefinitionArray.length;
        n2 = 0;
        while (n2 < n) {
            def = customTraceDefinitionArray[n2];
            traceTypeName = ((CustomXmlTraceDefinition)def).definitionName;
            traceTypes.add(traceTypeName);
            ++n2;
        }
        return traceTypes;
    }

    private static void populateCustomTraceTypes() {
        TraceTypeHelper tt;
        TmfTrace trace;
        String traceTypeId;
        CustomTraceDefinition def;
        CustomTraceDefinition[] customTraceDefinitionArray = CustomTxtTraceDefinition.loadAll();
        int n = customTraceDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            def = customTraceDefinitionArray[n2];
            traceTypeId = String.valueOf(CustomTxtTrace.class.getCanonicalName()) + ':' + def.categoryName + ':' + def.definitionName;
            trace = new CustomTxtTrace((CustomTxtTraceDefinition)def);
            tt = new TraceTypeHelper(traceTypeId, def.categoryName, def.definitionName, trace, false, TraceElementType.TRACE);
            TRACE_TYPES.put(traceTypeId, tt);
            TmfSignalManager.deregister(trace);
            ++n2;
        }
        customTraceDefinitionArray = CustomXmlTraceDefinition.loadAll();
        n = customTraceDefinitionArray.length;
        n2 = 0;
        while (n2 < n) {
            def = customTraceDefinitionArray[n2];
            traceTypeId = String.valueOf(CustomXmlTrace.class.getCanonicalName()) + ':' + ((CustomXmlTraceDefinition)def).categoryName + ':' + ((CustomXmlTraceDefinition)def).definitionName;
            trace = new CustomXmlTrace((CustomXmlTraceDefinition)def);
            tt = new TraceTypeHelper(traceTypeId, ((CustomXmlTraceDefinition)def).categoryName, ((CustomXmlTraceDefinition)def).definitionName, trace, false, TraceElementType.TRACE);
            TRACE_TYPES.put(traceTypeId, tt);
            TmfSignalManager.deregister(trace);
            ++n2;
        }
    }

    @Deprecated
    public static void addCustomTraceType(String category, String definitionName) {
        if (category.equals(CUSTOM_TXT_CATEGORY)) {
            TmfTraceType.addCustomTraceType(CustomTxtTrace.class, category, definitionName);
        } else if (category.equals(CUSTOM_XML_CATEGORY)) {
            TmfTraceType.addCustomTraceType(CustomXmlTrace.class, category, definitionName);
        }
    }

    public static void addCustomTraceType(Class<? extends ITmfTrace> traceClass, String category, String definitionName) {
        CustomTraceDefinition def;
        String traceTypeId = null;
        TmfTrace trace = null;
        if (traceClass.equals(CustomTxtTrace.class)) {
            traceTypeId = String.valueOf(CustomTxtTrace.class.getCanonicalName()) + ':' + category + ':' + definitionName;
            def = CustomTxtTraceDefinition.load(category, definitionName);
            if (def != null) {
                trace = new CustomTxtTrace((CustomTxtTraceDefinition)def);
            }
        } else if (traceClass.equals(CustomXmlTrace.class)) {
            traceTypeId = String.valueOf(CustomXmlTrace.class.getCanonicalName()) + ':' + category + ':' + definitionName;
            def = CustomXmlTraceDefinition.load(category, definitionName);
            if (def != null) {
                trace = new CustomXmlTrace((CustomXmlTraceDefinition)def);
            }
        }
        if (traceTypeId != null && trace != null) {
            TraceTypeHelper helper = TRACE_TYPES.get(traceTypeId);
            if (helper != null) {
                helper.getTrace().dispose();
            }
            TraceTypeHelper tt = new TraceTypeHelper(traceTypeId, category, definitionName, trace, false, TraceElementType.TRACE);
            TRACE_TYPES.put(traceTypeId, tt);
            TmfSignalManager.deregister(trace);
        }
    }

    @Deprecated
    public static void removeCustomTraceType(String category, String definitionName) {
        if (category.equals(CUSTOM_TXT_CATEGORY)) {
            TmfTraceType.removeCustomTraceType(CustomTxtTrace.class, category, definitionName);
        } else if (category.equals(CUSTOM_XML_CATEGORY)) {
            TmfTraceType.removeCustomTraceType(CustomXmlTrace.class, category, definitionName);
        }
    }

    public static void removeCustomTraceType(Class<? extends ITmfTrace> traceClass, String category, String definitionName) {
        String traceTypeId = String.valueOf(traceClass.getCanonicalName()) + ':' + category + ':' + definitionName;
        TraceTypeHelper helper = TRACE_TYPES.remove(traceTypeId);
        if (helper != null) {
            helper.getTrace().dispose();
        }
    }

    public static TraceTypeHelper getTraceType(String id) {
        return TRACE_TYPES.get(id);
    }

    private static void populateCategoriesAndTraceTypes() {
        if (TRACE_TYPES.isEmpty()) {
            IConfigurationElement[] config;
            IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(TMF_TRACE_TYPE_ID);
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement ce = iConfigurationElementArray[n2];
                String elementName = ce.getName();
                if (elementName.equals(TYPE_ELEM)) {
                    String traceTypeId = ce.getAttribute(ID_ATTR);
                    TRACE_TYPE_ATTRIBUTES.put(traceTypeId, ce);
                } else if (elementName.equals("category")) {
                    String categoryId = ce.getAttribute(ID_ATTR);
                    TRACE_CATEGORIES.put(categoryId, ce);
                } else if (elementName.equals(EXPERIMENT_ELEM)) {
                    String experimentTypeId = ce.getAttribute(ID_ATTR);
                    TRACE_TYPE_ATTRIBUTES.put(experimentTypeId, ce);
                }
                ++n2;
            }
            for (String typeId : TRACE_TYPE_ATTRIBUTES.keySet()) {
                IConfigurationElement ce = TRACE_TYPE_ATTRIBUTES.get(typeId);
                String category = TmfTraceType.getCategory(ce);
                String attribute = ce.getAttribute(NAME_ATTR);
                ITmfTrace trace = null;
                TraceElementType elementType = TraceElementType.TRACE;
                try {
                    if (ce.getName().equals(TYPE_ELEM)) {
                        trace = (ITmfTrace)ce.createExecutableExtension(TRACE_TYPE_ATTR);
                    } else if (ce.getName().equals(EXPERIMENT_ELEM)) {
                        trace = (ITmfTrace)ce.createExecutableExtension(EXPERIMENT_TYPE_ATTR);
                        elementType = TraceElementType.EXPERIMENT;
                    }
                    if (trace == null) break;
                    TmfSignalManager.deregister(trace);
                    String dirString = ce.getAttribute(IS_DIR_ATTR);
                    boolean isDir = Boolean.parseBoolean(dirString);
                    TraceTypeHelper tt = new TraceTypeHelper(typeId, category, attribute, trace, isDir, elementType);
                    TRACE_TYPES.put(typeId, tt);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
    }

    private static String getCategory(IConfigurationElement ce) {
        IConfigurationElement category;
        String categoryId = ce.getAttribute("category");
        if (categoryId != null && (category = TRACE_CATEGORIES.get(categoryId)) != null && !category.getName().equals("")) {
            return category.getAttribute(NAME_ATTR);
        }
        return "[no category]";
    }

    public static List<String> getTraceCategories() {
        ArrayList<String> categoryNames = new ArrayList<String>();
        for (String key : TRACE_TYPES.keySet()) {
            String categoryName = TRACE_TYPES.get(key).getCategoryName();
            if (categoryNames.contains(categoryName)) continue;
            categoryNames.add(categoryName);
        }
        return categoryNames;
    }

    public static List<TraceTypeHelper> getTraceTypes(String categoryName) {
        ArrayList<TraceTypeHelper> traceNames = new ArrayList<TraceTypeHelper>();
        for (String key : TRACE_TYPES.keySet()) {
            String storedCategoryName;
            if (TRACE_TYPES.get(key).isExperimentType() || !(storedCategoryName = TRACE_TYPES.get(key).getCategoryName()).equals(categoryName)) continue;
            traceNames.add(TRACE_TYPES.get(key));
        }
        return traceNames;
    }

    public static boolean validate(String traceTypeName, String fileName) {
        TraceTypeHelper traceTypeHelper;
        return traceTypeName == null || traceTypeName.isEmpty() || (traceTypeHelper = TRACE_TYPES.get(traceTypeName)) != null && traceTypeHelper.validate(fileName).isOK();
    }

    public static boolean validate(TraceValidationHelper traceToValidate) {
        return TmfTraceType.validate(traceToValidate.getTraceType(), traceToValidate.getTraceToScan());
    }

    public static boolean validateTraceFiles(String traceTypeName, List<File> traces) {
        if (!(traceTypeName == null || "".equals(traceTypeName) || traceTypeName.startsWith(CUSTOM_TXT_CATEGORY) || traceTypeName.startsWith(CUSTOM_XML_CATEGORY))) {
            for (File trace : traces) {
                if (TmfTraceType.validate(traceTypeName, trace.getAbsolutePath())) continue;
                return false;
            }
        }
        return true;
    }

    public static IConfigurationElement getTraceAttributes(String traceType) {
        return TRACE_TYPE_ATTRIBUTES.get(traceType);
    }

    public static String getTraceTypeId(String category, String traceType) {
        for (String key : TRACE_TYPES.keySet()) {
            if (!TRACE_TYPES.get(key).getCategoryName().equals(category.trim()) || !TRACE_TYPES.get(key).getName().equals(traceType.trim())) continue;
            return key;
        }
        return null;
    }

    @Deprecated
    public static String getCustomTraceTypeId(String traceType) {
        String[] traceTypeToken = traceType.split(":", 2);
        if (traceTypeToken.length == 2) {
            return TmfTraceType.getTraceTypeId(traceTypeToken[0], traceTypeToken[1]);
        }
        return null;
    }

    @Deprecated
    public static boolean isCustomTrace(String traceType) {
        String traceTypeId = TmfTraceType.getCustomTraceTypeId(traceType);
        if (traceTypeId != null) {
            return traceTypeId.startsWith(String.valueOf(CustomTxtTrace.class.getCanonicalName()) + ':') || traceTypeId.startsWith(String.valueOf(CustomXmlTrace.class.getCanonicalName()) + ':');
        }
        return false;
    }

    public static boolean isDirectoryTrace(String path) {
        Iterable<TraceTypeHelper> traceTypeHelpers = TmfTraceType.getTraceTypeHelpers();
        for (TraceTypeHelper traceTypeHelper : traceTypeHelpers) {
            if (!traceTypeHelper.isDirectoryTraceType() || !traceTypeHelper.validate(path).isOK()) continue;
            return true;
        }
        return false;
    }

    public static boolean isDirectoryTraceType(String traceType) {
        if (traceType != null) {
            TraceTypeHelper traceTypeHelper = TmfTraceType.getTraceType(traceType);
            if (traceTypeHelper != null) {
                return traceTypeHelper.isDirectoryTraceType();
            }
            return false;
        }
        throw new IllegalArgumentException("Invalid trace type string: " + traceType);
    }

    public static String getTraceTypeId(IResource resource) throws CoreException {
        int index;
        String traceTypeId = (String)resource.getPersistentProperties().get(TmfCommonConstants.TRACETYPE);
        if (traceTypeId != null && (index = traceTypeId.lastIndexOf(58)) != -1) {
            if (traceTypeId.contains(String.valueOf(CustomTxtTrace.class.getSimpleName()) + ':') && traceTypeId.indexOf(58) == index) {
                traceTypeId = String.valueOf(CustomTxtTrace.class.getCanonicalName()) + ':' + CUSTOM_TXT_CATEGORY + traceTypeId.substring(index);
            } else if (traceTypeId.contains(String.valueOf(CustomXmlTrace.class.getSimpleName()) + ':') && traceTypeId.indexOf(58) == index) {
                traceTypeId = String.valueOf(CustomXmlTrace.class.getCanonicalName()) + ':' + CUSTOM_XML_CATEGORY + traceTypeId.substring(index);
            }
        }
        return traceTypeId;
    }

    public static enum TraceElementType {
        TRACE,
        EXPERIMENT;

    }
}

