/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.statistics;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.ITmfLostEvent;
import org.eclipse.linuxtools.tmf.core.request.ITmfEventRequest;
import org.eclipse.linuxtools.tmf.core.request.TmfEventRequest;
import org.eclipse.linuxtools.tmf.core.statistics.ITmfStatistics;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;

public class TmfEventsStatistics
implements ITmfStatistics {
    private static final int SCALE = -9;
    private final ITmfTrace trace;
    private StatsTotalRequest totalRequest = null;
    private StatsPerTypeRequest perTypeRequest = null;

    public TmfEventsStatistics(ITmfTrace trace) {
        this.trace = trace;
    }

    @Override
    public void dispose() {
        this.cancelOngoingRequests();
    }

    @Override
    public List<Long> histogramQuery(long start, long end, int nb) {
        long[] borders = new long[nb];
        long increment = (end - start) / (long)nb;
        long curTime = start;
        int i = 0;
        while (i < nb) {
            borders[i] = curTime;
            curTime += increment;
            ++i;
        }
        HistogramQueryRequest req = new HistogramQueryRequest(borders, end);
        this.sendAndWait(req);
        LinkedList<Long> results = new LinkedList<Long>(req.getResults());
        return results;
    }

    private synchronized void cancelOngoingRequests() {
        if (this.totalRequest != null && this.totalRequest.isRunning()) {
            this.totalRequest.cancel();
        }
        if (this.perTypeRequest != null && this.perTypeRequest.isRunning()) {
            this.perTypeRequest.cancel();
        }
    }

    @Override
    public long getEventsTotal() {
        StatsTotalRequest request = new StatsTotalRequest(this.trace, TmfTimeRange.ETERNITY);
        this.sendAndWait(request);
        long total = request.getResult();
        return total;
    }

    @Override
    public Map<String, Long> getEventTypesTotal() {
        StatsPerTypeRequest request = new StatsPerTypeRequest(this.trace, TmfTimeRange.ETERNITY);
        this.sendAndWait(request);
        Map<String, Long> stats = request.getResults();
        return stats;
    }

    @Override
    public long getEventsInRange(long start, long end) {
        TmfTimestamp startTS = new TmfTimestamp(start, -9);
        TmfTimestamp endTS = new TmfTimestamp(end, -9);
        TmfTimeRange range = new TmfTimeRange(startTS, endTS);
        StatsTotalRequest request = new StatsTotalRequest(this.trace, range);
        this.sendAndWait(request);
        long total = request.getResult();
        return total;
    }

    @Override
    public Map<String, Long> getEventTypesInRange(long start, long end) {
        TmfTimestamp startTS = new TmfTimestamp(start, -9);
        TmfTimestamp endTS = new TmfTimestamp(end, -9);
        TmfTimeRange range = new TmfTimeRange(startTS, endTS);
        StatsPerTypeRequest request = new StatsPerTypeRequest(this.trace, range);
        this.sendAndWait(request);
        Map<String, Long> stats = request.getResults();
        return stats;
    }

    private void sendAndWait(TmfEventRequest request) {
        this.trace.sendRequest(request);
        try {
            request.waitForCompletion();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private class HistogramQueryRequest
    extends TmfEventRequest {
        private final TreeMap<Long, Long> results;

        public HistogramQueryRequest(long[] borders, long endTime) {
            super(TmfEventsStatistics.this.trace.getEventType(), new TmfTimeRange(new TmfTimestamp(borders[0], -9), new TmfTimestamp(endTime, -9)), 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND);
            this.results = new TreeMap();
            long[] lArray = borders;
            int n = borders.length;
            int n2 = 0;
            while (n2 < n) {
                long border = lArray[n2];
                this.results.put(border, 0L);
                ++n2;
            }
        }

        public Collection<Long> getResults() {
            return this.results.values();
        }

        @Override
        public void handleData(ITmfEvent event) {
            long ts;
            Long key;
            super.handleData(event);
            if (event.getTrace() == TmfEventsStatistics.this.trace && (key = this.results.floorKey(ts = event.getTimestamp().normalize(0L, -9).getValue())) != null) {
                this.incrementValue(key);
            }
        }

        private void incrementValue(Long key) {
            long value = this.results.get(key);
            this.results.put(key, ++value);
        }
    }

    private class StatsPerTypeRequest
    extends TmfEventRequest {
        private final Map<String, Long> stats;

        public StatsPerTypeRequest(ITmfTrace trace, TmfTimeRange range) {
            super(trace.getEventType(), range, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND);
            this.stats = new HashMap<String, Long>();
        }

        public Map<String, Long> getResults() {
            return this.stats;
        }

        @Override
        public void handleData(ITmfEvent event) {
            super.handleData(event);
            if (event.getTrace() == TmfEventsStatistics.this.trace) {
                String eventType = event.getType().getName();
                if (event instanceof ITmfLostEvent) {
                    ITmfLostEvent le = (ITmfLostEvent)event;
                    this.incrementStats(eventType, le.getNbLostEvents());
                    return;
                }
                this.incrementStats(eventType, 1L);
            }
        }

        private void incrementStats(String key, long count) {
            if (this.stats.containsKey(key)) {
                long curValue = this.stats.get(key);
                this.stats.put(key, curValue + count);
            } else {
                this.stats.put(key, count);
            }
        }
    }

    private class StatsTotalRequest
    extends TmfEventRequest {
        private long total;

        public StatsTotalRequest(ITmfTrace trace, TmfTimeRange range) {
            super(trace.getEventType(), range, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND);
            this.total = 0L;
        }

        public long getResult() {
            return this.total;
        }

        @Override
        public void handleData(ITmfEvent event) {
            super.handleData(event);
            if (!(event instanceof ITmfLostEvent) && event.getTrace() == TmfEventsStatistics.this.trace) {
                ++this.total;
            }
        }
    }
}

