/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.statistics;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.linuxtools.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.linuxtools.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.linuxtools.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.linuxtools.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.ITmfLostEvent;
import org.eclipse.linuxtools.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.linuxtools.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.linuxtools.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;

public class TmfStatisticsEventTypesModule
extends TmfStateSystemAnalysisModule {
    @NonNull
    public static final String ID = "org.eclipse.linuxtools.tmf.statistics.types";
    private static final String NAME = "TMF Statistics, events per type";

    public TmfStatisticsEventTypesModule() {
        this.setId(ID);
        this.setName(NAME);
    }

    @Override
    protected ITmfStateProvider createStateProvider() {
        return new StatsProviderEventTypes(this.getTrace());
    }

    @Override
    protected String getSsFileName() {
        return "statistics-types.ht";
    }

    class StatsProviderEventTypes
    extends AbstractTmfStateProvider {
        private static final int VERSION = 2;

        public StatsProviderEventTypes(ITmfTrace trace) {
            super(trace, ITmfEvent.class, TmfStatisticsEventTypesModule.NAME);
        }

        @Override
        public int getVersion() {
            return 2;
        }

        @Override
        public StatsProviderEventTypes getNewInstance() {
            return new StatsProviderEventTypes(this.getTrace());
        }

        @Override
        protected void eventHandle(ITmfEvent event) {
            long ts = event.getTimestamp().normalize(0L, -9).getValue();
            String eventName = event.getType().getName();
            try {
                if (event instanceof ITmfLostEvent) {
                    ITmfLostEvent le = (ITmfLostEvent)event;
                    int quark = this.ss.getQuarkAbsoluteAndAdd(new String[]{"event_types", eventName});
                    int curVal = this.ss.queryOngoingState(quark).unboxInt();
                    if (curVal == -1) {
                        curVal = 0;
                    }
                    TmfStateValue value = TmfStateValue.newValueInt((int)((int)((long)curVal + le.getNbLostEvents())));
                    this.ss.modifyAttribute(ts, (ITmfStateValue)value, quark);
                    return;
                }
                int quark = this.ss.getQuarkAbsoluteAndAdd(new String[]{"event_types", eventName});
                this.ss.incrementAttribute(ts, quark);
            }
            catch (AttributeNotFoundException | StateValueTypeException | TimeRangeException e) {
                e.printStackTrace();
            }
        }
    }
}

