/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.statistics;

import org.eclipse.linuxtools.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.linuxtools.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.linuxtools.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.ITmfLostEvent;
import org.eclipse.linuxtools.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.linuxtools.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.linuxtools.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;

public class TmfStatisticsTotalsModule
extends TmfStateSystemAnalysisModule {
    public static final String ID = "org.eclipse.linuxtools.tmf.statistics.totals";
    private static final String NAME = "TMF Statistics, event totals";

    public TmfStatisticsTotalsModule() {
        this.setId(ID);
        this.setName(NAME);
    }

    @Override
    protected ITmfStateProvider createStateProvider() {
        return new StatsProviderTotals(this.getTrace());
    }

    @Override
    protected String getSsFileName() {
        return "statistics-totals.ht";
    }

    class StatsProviderTotals
    extends AbstractTmfStateProvider {
        private static final int VERSION = 2;

        public StatsProviderTotals(ITmfTrace trace) {
            super(trace, ITmfEvent.class, TmfStatisticsTotalsModule.NAME);
        }

        @Override
        public int getVersion() {
            return 2;
        }

        @Override
        public StatsProviderTotals getNewInstance() {
            return new StatsProviderTotals(this.getTrace());
        }

        @Override
        protected void eventHandle(ITmfEvent event) {
            if (event instanceof ITmfLostEvent) {
                return;
            }
            long ts = event.getTimestamp().normalize(0L, -9).getValue();
            try {
                int quark = this.ss.getQuarkAbsoluteAndAdd(new String[]{"total"});
                this.ss.incrementAttribute(ts, quark);
            }
            catch (AttributeNotFoundException | StateValueTypeException | TimeRangeException e) {
                e.printStackTrace();
            }
        }
    }
}

